/*
 * Decompiled with CFR 0.152.
 */
package fuego.internal.test;

import fuego.internal.test.FuegoSuiteInfo;
import fuego.internal.test.FuegoTestsConstants;
import oracle.bpm.util.ExceptionFormatter;

public class FuegoTestInfo
implements FuegoTestsConstants {
    public double duration;
    public String engineLogLink;
    public String failureMsg;
    public String jiraId;
    public int status;
    public FuegoSuiteInfo suiteInfo;
    public String testName;

    private FuegoTestInfo(FuegoSuiteInfo suiteInfo, String testName, int status, double duration, String failureMsg, String jiraId) {
        this.suiteInfo = suiteInfo;
        this.testName = testName;
        this.status = status;
        this.duration = duration;
        this.failureMsg = failureMsg;
        this.jiraId = jiraId;
        assert (this.isOk() || this.isSkipped() || failureMsg != null) : "if it is not OK or SKIPPED, it must have a failure message!";
    }

    public static FuegoTestInfo createError(FuegoSuiteInfo suiteInfo, String testName, double time, Throwable cause) {
        return new FuegoTestInfo(suiteInfo, testName, -1, time, FuegoTestInfo.stackTrace(cause), null);
    }

    public static FuegoTestInfo createSuccess(FuegoSuiteInfo suiteInfo, String testName, double time) {
        return new FuegoTestInfo(suiteInfo, testName, 1, time, null, null);
    }

    public static FuegoTestInfo createTest(FuegoSuiteInfo suiteInfo, String testName, double time, int status, String cause) {
        return FuegoTestInfo.createTest(suiteInfo, testName, time, status, cause, null);
    }

    public static FuegoTestInfo createTest(FuegoSuiteInfo suiteInfo, String testName, double time, int status, String cause, String jiraId) {
        assert (status == 1 || status == -1 || status == 0 || status == -2);
        assert (status != 1 && status != -2 ? cause != null : cause == null);
        return new FuegoTestInfo(suiteInfo, testName, status, time, cause, jiraId);
    }

    public final boolean isOk() {
        return this.status == 1;
    }

    public final boolean isSkipped() {
        return this.status == -2;
    }

    public String toString() {
        return "TEST :" + this.testName + ":" + this.status + ":" + this.suiteInfo;
    }

    private static String stackTrace(Throwable throwable) {
        return ExceptionFormatter.fullTechLevel(throwable);
    }
}

