/*
 * Decompiled with CFR 0.152.
 */
package fuego.internal.test;

import fuego.internal.test.CoreTestUtils;
import fuego.internal.test.FuegoSuiteInfo;
import fuego.internal.test.FuegoTestInfo;
import fuego.internal.test.FuegoTestsConstants;
import fuego.internal.test.SkippedTestException;
import java.io.OutputStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import oracle.bpm.util.ExceptionFormatter;

public class FuegoResultFormatter
implements FuegoTestsConstants,
TestListener {
    protected FuegoSuiteInfo currentSuiteInfo;
    protected Test currentTest;
    protected String systemOut;
    private Throwable failureThrowable;
    private long lastTestStart = 0L;
    private int status = 1;
    private String systemErr;
    private String testName;

    public void setOutput(OutputStream out) {
    }

    public void setSystemError(String out) {
        this.systemErr = out;
    }

    public void addError(Test test, Throwable t) {
        this.status = -1;
        this.failureThrowable = t;
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.status = 0;
        this.failureThrowable = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTest(Test test) {
        try {
            FuegoTestInfo testInfo;
            assert (test == this.currentTest) : "current test differs from end (" + this.currentTest + " vs " + test + ")";
            double duration = System.currentTimeMillis() - this.lastTestStart;
            if (this.failureThrowable instanceof AssertionFailedError) {
                int i;
                String message = this.failureThrowable.getMessage();
                StackTraceElement[] stackTrace = this.failureThrowable.getStackTrace();
                StringBuilder failStack = new StringBuilder();
                for (i = 0; i < stackTrace.length && "fail".equals(stackTrace[i].getMethodName()); ++i) {
                }
                while (i < stackTrace.length && !stackTrace[i].toString().startsWith("java.lang.reflect.Method.invoke")) {
                    failStack.append("\tat ");
                    failStack.append(stackTrace[i].toString());
                    failStack.append("\n");
                    ++i;
                }
                testInfo = FuegoTestInfo.createTest(this.currentSuiteInfo, this.testName, duration, this.status, message + "\n\nFail Stack:\n" + failStack.toString());
            } else if (this.failureThrowable instanceof SkippedTestException) {
                String jiraId = ((SkippedTestException)this.failureThrowable).getJiraId();
                this.status = -2;
                testInfo = FuegoTestInfo.createTest(this.currentSuiteInfo, this.testName, duration, this.status, null, jiraId);
            } else {
                String cause = this.failureThrowable == null ? null : ExceptionFormatter.fullTechLevel(this.failureThrowable);
                testInfo = FuegoTestInfo.createTest(this.currentSuiteInfo, this.testName, duration, this.status, cause);
            }
            CoreTestUtils.submitTest(testInfo);
        }
        finally {
            this.currentTest = null;
        }
    }

    public void startTest(Test test) {
        assert (this.currentTest == null) : "already a current test " + this.currentTest;
        this.currentTest = test;
        this.lastTestStart = System.currentTimeMillis();
        this.testName = test instanceof TestCase ? ((TestCase)test).getName() : test.toString();
        this.status = 1;
        this.failureThrowable = null;
    }

    public void setSuiteInfo(FuegoSuiteInfo info) {
        this.currentSuiteInfo = info;
    }

    public void startSuiteInfo() {
        CoreTestUtils.startSuite(this.currentSuiteInfo);
    }

    public void stopSuiteInfo() {
        CoreTestUtils.submitSuite(this.currentSuiteInfo, this.getSystemOutAndErr());
    }

    protected String getSystemOutAndErr() {
        return "System Output: \n" + this.systemOut + "\nSystem Error: \n" + this.systemErr;
    }
}

