/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.internal;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.permission.WorkflowAccessPermission;
import oracle.bpel.services.workflow.verification.impl.Token;
import oracle.bpel.services.workflow.verification.impl.WorkflowContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.InternalBPMToken;
import oracle.security.jps.util.JpsAuth;

public class InternalBPMContext
extends WorkflowContext {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "workflowsystem";

    protected InternalBPMContext(Locale locale, Locale displayNameLocale, TimeZone tz) throws Exception {
        super(InternalBPMToken.sFieldMap, (Token)InternalBPMToken.sInternalContextToken, locale, displayNameLocale, tz, (Exception)InternalBPMToken.s_bootstrupException);
    }

    public static IBPMContext getInternalBPMContext() throws BPMException {
        return InternalBPMContext.getInternalBPMContext(Locale.getDefault(), TimeZone.getDefault());
    }

    public static IBPMContext getInternalBPMContext(Locale locale, TimeZone tz) throws BPMException {
        if (InternalBPMToken.s_bootstrupException != null) {
            throw InternalBPMToken.s_bootstrupException;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JpsAuth.checkPermission((Permission)WorkflowAccessPermission.CREATE_INTERNAL_CONTEXT_PERMISSION);
                    return null;
                }
            });
        }
        catch (AccessControlException ace) {
            Object[] errorObjs = new Object[]{"createInternalBPMContext"};
            throw new BPMException(71056, errorObjs, (Throwable)ace);
        }
        catch (PrivilegedActionException pae) {
            Object[] errorObjs = new Object[]{"createInternalBPMContext"};
            throw new BPMException(71056, errorObjs, (Throwable)pae);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        try {
            InternalBPMContext internalBPMContext = new InternalBPMContext(locale, locale, tz);
            return internalBPMContext;
        }
        catch (Exception ex) {
            Object[] errorObjs = new Object[]{"createInternalBPMContext"};
            throw new BPMException(71055, errorObjs, (Throwable)ex);
        }
    }
}

