/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFileUtils {
    private static final Pattern UP_PATTERN = Pattern.compile("^\\.\\./?$");
    private static final Pattern CUR_PATTERN = Pattern.compile("^\\./?|/$");

    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getExtension must not be null");
        }
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        return fileName.substring(dotPos, fileName.length());
    }

    public static String getExtension(@NotNull VFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getExtension must not be null");
        }
        return VFileUtils.getExtension(file.getName());
    }

    public static String getName(@NotNull VFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getName must not be null");
        }
        String fileExtension = VFileUtils.getExtension(file);
        return file.getName().replace(fileExtension, "");
    }

    public static String getName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getName must not be null");
        }
        String[] split = path.split("/");
        return split.length > 0 ? split[split.length - 1] : split[0];
    }

    public static String getFolder(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getFolder must not be null");
        }
        int lastIndex = path.lastIndexOf("/");
        return lastIndex > 0 ? path.substring(0, lastIndex) : path;
    }

    public static boolean dirCopy(@NotNull VFile source, @NotNull VFile destination, @Nullable VFileFilter ext) throws IOException {
        VFile[] files;
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.dirCopy must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.dirCopy must not be null");
        }
        if (!source.isDirectory()) {
            return false;
        }
        if (!destination.exists() && !destination.mkdirs()) {
            return false;
        }
        if (!destination.isDirectory()) {
            return false;
        }
        for (VFile vFile : files = source.listFiles(ext)) {
            VFile newVFile = destination.getFileSystem().createFile(destination, vFile.getName());
            if (!vFile.isDirectory()) {
                VFileUtils.fileCopy(vFile, newVFile);
                continue;
            }
            VFileUtils.dirCopy(vFile, newVFile, ext);
        }
        return true;
    }

    public static VFile changeExtension(@NotNull VFile file, String extension) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.changeExtension must not be null");
        }
        String fileName = file.getName();
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos != -1) {
            fileName = fileName.substring(0, dotPos);
        }
        VFileSystem fs = file.getFileSystem();
        VFile result = VFileUtils.isEmpty(extension) ? fs.createFile(file.getParentFile(), fileName) : (extension.startsWith(".") ? fs.createFile(file.getParentFile(), fileName + extension) : fs.createFile(file.getParentFile(), fileName + '.' + extension));
        return result;
    }

    public static Collection<VFile> getFilesRecursively(@NotNull VFile root, @Nullable VFileFilter filter) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getFilesRecursively must not be null");
        }
        ArrayList<VFile> fileList = new ArrayList<VFile>();
        for (VFile vFile : root.listFiles(filter)) {
            fileList.add(vFile);
            fileList.addAll(VFileUtils.getFilesRecursively(vFile, filter));
        }
        return fileList;
    }

    public static String makePathName(Iterable<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        int length = sb.length();
        if (length > 1 && sb.charAt(length - 1) == '/') {
            sb.deleteCharAt(length - 1);
        }
        return sb.toString();
    }

    public static LinkedList<String> canonicalDecomposition(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.canonicalDecomposition must not be null");
        }
        Matcher up = UP_PATTERN.matcher("");
        Matcher cur = CUR_PATTERN.matcher("");
        LinkedList<String> parts = new LinkedList<String>();
        int last = 0;
        int current = VFileUtils.nextPathElement(location, '/', last);
        while (last < location.length()) {
            String part = location.substring(last, current);
            if (up.reset(part).matches()) {
                if (!parts.isEmpty()) {
                    parts.removeLast();
                }
            } else if ("/".equals(part) && last == 0 || !cur.reset(part).matches()) {
                parts.add(part);
            }
            last = current;
            current = VFileUtils.nextPathElement(location, '/', last);
        }
        if (parts.isEmpty() || !"/".equals(parts.getFirst())) {
            parts.addFirst("/");
        }
        return parts;
    }

    public static String makeRelativePath(@NotNull VFile anchor, @NotNull VFile target) {
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.makeRelativePath must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.makeRelativePath must not be null");
        }
        return VFileUtils.makeRelativePath(anchor.toString(), target.toString());
    }

    public static String makeRelativePath(String anchor, String target) {
        String sp;
        LinkedList<String> anchorElements = VFileUtils.canonicalDecomposition(anchor);
        LinkedList<String> self = VFileUtils.canonicalDecomposition(target);
        ArrayList<String> result = new ArrayList<String>();
        Iterator ita = anchorElements.iterator();
        Iterator its = self.iterator();
        String ap = ita.hasNext() ? (String)ita.next() : null;
        String string = sp = its.hasNext() ? (String)its.next() : null;
        while (ap != null && sp != null && VFileUtils.partEquals(ap, sp)) {
            ap = ita.hasNext() ? (String)ita.next() : null;
            sp = its.hasNext() ? (String)its.next() : null;
        }
        if (ap != null) {
            result.add("../");
        }
        while (ita.hasNext()) {
            ita.next();
            result.add("../");
        }
        if (sp != null) {
            result.add(sp);
        }
        while (its.hasNext()) {
            result.add((String)its.next());
        }
        if (result.isEmpty()) {
            result.add(".");
        }
        return VFileUtils.makePathName(result);
    }

    public static boolean deleteDirectory(@NotNull VFile dirToDelete) throws IOException {
        if (dirToDelete == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.deleteDirectory must not be null");
        }
        return VFileUtils.deleteDirectory(dirToDelete, true);
    }

    public static boolean deleteDirectory(@NotNull VFile dirToDelete, boolean delDir) throws IOException {
        if (dirToDelete == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.deleteDirectory must not be null");
        }
        boolean result = true;
        VFile[] content = dirToDelete.listFiles(null);
        if (content != null) {
            for (VFile file : content) {
                result &= VFileUtils.deleteDirectory(file, delDir);
            }
        } else if (!dirToDelete.isDirectory()) {
            delDir = true;
        } else if (!dirToDelete.exists()) {
            return false;
        }
        if (delDir) {
            result &= dirToDelete.delete();
        }
        return result;
    }

    public static String getCanonicalPath(@NotNull String fullPath) {
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.getCanonicalPath must not be null");
        }
        LinkedList<String> parts = VFileUtils.canonicalDecomposition(fullPath);
        return VFileUtils.makePathName(parts);
    }

    public static boolean fileCopy(@NotNull VFile source, @NotNull VFile destination) {
        BufferedInputStream in;
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.fileCopy must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.fileCopy must not be null");
        }
        try {
            in = new BufferedInputStream(new VFileInputStream(source));
        }
        catch (IOException e) {
            return false;
        }
        return VFileUtils.fileCopy(in, destination);
    }

    public static boolean fileMove(@NotNull VFile source, @NotNull VFile destination) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.fileMove must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.fileMove must not be null");
        }
        return VFileUtils.fileCopy(source, destination) && source.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(@NotNull InputStream source, @NotNull VFile destination) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.fileCopy must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.fileCopy must not be null");
        }
        try {
            try {
                VFileOutputStream out = new VFileOutputStream(destination);
                try {
                    VFileUtils.copy(source, out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                source.close();
            }
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileFiltering(@NotNull VFile from, @NotNull VFile to, @NotNull Filter filter) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.copyFileFiltering must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.copyFileFiltering must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.copyFileFiltering must not be null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new VFileInputStream(from), "UTF-8"));
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new VFileOutputStream(to), "UTF-8"));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    line = filter.filter(line);
                    writer.println(line);
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
    }

    public static long copy(@NotNull InputStream inStream, @NotNull OutputStream outStream) throws IOException {
        int nread;
        if (inStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.copy must not be null");
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.copy must not be null");
        }
        int buffSize = 8192;
        byte[] buff = new byte[8192];
        long transferred = 0L;
        IOException exception = null;
        int len = 0;
        do {
            try {
                nread = inStream.read(buff, len, 8192 - len);
            }
            catch (IOException e) {
                exception = e;
                nread = -1;
            }
            if (!(nread == -1 ? len > 0 : (len += nread) > 4096)) continue;
            outStream.write(buff, 0, len);
            transferred += (long)len;
            len = 0;
        } while (nread != -1);
        if (exception != null) {
            throw exception;
        }
        return transferred;
    }

    private static boolean partEquals(String ap, String sp) {
        int spLen;
        int apLen = ap.length();
        if (Math.abs(apLen - (spLen = sp.length())) > 1) {
            return false;
        }
        for (int i = 0; i < Math.min(apLen, spLen); ++i) {
            if (ap.charAt(i) == sp.charAt(i)) continue;
            return false;
        }
        return !(apLen > spLen && ap.charAt(spLen) != '/' || spLen > apLen && sp.charAt(apLen) != '/');
    }

    private static int nextPathElement(@NotNull String location, char separatorChar, int current) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileUtils.nextPathElement must not be null");
        }
        int index = location.indexOf(separatorChar, current);
        return index == -1 ? location.length() : index + 1;
    }

    private static boolean isEmpty(String target) {
        return target == null || target.trim().isEmpty();
    }

    public static interface Filter {
        public String filter(String var1);

        public static class Factory {
            public static Filter replaceAll(String regex, final String replacement) {
                final Pattern pattern = Pattern.compile(regex);
                return new Filter(){

                    @Override
                    public String filter(String str) {
                        return pattern.matcher(str).replaceAll(replacement);
                    }

                    public String toString() {
                        return "Replacing " + pattern + " by " + replacement;
                    }
                };
            }
        }
    }
}

