/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.shared.styles;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;

public class LabelStyle {
    private boolean clipText = false;
    private Color fontColor = DefaultConstants.D_TEXT_COLOR;
    private boolean fontSizeBestFit = false;
    private Font fontStyle = DefaultConstants.D_TEXT_FONT;
    private int horizontalAlign = DefaultConstants.D_TEXT_HORIZONTAL_ALIGN;
    private int orientation = 0;
    private int verticalAlign = DefaultConstants.D_TEXT_VERTICAL_ALIGN;
    private boolean wrapText = true;

    public LabelStyle() {
    }

    public LabelStyle(Font font, Color color, int h, int v) {
        this.fontStyle = font;
        this.fontColor = color;
        this.horizontalAlign = h & 3;
        this.verticalAlign = v & 3;
    }

    public LabelStyle(Font font, Color color, boolean wrap, boolean clip, boolean bestFit, int h, int v, int orient) {
        this.fontStyle = font;
        this.fontColor = color;
        this.wrapText = wrap;
        this.clipText = clip;
        this.fontSizeBestFit = bestFit;
        this.horizontalAlign = h & 3;
        this.verticalAlign = v & 3;
        this.orientation = (orient & 3) % 3;
    }

    public LabelStyle copy() {
        LabelStyle copy = new LabelStyle(this.fontStyle, this.fontColor, this.wrapText, this.clipText, this.fontSizeBestFit, this.horizontalAlign, this.verticalAlign, this.orientation);
        return copy;
    }

    public void copy(LabelStyle o) {
        this.fontStyle = o.fontStyle;
        this.fontColor = o.fontColor;
        this.clipText = o.clipText;
        this.fontSizeBestFit = o.fontSizeBestFit;
        this.horizontalAlign = o.horizontalAlign;
        this.verticalAlign = o.verticalAlign;
        this.orientation = o.orientation;
    }

    public Font getFont() {
        return this.fontStyle;
    }

    public void setFont(Font value) {
        this.fontStyle = value;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color value) {
        this.fontColor = value;
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean value) {
        this.wrapText = value;
    }

    public int getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(int value) {
        this.horizontalAlign = value & 3;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(int value) {
        this.verticalAlign = value & 3;
    }

    public boolean getClipText() {
        return this.clipText;
    }

    public void setClipText(boolean value) {
        this.clipText = value;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int value) {
        this.orientation = (value & 3) % 3;
    }

    public boolean getFontSizeBestFit() {
        return this.fontSizeBestFit;
    }

    public void setFontSizeBestFit(boolean value) {
        this.fontSizeBestFit = value;
    }
}

