/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.shared.styles;

import java.util.Locale;
import oracle.bpm.chart.msg.ChartMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ChartType implements I18nProvider
{
    COLUMN_CHART(ChartMsg.COLUMN_CHART),
    BAR_CHART(ChartMsg.BAR_CHART),
    AREA_CHART(ChartMsg.AREA_CHART),
    LINE_CHART(ChartMsg.LINE_CHART),
    PIE_CHART(ChartMsg.PIE_CHART),
    BUBBLE_CHART(ChartMsg.BUBBLE_CHART),
    SCATTER_CHART(ChartMsg.SCATTER_CHART),
    HEAT_MAP_CHART(ChartMsg.HEAT_MAP_CHART),
    BAR_CHART_3D(ChartMsg.BAR_CHART_3D),
    COLUMN_CHART_3D(ChartMsg.COLUMN_CHART_3D),
    AREA_CHART_3D(ChartMsg.AREA_CHART_3D),
    LINE_CHART_3D(ChartMsg.LINE_CHART_3D),
    HEAT_MAP_CHART_3D(ChartMsg.HEAT_MAP_CHART_3D),
    PIE_CHART_3D(ChartMsg.PIE_CHART_3D),
    CANDLE_CHART(ChartMsg.CANDLE_CHART),
    STACK_BAR_CHART(ChartMsg.STACK_BAR_CHART),
    STACK_COLUMN_CHART(ChartMsg.STACK_COLUMN_CHART),
    STACK_COLUMN_CHART_3D(ChartMsg.STACK_COLUMN_CHART_3D),
    STACK_BAR_CHART_3D(ChartMsg.STACK_BAR_CHART_3D);

    private transient Msg msg;

    private ChartType(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public int intValue() {
        return this.ordinal();
    }

    public boolean isBar() {
        return this == BAR_CHART;
    }

    public boolean isPie() {
        return this == PIE_CHART || this == PIE_CHART_3D;
    }

    public boolean is3D() {
        return this == COLUMN_CHART_3D || this == BAR_CHART_3D || this == HEAT_MAP_CHART_3D || this == LINE_CHART_3D || this == PIE_CHART_3D;
    }
}

