/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class View3DAppearance
extends ChartTypeAppearance {
    float scale = DefaultConstants.D_VIEW_3D_SCALE;
    int xrot = DefaultConstants.D_VIEW_3D_X;
    int yrot = DefaultConstants.D_VIEW_3D_Y;
    int zrot = DefaultConstants.D_VIEW_3D_Z;
    static final long serialCheck = 4719103361560743577L;
    static final long serialVersionUID = -3559552235718038403L;

    public View3DAppearance() {
    }

    public View3DAppearance(IChartComponent component) {
        super(component);
    }

    public View3DAppearance(int xrot, int yrot, int zrot, int scale) {
        this.xrot = this.fix(xrot);
        this.yrot = this.fix(yrot);
        this.zrot = this.fix(zrot);
        this.scale = scale;
    }

    public int getXRotation() {
        return this.xrot;
    }

    public void setXRotation(int value) {
        this.xrot = this.fix(value);
        this.updateAll(false, true);
    }

    public int getYRotation() {
        return this.yrot;
    }

    public void setYRotation(int value) {
        this.yrot = this.fix(value);
        this.updateAll(false, true);
    }

    public int getZRotation() {
        return this.zrot;
    }

    public void setZRotation(int value) {
        this.zrot = this.fix(value);
        this.updateAll(false, true);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 300.0f) {
            value = 300.0f;
        }
        this.scale = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.xrot != DefaultConstants.D_VIEW_3D_X || this.yrot != DefaultConstants.D_VIEW_3D_Y || this.zrot != DefaultConstants.D_VIEW_3D_Z || this.scale != DefaultConstants.D_VIEW_3D_SCALE;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof View3DAppearance)) {
            return;
        }
        View3DAppearance a = (View3DAppearance)ca;
        if (this.xrot != a.xrot || this.yrot != a.yrot || this.zrot != a.zrot || this.scale != a.scale) {
            this.dirty = true;
        }
        this.xrot = a.xrot;
        this.yrot = a.yrot;
        this.zrot = a.zrot;
        this.scale = a.scale;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }

    int fix(int value) {
        while (value < 0) {
            value += 360;
        }
        while (value >= 360) {
            value -= 360;
        }
        return value;
    }
}

