/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.shared.events.ChartDataEventArgs;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.FontStyle;

public class TooltipAppearance
extends ChartAppearance {
    boolean allPoints = DefaultConstants.D_TOOLTIP_SHOW_ALL_POINTS;
    int alpha = DefaultConstants.D_TOOLTIP_ALPHA;
    Color backColor = DefaultConstants.D_TOOLTIP_BACK_COLOR;
    Color borderColor = DefaultConstants.D_BORDER_COLOR;
    int borderStyle = 0;
    int borderThickness = DefaultConstants.D_BORDER_THICKNESS;
    int display = DefaultConstants.D_TOOLTIP_DISPLAY;
    Font font = DefaultConstants.D_LABEL_FONT;
    Color fontColor = DefaultConstants.D_TEXT_COLOR;
    int format = DefaultConstants.D_TOOLTIP_FORMAT;
    String formatString;
    boolean highlightData = DefaultConstants.D_TOOLTIP_HIGHLIGHT_DATA;
    Color highlightFillColor = DefaultConstants.D_TOOLTIP_HIGHLIGHT_FILL_COLOR;
    Color highlightOutlineColor = DefaultConstants.D_TOOLTIP_HIGHLIGHT_OUTLINE_COLOR;
    boolean highOnTop = DefaultConstants.D_TOOLTIP_HIGHLIGHT_ON_TOP;
    int outlineThickness = DefaultConstants.D_TOOLTIP_HIGHLIGHT_OUTLINE_THICKNESS;
    static final long serialCheck = -6426120557769277940L;
    static final long serialVersionUID = -4197772405587543144L;
    static final int FORMAT = 2;
    static final int BORDER_STYLE = 5;
    static final int BORDER_THICK = 8;
    static final int ALPHA = 12;
    static final int FONT_SIZE = 20;
    static final int OUTLINE = 25;
    static final int HIGHLIGHT = 2048;
    static final int ALL_POINTS = 0x10000000;
    static final int BOLD = 0x20000000;
    static final int ITALIC = 0x40000000;

    public TooltipAppearance() {
    }

    public TooltipAppearance(IChartComponent component) {
        super(component);
    }

    public TooltipAppearance(Color backColor, Color foreColor, Color borderColor, Color highlightColor, Color lineColor, String fontName, String formatString, int flags) {
        if (foreColor != null) {
            this.fontColor = foreColor;
        }
        if (borderColor != null) {
            this.borderColor = borderColor;
        }
        if (backColor != null) {
            this.backColor = backColor;
        }
        if (highlightColor != null) {
            this.highlightFillColor = highlightColor;
        }
        if (lineColor != null) {
            this.highlightOutlineColor = lineColor;
        }
        this.display = MiscFunctions.inRange(flags, 0, 3);
        this.format = MiscFunctions.inRange(flags, 2, 4);
        this.formatString = formatString;
        if (fontName != null && fontName.length() > 1) {
            FontStyle style = MiscFunctions.isSet(flags, 0x20000000) ? FontStyle.BOLD : (MiscFunctions.isSet(flags, 0x40000000) ? FontStyle.ITALIC : FontStyle.PLAIN);
            this.font = Font.valueOf(fontName, style, MiscFunctions.inRange(flags, 20, 31));
        }
        this.alpha = MiscFunctions.inRange(flags, 12, 255);
        this.borderStyle = MiscFunctions.inRange(flags, 5, 4);
        this.borderThickness = MiscFunctions.inRange(flags, 8, 7);
        this.highlightData = MiscFunctions.isSet(flags, 2048);
        this.outlineThickness = MiscFunctions.inRange(flags, 25, 7);
        this.allPoints = MiscFunctions.isSet(flags, 0x10000000);
    }

    public static int toFlag(int style, int format, int borderStyle, int borderThickness, int outlineThickness, boolean highlight, int alpha, int fontSize, boolean bold, boolean italic, boolean allPoints) {
        return MiscFunctions.add(style, 3, 0) | MiscFunctions.add(format, 7, 2) | MiscFunctions.add(borderStyle, 7, 5) | MiscFunctions.add(borderThickness, 7, 8) | MiscFunctions.add(alpha, 255, 12) | MiscFunctions.add(fontSize, 31, 20) | MiscFunctions.add(highlight, 2048) | MiscFunctions.add(bold, 0x20000000) | MiscFunctions.add(italic, 0x40000000) | MiscFunctions.add(outlineThickness, 7, 25) | MiscFunctions.add(allPoints, 0x10000000);
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int value) {
        this.display = value & 3;
        this.updateAll(false, true);
    }

    public boolean getShowAllDataPoints() {
        return this.allPoints;
    }

    public void setShowAllDataPoints(boolean value) {
        this.allPoints = value;
    }

    public boolean getHighlightDataPoint() {
        return this.highlightData;
    }

    public void setHighlightDataPoint(boolean value) {
        this.highlightData = value;
        this.updateAll(false, true);
    }

    public boolean getHighlightOnTop() {
        return this.highOnTop;
    }

    public void setHighlightOnTop(boolean value) {
        this.highOnTop = value;
        this.updateAll(false, true);
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int value) {
        this.format = (value & 7) % 5;
        this.updateAll(false, true);
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String value) {
        this.formatString = value;
        this.updateAll(false, true);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        if (value == null) {
            value = DefaultConstants.D_LABEL_FONT;
        }
        this.font = value;
        this.updateAll(false, true);
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color value) {
        this.fontColor = value;
        this.updateAll(false, true);
    }

    public int getAlphaLevel() {
        return this.alpha;
    }

    public void setAlphaLevel(int value) {
        this.alpha = value & 0xFF;
        this.updateAll(false, true);
    }

    public Color getColor(int flag) {
        Color c = this.highlightOutlineColor;
        if (flag == 0) {
            c = this.backColor;
        } else {
            if (flag == 1) {
                return this.fontColor;
            }
            if (flag == 2) {
                c = this.borderColor;
            } else if (flag == 3) {
                c = this.highlightFillColor;
            }
        }
        return c == null || this.alpha <= 0 ? c : Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int value) {
        this.borderStyle = (value & 7) % 5;
        this.updateAll(false, true);
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int value) {
        if (value > 7) {
            value = 7;
        }
        if (value < 0) {
            value = 0;
        }
        this.borderThickness = value;
        this.updateAll(false, true);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color value) {
        this.borderColor = value;
        this.updateAll(false, true);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color value) {
        this.backColor = value;
        this.updateAll(false, true);
    }

    public Color getHighlightFillColor() {
        return this.highlightFillColor;
    }

    public void setHighlightFillColor(Color value) {
        this.highlightFillColor = value;
        this.updateAll(false, true);
    }

    public Color getHighlightOutlineColor() {
        return this.highlightOutlineColor;
    }

    public void setHighlightOutlineColor(Color value) {
        this.highlightOutlineColor = value;
        this.updateAll(false, true);
    }

    public int getHighlightOutlineThickness() {
        return this.outlineThickness;
    }

    public void setHighlightOutlineThickness(int value) {
        if (value > 7) {
            value = 7;
        }
        if (value < 0) {
            value = 0;
        }
        this.outlineThickness = value;
        this.updateAll(false, true);
    }

    public ChartDataEventArgs getChartInfoFromPoint(int x, int y) {
        return this.component == null ? null : this.component.getChartInfoFromPoint(new Point(x, y));
    }

    public String getString() {
        switch (this.format) {
            case 0: {
                return null;
            }
            case 1: {
                return DefaultConstants.D_TOOLTIP_FORMAT_DATA;
            }
            case 2: {
                return DefaultConstants.D_TOOLTIP_FORMAT_LABEL_PLUS_DATA;
            }
            case 3: {
                return DefaultConstants.D_TOOLTIP_FORMAT_ROW_COLUMN_PLUS_DATA;
            }
        }
        return this.formatString;
    }

    @Override
    public boolean shouldSerialize() {
        return this.alpha != DefaultConstants.D_TOOLTIP_ALPHA || !MiscFunctions.equals(this.backColor, DefaultConstants.D_TOOLTIP_BACK_COLOR) || this.format != DefaultConstants.D_TOOLTIP_FORMAT || !MiscFunctions.equals(this.borderColor, DefaultConstants.D_BORDER_COLOR) || this.borderStyle != 0 || this.allPoints != DefaultConstants.D_TOOLTIP_SHOW_ALL_POINTS || this.borderThickness != DefaultConstants.D_BORDER_THICKNESS || this.display != DefaultConstants.D_TOOLTIP_DISPLAY || this.formatString != null || this.highlightData != DefaultConstants.D_TOOLTIP_HIGHLIGHT_DATA || !MiscFunctions.equals(this.font, DefaultConstants.D_LABEL_FONT) || !MiscFunctions.equals(this.fontColor, DefaultConstants.D_TEXT_COLOR) || this.outlineThickness != DefaultConstants.D_TOOLTIP_HIGHLIGHT_OUTLINE_THICKNESS || !MiscFunctions.equals(this.highlightFillColor, DefaultConstants.D_TOOLTIP_HIGHLIGHT_FILL_COLOR) || !MiscFunctions.equals(this.highlightOutlineColor, DefaultConstants.D_TOOLTIP_HIGHLIGHT_OUTLINE_COLOR) || this.highOnTop != DefaultConstants.D_TOOLTIP_HIGHLIGHT_ON_TOP;
    }

    @Override
    public void copy(Object ta) {
        if (ta == null || !(ta instanceof TooltipAppearance)) {
            return;
        }
        TooltipAppearance a = (TooltipAppearance)ta;
        if (!(this.alpha == a.alpha && MiscFunctions.equals(this.backColor, a.backColor) && this.format == a.format && this.allPoints == a.allPoints && MiscFunctions.equals(this.borderColor, a.borderColor) && this.borderStyle == a.borderStyle && this.highlightData == a.highlightData && this.borderThickness == a.borderThickness && this.display == a.display && MiscFunctions.equals(this.formatString, a.formatString) && MiscFunctions.equals(this.font, a.font) && MiscFunctions.equals(this.fontColor, a.fontColor) && this.outlineThickness == a.outlineThickness && MiscFunctions.equals(this.highlightFillColor, a.highlightFillColor) && MiscFunctions.equals(this.highlightOutlineColor, a.highlightOutlineColor))) {
            this.dirty = true;
        }
        this.alpha = a.alpha;
        this.backColor = a.backColor;
        this.format = a.format;
        this.borderColor = a.borderColor;
        this.borderStyle = a.borderStyle;
        this.highlightData = a.highlightData;
        this.borderThickness = a.borderThickness;
        this.display = a.display;
        this.formatString = a.formatString;
        this.font = a.font;
        this.fontColor = a.fontColor;
        this.highlightFillColor = a.highlightFillColor;
        this.highlightOutlineColor = a.highlightOutlineColor;
        this.outlineThickness = a.outlineThickness;
        this.allPoints = a.allPoints;
        this.highOnTop = a.highOnTop;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

