/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.MarginsAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.FontStyle;

public class TitleAppearance
extends ChartAppearance {
    boolean bestFit = false;
    Color color = DefaultConstants.D_TITLE_FONT_COLOR;
    Font font = DefaultConstants.D_TITLE_FONT;
    int horAlign = DefaultConstants.D_TEXT_HORIZONTAL_ALIGN;
    int vertAlign = DefaultConstants.D_TEXT_VERTICAL_ALIGN;
    boolean wrap = true;
    private MarginsAppearance marginsAppearance;
    private String text;
    private int titlePanel;
    private boolean visible = false;
    private int widthOrHeight = -1;
    static final long serialCheck = -6364846489980560146L;
    static final long serialVersionUID = -8200323165343632230L;
    private static final int FONT_SIZE = 63;
    private static final int BOLD = 64;
    private static final int ITALIC = 128;
    private static final int BEST_FIT = 256;
    private static final int WRAP = 512;
    private static final int VISIBLE = 2048;
    private static final int HORIZ_ALIGN = 12;
    private static final int VERT_ALIGN = 14;
    private static final int TYPE = 16;

    public TitleAppearance() {
        this(null, 0);
    }

    public TitleAppearance(IChartComponent component, int location) {
        super(component);
        this.titlePanel = location;
        this.marginsAppearance = new MarginsAppearance(this, DefaultConstants.D_TITLE_MARGINS);
        this.text = this.defText();
        this.widthOrHeight = this.defExtent();
        this.visible = this.defVisible();
        if (this.titlePanel == 3) {
            this.horAlign = 1;
        }
    }

    public TitleAppearance(String title, String fontName, int extent, int topMargin, int leftMargin, int bottomMargin, int rightMargin, Color color, int flags) {
        this(null, MiscFunctions.inRange(flags, 16, 3));
        this.visible = MiscFunctions.isSet(flags, 2048);
        this.widthOrHeight = extent;
        this.text = title;
        if (fontName != null) {
            FontStyle style = MiscFunctions.isSet(flags, 64) ? FontStyle.BOLD : (MiscFunctions.isSet(flags, 128) ? FontStyle.ITALIC : FontStyle.PLAIN);
            this.font = Font.valueOf(fontName, style, MiscFunctions.inRange(flags, 0, 63));
        }
        this.color = color;
        this.bestFit = MiscFunctions.isSet(flags, 256);
        this.horAlign = MiscFunctions.inRange(flags, 12, 3);
        this.vertAlign = MiscFunctions.inRange(flags, 14, 3);
        this.wrap = MiscFunctions.isSet(flags, 512);
        Insets insets = new Insets(topMargin, leftMargin, bottomMargin, rightMargin);
        this.marginsAppearance.setMargins(insets);
    }

    public static int toFlag(int location, int fontSize, int vertAlign, int horizAlign, boolean bold, boolean italic, boolean bestFit, boolean wrap, boolean visible) {
        return MiscFunctions.add(fontSize, 63, 0) | MiscFunctions.add(location, 3, 16) | MiscFunctions.add(vertAlign, 3, 14) | MiscFunctions.add(horizAlign, 3, 12) | MiscFunctions.add(bold, 64) | MiscFunctions.add(italic, 128) | MiscFunctions.add(bestFit, 256) | MiscFunctions.add(wrap, 512) | MiscFunctions.add(visible, 2048);
    }

    public int getExtent() {
        return this.widthOrHeight;
    }

    public void setExtent(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > DefaultConstants.D_TITLE_EXTENT_MAX) {
            value = DefaultConstants.D_TITLE_EXTENT_MAX;
        }
        this.widthOrHeight = value;
        this.updateAll(true, true);
    }

    public boolean getVisible() {
        return this.visible && this.text != null && this.text.length() > 0;
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.updateAll(true, true);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
        this.updateAll(false, true);
    }

    public MarginsAppearance getMargins() {
        return this.marginsAppearance;
    }

    public void setMargins(MarginsAppearance value) {
        this.marginsAppearance.setMargins(value == null ? DefaultConstants.D_TITLE_MARGINS : value.margins);
        this.updateAll(false, true);
    }

    public Font getFont() {
        return this.font == null ? DefaultConstants.D_TITLE_FONT : this.font;
    }

    public void setFont(Font value) {
        this.font = value;
        this.updateAll(false, true);
    }

    public Color getFontColor() {
        return this.color == null ? DefaultConstants.D_TITLE_FONT_COLOR : this.color;
    }

    public void setFontColor(Color value) {
        this.color = value;
        this.updateAll(false, true);
    }

    public boolean getWrapText() {
        return this.wrap;
    }

    public void setWrapText(boolean value) {
        this.wrap = value;
        this.updateAll(false, true);
    }

    public int getHorizontalAlign() {
        return this.horAlign;
    }

    public void setHorizontalAlign(int value) {
        this.horAlign = value;
        this.updateAll(false, true);
    }

    public int getVerticalAlign() {
        return this.vertAlign;
    }

    public void setVerticalAlign(int value) {
        this.vertAlign = value;
        this.updateAll(false, true);
    }

    public boolean getFontSizeBestFit() {
        return this.bestFit;
    }

    public void setFontSizeBestFit(boolean value) {
        this.bestFit = value;
        this.updateAll(false, true);
    }

    public int getTextOrientation() {
        switch (this.titlePanel) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public int getTitleLocation() {
        return this.titlePanel;
    }

    public void setTitleLocation(int value) {
        this.titlePanel = value;
    }

    @Override
    public boolean shouldSerialize() {
        return this.getExtent() != this.defExtent() || this.bestFit || this.shouldSerializeHorizontalAlign() || !this.wrap || this.visible != this.defVisible() || !MiscFunctions.equals(this.getFontColor(), DefaultConstants.D_TITLE_FONT_COLOR) || !this.defText().equals(this.text) || this.vertAlign != DefaultConstants.D_TEXT_VERTICAL_ALIGN || !MiscFunctions.equals(this.getFont(), DefaultConstants.D_TITLE_FONT) || !MiscFunctions.equals(this.marginsAppearance.margins, DefaultConstants.D_TITLE_MARGINS);
    }

    @Override
    public void copy(Object ta) {
        if (ta == null || !(ta instanceof TitleAppearance)) {
            return;
        }
        TitleAppearance a = (TitleAppearance)ta;
        this.text = a.text;
        this.bestFit = a.bestFit;
        this.wrap = a.wrap;
        this.horAlign = a.horAlign;
        this.vertAlign = a.vertAlign;
        this.font = a.font;
        this.color = a.color;
        this.widthOrHeight = a.widthOrHeight;
        this.visible = a.visible;
        this.marginsAppearance.setMargins(a.marginsAppearance.getMargins());
    }

    boolean shouldSerializeHorizontalAlign() {
        if (this.titlePanel == 3) {
            return this.getHorizontalAlign() != 1;
        }
        return this.getHorizontalAlign() != DefaultConstants.D_TEXT_HORIZONTAL_ALIGN;
    }

    private String defText() {
        if (this.titlePanel == 0) {
            return DefaultConstants.D_TITLE_TOP_TEXT;
        }
        if (this.titlePanel == 1) {
            return DefaultConstants.D_TITLE_LEFT_TEXT;
        }
        if (this.titlePanel == 2) {
            return DefaultConstants.D_TITLE_RIGHT_TEXT;
        }
        return DefaultConstants.D_TITLE_BOTTOM_TEXT;
    }

    private int defExtent() {
        if (this.titlePanel == 0) {
            return DefaultConstants.D_TITLE_TOP_HEIGHT;
        }
        if (this.titlePanel == 1) {
            return DefaultConstants.D_TITLE_LEFT_WIDTH;
        }
        if (this.titlePanel == 2) {
            return DefaultConstants.D_TITLE_RIGHT_WIDTH;
        }
        return DefaultConstants.D_TITLE_BOTTOM_HEIGHT;
    }

    private boolean defVisible() {
        if (this.titlePanel == 0) {
            return DefaultConstants.D_TITLE_TOP_VISIBLE;
        }
        if (this.titlePanel == 1) {
            return DefaultConstants.D_TITLE_LEFT_VISIBLE;
        }
        if (this.titlePanel == 2) {
            return DefaultConstants.D_TITLE_RIGHT_VISIBLE;
        }
        return DefaultConstants.D_TITLE_BOTTOM_VISIBLE;
    }
}

