/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.AppearanceHelper;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;

public class PieLabelAppearance
extends AppearanceHelper {
    Color borderColor = DefaultConstants.D_PIE_CHART_BORDER_COLOR;
    int borderDrawStyle = 0;
    int borderThickness = 0;
    Color fillColor = null;
    Font font = DefaultConstants.D_TEXT_FONT;
    Color fontColor = DefaultConstants.D_TEXT_COLOR;
    String labelFormatString = DefaultConstants.D_PIE_CHART_PERCENT_VALUE;
    boolean labelLines = true;
    int labelLineThickness = 1;
    int lineStyle = 0;
    int pieLabelStyle = 5;
    static final long serialCheck = 3436320773544672165L;
    static final long serialVersionUID = 98556225699998269L;
    public static final int NONE = 0;
    public static final int PERCENT_VALUE = 1;
    public static final int DATA_VALUE = 2;
    public static final int ITEM_LABEL = 3;
    public static final int LABEL_AND_PERCENT = 4;
    public static final int CUSTOM = 5;

    public int getFormat() {
        return this.pieLabelStyle;
    }

    public void setFormat(int value) {
        this.pieLabelStyle = (value & 7) % 6;
        this.updateParentProperty();
    }

    public String getFormatString() {
        return this.labelFormatString;
    }

    public void setFormatString(String value) {
        this.labelFormatString = value;
        this.updateParentProperty();
    }

    public boolean getLeaderLinesVisible() {
        return this.labelLines;
    }

    public void setLeaderLinesVisible(boolean value) {
        this.labelLines = value;
        this.updateParentProperty();
    }

    public int getLeaderLineThickness() {
        return this.labelLineThickness;
    }

    public void setLeaderLineThickness(int value) {
        if (value > DefaultConstants.D_LINE_THICKNESS_MAX) {
            value = DefaultConstants.D_LINE_THICKNESS_MAX;
        }
        this.labelLineThickness = value;
        this.updateParentProperty();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        this.font = value;
        this.updateParentProperty();
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color value) {
        this.fontColor = value;
        this.updateParentProperty();
    }

    public int getLeaderDrawStyle() {
        return this.lineStyle;
    }

    public void setLeaderDrawStyle(int value) {
        this.lineStyle = value;
        this.updateParentProperty();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color value) {
        this.borderColor = value;
        this.updateParentProperty();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color value) {
        this.fillColor = value;
        this.updateParentProperty();
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > DefaultConstants.D_LINE_THICKNESS_MAX) {
            value = DefaultConstants.D_LINE_THICKNESS_MAX;
        }
        this.borderThickness = value;
        this.updateParentProperty();
    }

    public int getBorderDrawStyle() {
        return this.borderDrawStyle;
    }

    public void setBorderDrawStyle(int value) {
        this.borderDrawStyle = (value & 7) % 5;
        this.updateParentProperty();
    }

    @Override
    public boolean shouldSerialize() {
        return !MiscFunctions.equals(this.borderColor, DefaultConstants.D_PIE_CHART_BORDER_COLOR) || this.fillColor != null || !MiscFunctions.equals(this.font, DefaultConstants.D_TEXT_FONT) || !MiscFunctions.equals(this.fontColor, DefaultConstants.D_TEXT_COLOR) || !MiscFunctions.equals(this.labelFormatString, DefaultConstants.D_PIE_CHART_PERCENT_VALUE) || this.pieLabelStyle != 5 || this.borderDrawStyle != 0 || this.borderThickness != 0 || this.lineStyle != 0 || !this.labelLines || this.labelLineThickness != 1;
    }
}

