/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;
import oracle.bpm.chart.resources.appearance.PieLabelAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.FontStyle;

public class PieChartAppearance
extends ChartTypeAppearance {
    boolean breakAllSlices = DefaultConstants.D_PIE_CHART_BREAK_ALL;
    boolean breakAlternatingSlices = DefaultConstants.D_PIE_CHART_BREAK_ALTERNATING;
    int breakDistancePercentage = DefaultConstants.D_PIE_CHART_BREAK_DISTANCE;
    boolean breakOthersSlice = false;
    ArrayList<Point> breakSlices;
    boolean colorBySlice = true;
    int dataRowIndex = DefaultConstants.D_PIE_CHART_DATA_ROW;
    PieLabelAppearance labelAppearance;
    boolean labelsOnPie = DefaultConstants.D_PIE_CHART_LABELS_ON_PIE;
    double othersCategoryPercent = DefaultConstants.D_PIE_CHART_OTHERS_PERCENT;
    int pieThickness = DefaultConstants.D_PIE_CHART_THICKNESS;
    int startAngle = 0;
    static final long serialCheck = 8260380085205057070L;
    static final long serialVersionUID = -4150923785989026734L;
    private static final int OTHERS = 8;
    private static final int LINE_THICK = 12;
    private static final int LABL_STYLE = 16;
    private static final int LINE_STYLE = 20;
    private static final int BREAK_DIST = 25;
    private static final int BORDER_THICK = 32;
    private static final int BORDER_STYLE = 35;
    private static final int START_ANGLE = 38;
    private static final int LBL_ON_PIE = 32;
    private static final int BOLD = 64;
    private static final int ITALIC = 128;
    private static final int BREAK_ALL = 32768;
    private static final int BREAK_ALT = 524288;
    private static final int LINES = 0x800000;
    private static final int BREAK_OTHER = 0x1000000;

    public PieChartAppearance() {
        this(null);
    }

    public PieChartAppearance(IChartComponent component) {
        super(component);
        this.labelAppearance = new PieLabelAppearance();
        this.labelAppearance.parentAppearance = this;
    }

    public PieChartAppearance(Color backColor, Color fontColor, Color lineBorderColor, String format, String fontName, int rowIndex, int pieThickness, long flags) {
        this(null);
        this.dataRowIndex = rowIndex;
        this.startAngle = MiscFunctions.inRange(flags, 38, 511);
        this.breakDistancePercentage = MiscFunctions.inRange(flags, 25, 127);
        this.breakAllSlices = MiscFunctions.isSet(flags, 32768L);
        this.breakAlternatingSlices = MiscFunctions.isSet(flags, 524288L);
        this.othersCategoryPercent = MiscFunctions.inRange(flags, 8, 15);
        this.breakOthersSlice = MiscFunctions.isSet(flags, 0x1000000L);
        this.labelsOnPie = MiscFunctions.isSet(flags, 32L);
        this.pieThickness = pieThickness;
        this.labelAppearance.pieLabelStyle = MiscFunctions.inRange(flags, 16, 5);
        this.labelAppearance.labelLineThickness = MiscFunctions.inRange(flags, 12, 7);
        this.labelAppearance.borderDrawStyle = MiscFunctions.inRange(flags, 35, 4);
        this.labelAppearance.borderThickness = MiscFunctions.inRange(flags, 32, 7);
        this.labelAppearance.labelLines = MiscFunctions.isSet(flags, 0x800000L);
        if (backColor != null) {
            this.labelAppearance.fillColor = backColor;
        }
        if (lineBorderColor != null) {
            this.labelAppearance.borderColor = lineBorderColor;
        }
        if (format != null) {
            this.labelAppearance.labelFormatString = format;
        }
        this.labelAppearance.lineStyle = MiscFunctions.inRange(flags, 20, 4);
        if (fontColor != null) {
            this.labelAppearance.fontColor = fontColor;
        }
        if (fontName != null && fontName.length() > 0) {
            FontStyle style = MiscFunctions.isSet(flags, 64L) ? FontStyle.BOLD : (MiscFunctions.isSet(flags, 128L) ? FontStyle.ITALIC : FontStyle.PLAIN);
            this.labelAppearance.font = Font.valueOf(fontName, style, MiscFunctions.inRange(flags, 0, 31));
        }
    }

    public static long toFlag(long breakDistance, long others, long labelLineThickness, long labelStyle, long lineStyle, long borderStyle, long borderThickness, long startAngle, long fontSize, boolean breakAll, boolean breakAlternate, boolean breakOthers, boolean labelLines, boolean bold, boolean italic, boolean labelsOnPie) {
        return MiscFunctions.add(breakDistance, 127L, 25) | MiscFunctions.add(others, 15L, 8) | MiscFunctions.add(labelLineThickness, 7L, 12) | MiscFunctions.add(labelStyle, 7L, 16) | MiscFunctions.add(lineStyle, 7L, 20) | MiscFunctions.add(borderStyle, 7L, 35) | MiscFunctions.add(borderThickness, 7L, 32) | MiscFunctions.add(startAngle, 511L, 38) | MiscFunctions.add(fontSize, 31L, 0) | (long)MiscFunctions.add(breakAll, 32768) | (long)MiscFunctions.add(breakAlternate, 524288) | (long)MiscFunctions.add(breakOthers, 0x1000000) | (long)MiscFunctions.add(labelLines, 0x800000) | (long)MiscFunctions.add(bold, 64) | (long)MiscFunctions.add(italic, 128) | (long)MiscFunctions.add(labelsOnPie, 32);
    }

    public PieLabelAppearance getLabels() {
        return this.labelAppearance;
    }

    public void setLabels(PieLabelAppearance value) {
        if (value == null) {
            return;
        }
        this.labelAppearance = value;
        this.labelAppearance.parentAppearance = this;
        this.updateAll(false, true);
    }

    public int getRowIndex() {
        return this.dataRowIndex;
    }

    public void setRowIndex(int value) {
        if (value < -1) {
            value = -1;
        }
        this.dataRowIndex = value;
        this.updateAll(false, true);
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(int value) {
        while (value >= 360) {
            value -= 360;
        }
        while (value < 0) {
            value += 360;
        }
        this.startAngle = value;
        this.updateAll(false, true);
    }

    public int getBreakDistancePercentage() {
        return this.breakDistancePercentage;
    }

    public void setBreakDistancePercentage(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.breakDistancePercentage = value;
        this.updateAll(false, true);
    }

    public boolean getBreakAllSlices() {
        return this.breakAllSlices;
    }

    public void setBreakAllSlices(boolean value) {
        this.breakAllSlices = value;
        this.updateAll(false, true);
    }

    public boolean getBreakAlternatingSlices() {
        return this.breakAlternatingSlices;
    }

    public void setBreakAlternatingSlices(boolean value) {
        this.breakAlternatingSlices = value;
        this.updateAll(false, true);
    }

    public boolean getBreakOthersSlice() {
        return this.breakOthersSlice;
    }

    public void setBreakOthersSlice(boolean value) {
        this.breakOthersSlice = value;
        this.updateAll(false, true);
    }

    public double getOthersCategoryPercent() {
        return this.othersCategoryPercent;
    }

    public void setOthersCategoryPercent(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 15.0) {
            value = 15.0;
        }
        this.othersCategoryPercent = value;
        this.updateAll(false, true);
    }

    public boolean getLabelsOnPie() {
        return this.labelsOnPie;
    }

    public void setLabelsOnPie(boolean value) {
        this.labelsOnPie = value;
        this.updateAll(false, true);
    }

    public void breakSlice(int column, boolean breakSlice) {
        this.breakSlice(this.dataRowIndex, column, breakSlice);
    }

    public void breakSlice(int row, int column, boolean breakSlice) {
        Point p;
        if (column < 0) {
            return;
        }
        if (row < 0) {
            row = -1;
        }
        if (this.breakSlices == null) {
            this.breakSlices = new ArrayList();
        }
        int i = this.breakSlices.size();
        while (i-- > 0 && ((p = this.breakSlices.get(i)).getX() != row || p.getY() != column)) {
        }
        if (i >= 0 == breakSlice) {
            return;
        }
        if (breakSlice) {
            this.breakSlices.add(new Point(row, column));
        } else {
            this.breakSlices.remove(i);
        }
        this.updateAll(false, true);
    }

    public boolean isSliceBroken(int row, int column) {
        if (this.breakSlices != null) {
            int i = this.breakSlices.size();
            while (i-- > 0) {
                Point p = this.breakSlices.get(i);
                if (p.getX() >= 0 && p.getX() != row || p.getY() != column) continue;
                return true;
            }
        }
        return false;
    }

    public int getBrokenColumn(int row) {
        if (this.breakSlices != null) {
            int i = this.breakSlices.size();
            while (i-- > 0) {
                Point p = this.breakSlices.get(i);
                if (p.getX() >= 0 && p.getX() != row) continue;
                return p.getY();
            }
        }
        return -1;
    }

    public List<Point> getOnlyExplicitlyBrokenSlices() {
        return this.breakSlices;
    }

    public void breakSliceReset() {
        if (this.breakSlices == null || this.breakSlices.isEmpty()) {
            return;
        }
        this.breakSlices.clear();
        this.updateAll(false, true);
    }

    public int getPieThickness() {
        return this.pieThickness;
    }

    public void setPieThickness(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.pieThickness = value;
        this.updateAll(false, true);
    }

    public boolean getColorBySlice() {
        return this.colorBySlice;
    }

    public void setColorBySlice(boolean value) {
        this.colorBySlice = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.breakAllSlices != DefaultConstants.D_PIE_CHART_BREAK_ALL || this.breakAlternatingSlices != DefaultConstants.D_PIE_CHART_BREAK_ALTERNATING || this.breakDistancePercentage != DefaultConstants.D_PIE_CHART_BREAK_DISTANCE || this.breakOthersSlice || this.dataRowIndex != DefaultConstants.D_PIE_CHART_DATA_ROW || this.labelAppearance.shouldSerialize() || this.othersCategoryPercent != (double)DefaultConstants.D_PIE_CHART_OTHERS_PERCENT || this.pieThickness != DefaultConstants.D_PIE_CHART_THICKNESS || this.labelsOnPie != DefaultConstants.D_PIE_CHART_LABELS_ON_PIE || this.startAngle != 0 || !this.colorBySlice;
    }

    public String getFormatString() {
        switch (this.labelAppearance.pieLabelStyle) {
            case 5: {
                String s = this.labelAppearance.labelFormatString;
                if (s == null || s.length() <= 0) break;
                return s;
            }
            case 3: {
                return DefaultConstants.D_PIE_CHART_ITEM_LABEL;
            }
            case 2: {
                return DefaultConstants.D_PIE_CHART_DATA_VALUE;
            }
            case 4: {
                return DefaultConstants.D_PIE_CHART_LABEL_AND_PERCENT;
            }
            case 0: {
                return "";
            }
        }
        return DefaultConstants.D_PIE_CHART_PERCENT_VALUE;
    }

    @Override
    public void copy(Object pa) {
        if (pa == null || !(pa instanceof PieChartAppearance)) {
            return;
        }
        PieChartAppearance a = (PieChartAppearance)pa;
        if (!(this.dataRowIndex == a.dataRowIndex && this.startAngle == a.startAngle && this.labelsOnPie == a.labelsOnPie && this.labelAppearance.lineStyle == a.labelAppearance.lineStyle && this.labelAppearance.pieLabelStyle == a.labelAppearance.pieLabelStyle && this.labelAppearance.labelLineThickness == a.labelAppearance.labelLineThickness && this.labelAppearance.borderDrawStyle == a.labelAppearance.borderDrawStyle && this.labelAppearance.borderThickness == a.labelAppearance.borderThickness && this.labelAppearance.labelLines == a.labelAppearance.labelLines && MiscFunctions.equals(this.labelAppearance.fontColor, a.labelAppearance.fontColor) && MiscFunctions.equals(this.labelAppearance.font, a.labelAppearance.font) && MiscFunctions.equals(this.labelAppearance.borderColor, a.labelAppearance.borderColor) && MiscFunctions.equals(this.labelAppearance.fillColor, a.labelAppearance.fillColor) && MiscFunctions.equals(this.labelAppearance.labelFormatString, a.labelAppearance.labelFormatString) && this.breakDistancePercentage == a.breakDistancePercentage && this.breakAllSlices == a.breakAllSlices && this.breakOthersSlice == a.breakOthersSlice && this.breakAlternatingSlices == a.breakAlternatingSlices && this.othersCategoryPercent == a.othersCategoryPercent && this.pieThickness == a.pieThickness)) {
            this.dirty = true;
        }
        this.dataRowIndex = a.dataRowIndex;
        this.startAngle = a.startAngle;
        this.labelsOnPie = a.labelsOnPie;
        this.breakDistancePercentage = a.breakDistancePercentage;
        this.breakAllSlices = a.breakAllSlices;
        this.breakAlternatingSlices = a.breakAlternatingSlices;
        this.othersCategoryPercent = a.othersCategoryPercent;
        this.breakOthersSlice = a.breakOthersSlice;
        this.pieThickness = a.pieThickness;
        this.labelAppearance.pieLabelStyle = a.labelAppearance.pieLabelStyle;
        this.labelAppearance.labelLineThickness = a.labelAppearance.labelLineThickness;
        this.labelAppearance.borderDrawStyle = a.labelAppearance.borderDrawStyle;
        this.labelAppearance.borderThickness = a.labelAppearance.borderThickness;
        this.labelAppearance.labelLines = a.labelAppearance.labelLines;
        Color c = a.labelAppearance.fillColor;
        if (c != null) {
            c = Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        this.labelAppearance.fillColor = c;
        c = a.labelAppearance.borderColor;
        if (c != null) {
            c = Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        this.labelAppearance.borderColor = c;
        this.labelAppearance.labelFormatString = a.labelAppearance.labelFormatString;
        this.labelAppearance.lineStyle = a.labelAppearance.lineStyle;
        c = a.labelAppearance.fontColor;
        if (c != null) {
            c = Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        this.labelAppearance.fontColor = c;
        Font f = a.labelAppearance.font;
        if (f != null) {
            f = Font.valueOf(f.getName(), f.getStyle(), f.getSize());
        }
        this.labelAppearance.font = f;
        this.colorBySlice = a.colorBySlice;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

