/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.AppearanceHelper;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.geom.Insets;

public class MarginsAppearance
extends AppearanceHelper {
    Insets margins;
    static final long serialCheck = -5079615254089561417L;
    static final long serialVersionUID = -3541505743134855986L;

    public MarginsAppearance() {
        this.margins = new Insets(0, 0, 0, 0);
    }

    MarginsAppearance(ChartAppearance parent, Insets margins) {
        super(parent);
        this.margins = margins.clone();
    }

    public int getTop() {
        return this.margins.top;
    }

    public void setTop(int value) {
        this.validatePropertyInt("Top", value, 0, DefaultConstants.D_MARGINS_MAX);
        this.margins = new Insets(value, this.margins.left, this.margins.bottom, this.margins.right);
        this.updateParentProperty();
    }

    public int getLeft() {
        return this.margins.left;
    }

    public void setLeft(int value) {
        this.validatePropertyInt("Left", value, 0, DefaultConstants.D_MARGINS_MAX);
        this.margins = new Insets(this.margins.top, value, this.margins.bottom, this.margins.right);
        this.updateParentProperty();
    }

    public int getRight() {
        return this.margins.right;
    }

    public void setRight(int value) {
        this.validatePropertyInt("Right", value, 0, DefaultConstants.D_MARGINS_MAX);
        this.margins = new Insets(this.margins.top, this.margins.left, this.margins.bottom, value);
        this.updateParentProperty();
    }

    public int getBottom() {
        return this.margins.bottom;
    }

    public void setBottom(int value) {
        this.validatePropertyInt("Bottom", value, 0, DefaultConstants.D_MARGINS_MAX);
        this.margins = new Insets(this.margins.top, this.margins.left, value, this.margins.right);
        this.updateParentProperty();
    }

    Insets getMargins() {
        return this.margins;
    }

    void setMargins(Insets ins) {
        this.margins = ins == null ? new Insets(0, 0, 0, 0) : new Insets(ins.top, ins.left, ins.bottom, ins.right);
    }
}

