/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.util.Random;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class LineChartAppearance
extends ChartTypeAppearance {
    public transient int randomAnchor;
    int drawStyle = DefaultConstants.D_LINE_CHART_LINE_STYLE;
    int endStyle = DefaultConstants.D_LINE_CHART_END_ICON;
    int lineThickness = DefaultConstants.D_LINE_CHART_THICKNESS;
    int midPointAnchors = DefaultConstants.D_LINE_CHART_ANCHOR_SIZE;
    int startStyle = DefaultConstants.D_LINE_CHART_START_ICON;
    static final long serialCheck = 7231912250737394769L;
    static final long serialVersionUID = -4506027886467021565L;

    public LineChartAppearance() {
        this(null);
    }

    public LineChartAppearance(IChartComponent component) {
        super(component);
        this.randomAnchor = 2 + new Random().nextInt(6);
    }

    public LineChartAppearance(int thickness, int style, int anchors, int startAnchor, int endAnchor) {
        this(null);
        this.lineThickness = thickness;
        this.drawStyle = style;
        this.midPointAnchors = anchors;
        this.startStyle = startAnchor;
        this.endStyle = endAnchor;
    }

    public int getThickness() {
        return this.lineThickness;
    }

    public void setThickness(int value) {
        if (value > DefaultConstants.D_LINE_THICKNESS_MAX) {
            value = DefaultConstants.D_LINE_THICKNESS_MAX;
        }
        this.lineThickness = value;
        this.updateAll(false, true);
    }

    public int getStartStyle() {
        return this.startStyle;
    }

    public void setStartStyle(int value) {
        if (value == 1) {
            this.randomAnchor = 2 + new Random().nextInt(6);
        }
        this.startStyle = value;
        this.updateAll(false, true);
    }

    public int getEndStyle() {
        return this.endStyle;
    }

    public void setEndStyle(int value) {
        this.endStyle = value;
        this.updateAll(false, true);
    }

    public int getDrawStyle() {
        return this.drawStyle;
    }

    public void setDrawStyle(int value) {
        this.drawStyle = (value & 7) % 5;
        this.updateAll(false, true);
    }

    public int getMidPointAnchors() {
        return this.midPointAnchors;
    }

    public void setMidPointAnchors(int value) {
        this.midPointAnchors = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.drawStyle != DefaultConstants.D_LINE_CHART_LINE_STYLE || this.endStyle != DefaultConstants.D_LINE_CHART_END_ICON || this.midPointAnchors != DefaultConstants.D_LINE_CHART_ANCHOR_SIZE || this.startStyle != DefaultConstants.D_LINE_CHART_START_ICON || this.lineThickness != DefaultConstants.D_LINE_CHART_THICKNESS;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof LineChartAppearance)) {
            return;
        }
        LineChartAppearance a = (LineChartAppearance)ca;
        if (this.lineThickness != a.lineThickness || this.startStyle != a.startStyle || this.endStyle != a.endStyle || this.drawStyle != a.drawStyle || this.midPointAnchors != a.midPointAnchors) {
            this.dirty = true;
        }
        this.lineThickness = a.lineThickness;
        if (this.startStyle != a.startStyle && this.startStyle == 1) {
            this.randomAnchor = 2 + new Random().nextInt(6);
        }
        this.startStyle = a.startStyle;
        this.endStyle = a.endStyle;
        this.drawStyle = a.drawStyle;
        this.midPointAnchors = a.midPointAnchors;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

