/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.MarginsAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Insets;

public class LegendAppearance
extends ChartAppearance {
    private int alpha = DefaultConstants.D_COLOR_ALPHA;
    private Color backgroundColor = DefaultConstants.D_LEGEND_BACKGROUND;
    private Color borderColor = DefaultConstants.D_LEGEND_BORDER_COLOR;
    private int borderThickness = DefaultConstants.D_LEGEND_BORDER_THICKNESS;
    private int drawStyle = DefaultConstants.D_LEGEND_BORDER_STYLE;
    private Color fontColor = DefaultConstants.D_LEGEND_TEXT_COLOR;
    private Font fontStyle = DefaultConstants.D_LEGEND_FONT;
    private String formatString = DefaultConstants.D_LEGEND_FORMAT;
    private int location = DefaultConstants.D_LEGEND_LOCATION;
    private MarginsAppearance marginsAppearance;
    private boolean visible = DefaultConstants.D_LEGEND_VISIBLE;
    private int widthOrHeightPercentage = DefaultConstants.D_LEGEND_SPAN;
    static final long serialCheck = -8311461928247102937L;
    static final long serialVersionUID = -2737724860376361705L;

    public LegendAppearance() {
        this(null);
    }

    public LegendAppearance(IChartComponent component) {
        super(component);
        this.marginsAppearance = new MarginsAppearance(this, DefaultConstants.D_LEGEND_MARGINS);
    }

    public LegendAppearance(boolean visible, int location, int alpha, int span, int borderStyle, int borderThickness, Color backColor, Color fontColor, Color borderColor, Insets margin, Font font) {
        this.visible = visible;
        this.alpha = alpha;
        this.location = location;
        this.alpha = alpha;
        this.widthOrHeightPercentage = span;
        this.drawStyle = borderStyle;
        this.borderThickness = borderThickness;
        if (backColor != null) {
            this.backgroundColor = backColor;
        }
        if (fontColor != null) {
            this.fontColor = fontColor;
        }
        if (borderColor != null) {
            this.borderColor = borderColor;
        }
        this.marginsAppearance = margin != null ? new MarginsAppearance(this, margin) : new MarginsAppearance(this, DefaultConstants.D_LEGEND_MARGINS);
        if (font != null) {
            this.fontStyle = font;
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.updateAll(true, true);
    }

    public void setVisibleWithNoUpdate(boolean value) {
        this.visible = value;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int value) {
        this.location = value;
        this.updateAll(true, true);
    }

    public int getSpanPercentage() {
        return this.widthOrHeightPercentage;
    }

    public void setSpanPercentage(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.widthOrHeightPercentage = value;
        this.updateAll(true, true);
    }

    public Font getFont() {
        return this.fontStyle;
    }

    public void setFont(Font value) {
        this.fontStyle = value;
        this.updateAll(false, true);
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color value) {
        this.fontColor = value;
        this.updateAll(false, true);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color value) {
        this.backgroundColor = value;
        this.updateAll(false, true);
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > DefaultConstants.D_LINE_THICKNESS_MAX) {
            value = DefaultConstants.D_LINE_THICKNESS_MAX;
        }
        this.borderThickness = value;
        this.updateAll(false, true);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color value) {
        this.borderColor = value;
        this.updateAll(false, true);
    }

    public MarginsAppearance getMargins() {
        return this.marginsAppearance;
    }

    public void setMargins(MarginsAppearance value) {
        this.marginsAppearance.setMargins(value == null ? DefaultConstants.D_LEGEND_MARGINS : value.margins);
        this.updateAll(false, true);
    }

    public int getBorderStyle() {
        return this.drawStyle;
    }

    public void setBorderStyle(int value) {
        this.drawStyle = value;
        this.updateAll(false, true);
    }

    public int getAlphaLevel() {
        return this.alpha;
    }

    public void setAlphaLevel(int value) {
        this.alpha = value;
        this.updateAll(false, true);
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String value) {
        this.formatString = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.alpha != DefaultConstants.D_COLOR_ALPHA || !MiscFunctions.equals(this.backgroundColor, DefaultConstants.D_LEGEND_BACKGROUND) || !MiscFunctions.equals(this.borderColor, DefaultConstants.D_LEGEND_BORDER_COLOR) || this.drawStyle != DefaultConstants.D_LEGEND_BORDER_STYLE || this.borderThickness != DefaultConstants.D_LEGEND_BORDER_THICKNESS || !MiscFunctions.equals(this.fontStyle, DefaultConstants.D_LEGEND_FONT) || !MiscFunctions.equals(this.fontColor, DefaultConstants.D_LEGEND_TEXT_COLOR) || !MiscFunctions.equals(this.formatString, DefaultConstants.D_LEGEND_FORMAT) || this.location != DefaultConstants.D_LEGEND_LOCATION || this.shouldSerializeMargins() || this.widthOrHeightPercentage != DefaultConstants.D_LEGEND_SPAN || this.visible != DefaultConstants.D_LEGEND_VISIBLE;
    }

    @Override
    public void copy(Object la) {
        if (la == null || !(la instanceof LegendAppearance)) {
            return;
        }
        LegendAppearance a = (LegendAppearance)la;
        this.location = a.location;
        this.fontStyle = a.fontStyle;
        this.fontColor = a.fontColor;
        this.backgroundColor = a.backgroundColor;
        this.borderColor = a.borderColor;
        this.formatString = a.formatString;
        this.widthOrHeightPercentage = a.widthOrHeightPercentage;
        this.borderThickness = a.borderThickness;
        this.drawStyle = a.drawStyle;
        this.visible = a.visible;
        this.alpha = a.alpha;
        this.marginsAppearance.setMargins(a.marginsAppearance.margins);
    }

    private boolean shouldSerializeMargins() {
        return this.marginsAppearance.getTop() != DefaultConstants.D_LEGEND_MARGINS.top || this.marginsAppearance.getLeft() != DefaultConstants.D_LEGEND_MARGINS.left || this.marginsAppearance.getRight() != DefaultConstants.D_LEGEND_MARGINS.right || this.marginsAppearance.getBottom() != DefaultConstants.D_LEGEND_MARGINS.bottom;
    }
}

