/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.util.ArrayList;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;

public class DataAppearance
extends ChartAppearance
implements TableModelListener {
    Object maxValue;
    Object minValue;
    private transient String[] columnLabels = null;
    private boolean dataBindCalled = false;
    private Object dataSource = null;
    private TableModel dataTable = null;
    private ArrayList<Integer> excludedColumns;
    private ArrayList<Integer> excludedRows;
    private ArrayList<Integer> includedColumns;
    private ArrayList<Integer> includedRows;
    private transient boolean noUpdate = false;
    private transient String[] rowLabels = null;
    private int rowLabelsColumn = -1;
    private boolean swapRowsAndColumns = false;
    private boolean useRowLabelsColumn = false;
    private boolean zeroAlign = true;
    static final long serialCheck = 2219171258907686024L;
    static final long serialVersionUID = 3128009170689399388L;

    public DataAppearance() {
    }

    public DataAppearance(IChartComponent component) {
        super(component);
    }

    public DataAppearance(boolean useRowLabelsCol, int rowLabelCol, boolean swapRowCol, boolean zeroAlign) {
        this.setUseRowLabelsColumn(useRowLabelsCol);
        this.setRowLabelsColumn(rowLabelCol);
        this.setSwapRowsAndColumns(swapRowCol);
        this.setZeroAligned(zeroAlign);
    }

    public boolean getDataBindCalled() {
        return this.dataBindCalled;
    }

    public void setDataBindCalled(boolean flag) {
        this.dataBindCalled = flag;
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Object value) {
        if (!ChartDataAdapter.isValid(value)) {
            throw new IllegalArgumentException("Data should be an instance of TableModel, JTable, Object[] or List");
        }
        this.dataBindCalled = value != null;
        this.dataSource = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object value) {
        this.minValue = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object value) {
        this.maxValue = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public boolean getUseRowLabelsColumn() {
        return this.useRowLabelsColumn;
    }

    public void setUseRowLabelsColumn(boolean value) {
        this.useRowLabelsColumn = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public void setUseRowLabelsColumnWithNoUpdate(boolean value) {
        this.useRowLabelsColumn = value;
        this.setDirty(true);
    }

    public int getRowLabelsColumn() {
        return this.rowLabelsColumn;
    }

    public void setRowLabelsColumn(int value) {
        this.rowLabelsColumn = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public void setRowLabels(String[] labelStrings) {
        this.rowLabels = labelStrings;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public String[] getRowLabels() {
        return this.rowLabels;
    }

    public void setColumnLabels(String[] labelStrings) {
        this.columnLabels = labelStrings;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public String[] getColumnLabels() {
        return this.columnLabels;
    }

    public void includeColumn(int column, boolean include) {
        if (column < 0) {
            this.excludedColumns = null;
            this.includedColumns = null;
        } else {
            Integer i = column;
            if (this.includedColumns != null) {
                if (this.includedColumns.contains(i)) {
                    if (!include) {
                        this.includedColumns.remove(i);
                    }
                    i = null;
                }
            } else if (include) {
                this.includedColumns = new ArrayList();
            }
            if (this.excludedColumns != null) {
                if (this.excludedColumns.contains(i)) {
                    if (include) {
                        this.excludedColumns.remove(i);
                    }
                    i = null;
                }
            } else if (!include) {
                this.excludedColumns = new ArrayList();
            }
            if (i != null) {
                if (include) {
                    this.includedColumns.add(i);
                } else {
                    this.excludedColumns.add(i);
                }
            }
        }
        if (!this.noUpdate) {
            this.setDirty(true);
            this.updateAll(false, true);
        }
    }

    public void includeColumns(int col1, int col2, boolean include) {
        this.noUpdate = true;
        if (col1 > col2) {
            int i = col1;
            col1 = col2;
            col2 = i;
        }
        while (col1 <= col2) {
            this.includeColumn(col1++, include);
        }
        this.noUpdate = false;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public boolean isColumnExcluded(int column) {
        if (this.excludedColumns != null && this.excludedColumns.contains(column)) {
            return true;
        }
        if (this.includedColumns != null && !this.includedColumns.isEmpty()) {
            return !this.includedColumns.contains(column);
        }
        return column < 0;
    }

    public void includeRow(int row, boolean include) {
        if (row < 0) {
            this.excludedRows = null;
            this.includedRows = null;
        } else {
            Integer i = row;
            if (this.includedRows != null) {
                if (this.includedRows.contains(i)) {
                    if (!include) {
                        this.includedRows.remove(i);
                    }
                    i = null;
                }
            } else if (include) {
                this.includedRows = new ArrayList();
            }
            if (this.excludedRows != null) {
                if (this.excludedRows.contains(i)) {
                    if (include) {
                        this.excludedRows.remove(i);
                    }
                    i = null;
                }
            } else if (!include) {
                this.excludedRows = new ArrayList();
            }
            if (i != null) {
                if (include) {
                    this.includedRows.add(i);
                } else {
                    this.excludedRows.add(i);
                }
            }
        }
        if (!this.noUpdate) {
            this.setDirty(true);
            this.updateAll(false, true);
        }
    }

    public void includeRows(int row1, int row2, boolean include) {
        this.noUpdate = true;
        if (row1 > row2) {
            int i = row1;
            row1 = row2;
            row2 = i;
        }
        while (row1 <= row2) {
            this.includeRow(row1++, include);
        }
        this.noUpdate = false;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public boolean isRowIncluded(int row) {
        if (this.excludedRows != null && this.excludedRows.contains(row)) {
            return false;
        }
        if (this.includedRows != null && !this.includedRows.isEmpty()) {
            return this.includedRows.contains(row);
        }
        return row >= 0;
    }

    public boolean getSwapRowsAndColumns() {
        return this.swapRowsAndColumns;
    }

    public void setSwapRowsAndColumns(boolean value) {
        this.swapRowsAndColumns = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public boolean getZeroAligned() {
        return this.zeroAlign;
    }

    public void setZeroAligned(boolean value) {
        this.zeroAlign = value;
        this.setDirty(true);
        this.updateAll(false, true);
    }

    public void dataBind() {
        this.setDirty(true);
        this.updateAll(false, true);
        this.setDataBindCalled(true);
    }

    public void initializeAppearance(IChartData data) {
        TableModel table = null;
        if (this.dataSource instanceof TableModel) {
            table = (TableModel)this.dataSource;
        } else if (this.dataSource instanceof Table) {
            table = ((Table)this.dataSource).getModel();
        }
        if (this.dataTable != null) {
            if (!this.dataTable.equals(table)) {
                this.dataTable.removeTableModelListener(this);
                if (table != null) {
                    table.addTableModelListener(this);
                }
            }
        } else if (table != null) {
            table.addTableModelListener(this);
        }
        this.dataTable = table;
    }

    @Override
    public boolean shouldSerialize() {
        return this.dataSource != null || this.rowLabelsColumn >= 0 || this.swapRowsAndColumns || this.useRowLabelsColumn || !this.zeroAlign;
    }

    public String toString() {
        return this.dataSource != null ? this.dataSource.toString() : DefaultConstants.D_MISSING_STRING;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.dataBind();
    }
}

