/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.io.Serializable;
import oracle.bpm.chart.resources.IChartComponent;

public abstract class ChartAppearance
implements Serializable {
    transient IChartComponent component;
    transient boolean dirty = false;
    transient boolean noUpdate = false;
    static final long serialCheck = 902414618530655154L;
    static final long serialVersionUID = -3437009324393338837L;

    public ChartAppearance() {
    }

    public ChartAppearance(IChartComponent component) {
        this.component = component;
    }

    public void setComponent(IChartComponent component) {
        this.component = component;
    }

    public IChartComponent getComponent() {
        return this.component;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setNoUpdate(boolean noUpdate) {
        this.noUpdate = noUpdate;
    }

    public boolean getNoUpdate() {
        return this.noUpdate;
    }

    public boolean shouldSerialize() {
        return false;
    }

    public void copy(Object ca) {
    }

    protected void updateAll(boolean resize, boolean invalidate) {
        if (!this.noUpdate && this.component != null) {
            if (resize) {
                this.component.resizeAll();
            }
            if (invalidate) {
                this.component.invalidate(1);
            }
        }
    }

    void validatePropertyInt(String propName, int propValue, int minValue, int maxValue) {
        if (propValue < minValue || propValue > maxValue) {
            String propMsg = "Value out of bounds";
            throw new IndexOutOfBoundsException(propMsg);
        }
    }

    void ValidatePropertyDouble(String propName, double propValue, double minValue, double maxValue) {
        if (propValue < minValue || propValue > maxValue) {
            String propMsg = "Value out of bounds";
            throw new IndexOutOfBoundsException(propMsg);
        }
    }
}

