/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;
import oracle.bpm.draw.Color;

public class CandleChartAppearance
extends ChartTypeAppearance {
    boolean highLow = DefaultConstants.D_CANDLE_CHART_HIGH_LOW;
    Color highLowLineColor = DefaultConstants.D_CANDLE_CHART_LINE_COLOR;
    int highLowThickness = DefaultConstants.D_CANDLE_CHART_LINE_THICKNESS;
    Color negativeColor = DefaultConstants.D_CANDLE_CHART_NEGATIVE_RANGE_COLOR;
    boolean openClose = DefaultConstants.D_CANDLE_CHART_OPEN_CLOSE;
    Color positiveColor = DefaultConstants.D_CANDLE_CHART_POSITIVE_RANGE_COLOR;
    int skipN = DefaultConstants.D_CANDLE_CHART_SKIP_N;
    boolean volume = DefaultConstants.D_CANDLE_CHART_SHOW_VOLUME;
    Color volumeColor = DefaultConstants.D_CANDLE_CHART_VOLUME_BAR_COLOR;
    static final long serialCheck = 3383080556259259320L;
    static final long serialVersionUID = 8017300892385120766L;

    public CandleChartAppearance() {
    }

    public CandleChartAppearance(IChartComponent component) {
        super(component);
    }

    public CandleChartAppearance(Color positiveColor, Color negativeColor, Color highLowLineColor, Color volumeColor, int thickness, int skipDates, boolean showVolumeColumns, boolean showOpenClose, boolean showHighLow) {
        this.positiveColor = positiveColor;
        this.negativeColor = negativeColor;
        this.highLowLineColor = highLowLineColor;
        this.volumeColor = volumeColor;
        this.highLowThickness = thickness;
        this.skipN = skipDates;
        this.volume = showVolumeColumns;
        this.openClose = showOpenClose;
        this.highLow = showHighLow;
    }

    public Color getPositiveRangeColor() {
        return this.positiveColor == null ? DefaultConstants.D_CANDLE_CHART_POSITIVE_RANGE_COLOR : this.positiveColor;
    }

    public void setPositiveRangeColor(Color value) {
        this.positiveColor = value;
        this.updateAll(false, true);
    }

    public Color getNegativeRangeColor() {
        return this.negativeColor == null ? DefaultConstants.D_CANDLE_CHART_NEGATIVE_RANGE_COLOR : this.negativeColor;
    }

    public void setNegativeRangeColor(Color value) {
        this.negativeColor = value;
        this.updateAll(false, true);
    }

    public Color getWickColor() {
        return this.highLowLineColor == null ? DefaultConstants.D_CANDLE_CHART_LINE_COLOR : this.highLowLineColor;
    }

    public void setWickColor(Color value) {
        this.highLowLineColor = value;
        this.updateAll(false, true);
    }

    public Color getVolumeColor() {
        return this.volumeColor == null ? DefaultConstants.D_CANDLE_CHART_VOLUME_BAR_COLOR : this.volumeColor;
    }

    public void setVolumeColor(Color value) {
        this.volumeColor = value;
        this.updateAll(false, true);
    }

    public int getWickThickness() {
        return this.highLowThickness;
    }

    public void setWickThickness(int value) {
        this.highLowThickness = value;
        this.updateAll(false, true);
    }

    public boolean getVolumeVisible() {
        return this.volume;
    }

    public void setVolumeVisible(boolean value) {
        this.volume = value;
        this.updateAll(false, true);
    }

    public boolean getHighLowVisible() {
        return this.highLow;
    }

    public void setHighLowVisible(boolean value) {
        this.highLow = value;
        this.updateAll(false, true);
    }

    public boolean getOpenCloseVisible() {
        return this.openClose;
    }

    public void setOpenCloseVisible(boolean value) {
        this.openClose = value;
        this.updateAll(false, true);
    }

    public int getSkipN() {
        return this.skipN;
    }

    public void setSkipN(int value) {
        this.skipN = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.highLow != DefaultConstants.D_CANDLE_CHART_HIGH_LOW || this.openClose != DefaultConstants.D_CANDLE_CHART_OPEN_CLOSE || !MiscFunctions.equals(this.getNegativeRangeColor(), DefaultConstants.D_CANDLE_CHART_NEGATIVE_RANGE_COLOR) || !MiscFunctions.equals(this.getPositiveRangeColor(), DefaultConstants.D_CANDLE_CHART_POSITIVE_RANGE_COLOR) || !MiscFunctions.equals(this.getVolumeColor(), DefaultConstants.D_CANDLE_CHART_VOLUME_BAR_COLOR) || !MiscFunctions.equals(this.getWickColor(), DefaultConstants.D_CANDLE_CHART_LINE_COLOR) || this.volume != DefaultConstants.D_CANDLE_CHART_SHOW_VOLUME || this.skipN != DefaultConstants.D_CANDLE_CHART_SKIP_N || this.highLowThickness != DefaultConstants.D_CANDLE_CHART_LINE_THICKNESS;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof CandleChartAppearance)) {
            return;
        }
        CandleChartAppearance a = (CandleChartAppearance)ca;
        if (!(MiscFunctions.equals(this.positiveColor, a.positiveColor) && MiscFunctions.equals(this.negativeColor, a.negativeColor) && MiscFunctions.equals(this.highLowLineColor, a.highLowLineColor) && MiscFunctions.equals(this.volumeColor, a.volumeColor) && this.highLowThickness == a.highLowThickness && this.volume == a.volume && this.openClose == a.openClose && this.highLow == a.highLow && this.skipN == a.skipN)) {
            this.dirty = true;
        }
        this.positiveColor = a.positiveColor;
        this.negativeColor = a.negativeColor;
        this.highLowLineColor = a.highLowLineColor;
        this.volumeColor = a.volumeColor;
        this.highLowThickness = a.highLowThickness;
        this.volume = a.volume;
        this.openClose = a.openClose;
        this.highLow = a.highLow;
        this.skipN = a.skipN;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

