/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class BubbleChartAppearance
extends ChartTypeAppearance {
    private int bblShape = DefaultConstants.D_BUBBLE_CHART_SHAPE;
    private int columnColorCue = DefaultConstants.D_BUBBLE_CHART_COLUMN_CUE;
    private int columnX = DefaultConstants.D_BUBBLE_CHART_COLUMN_X;
    private int columnY = DefaultConstants.D_BUBBLE_CHART_COLUMN_Y;
    private int columnZ = DefaultConstants.D_BUBBLE_CHART_COLUMN_Z;
    static final long serialCheck = 8780579224343136400L;
    static final long serialVersionUID = 1609006812487907812L;
    public static final int TRIANGLE = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int INVERTED_TRIANGLE = 3;

    public BubbleChartAppearance() {
    }

    public BubbleChartAppearance(IChartComponent component) {
        super(component);
    }

    public BubbleChartAppearance(int colX, int colY, int colZ, int colC, int bblShape) {
        this.setColumnX(colX);
        this.setColumnY(colY);
        this.setColumnZ(colZ);
        this.setColorCueColumn(colC);
        this.setBubbleShape(bblShape);
    }

    public int getColorCueColumn() {
        return this.columnColorCue;
    }

    public void setColorCueColumn(int value) {
        this.columnColorCue = value;
        this.updateAll(false, true);
    }

    public int getColumnX() {
        return this.columnX;
    }

    public void setColumnX(int value) {
        if (value >= 0) {
            this.columnX = value;
        }
        this.updateAll(false, true);
    }

    public int getColumnY() {
        return this.columnY;
    }

    public void setColumnY(int value) {
        if (value >= 0) {
            this.columnY = value;
        }
        this.updateAll(false, true);
    }

    public int getColumnZ() {
        return this.columnZ;
    }

    public void setColumnZ(int value) {
        if (value >= 0) {
            this.columnZ = value;
        }
        this.updateAll(false, true);
    }

    public int getBubbleShape() {
        return this.bblShape;
    }

    public void setBubbleShape(int value) {
        this.bblShape = value & 3;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.bblShape != DefaultConstants.D_BUBBLE_CHART_SHAPE || this.columnZ != DefaultConstants.D_BUBBLE_CHART_COLUMN_Z || this.columnX != DefaultConstants.D_BUBBLE_CHART_COLUMN_X || this.columnY != DefaultConstants.D_BUBBLE_CHART_COLUMN_Y || this.columnColorCue != DefaultConstants.D_BUBBLE_CHART_COLUMN_CUE;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof BubbleChartAppearance)) {
            return;
        }
        BubbleChartAppearance a = (BubbleChartAppearance)ca;
        if (this.columnX != a.columnX || this.columnY != a.columnY || this.columnZ != a.columnZ || this.bblShape != a.bblShape || this.columnColorCue != a.columnColorCue) {
            this.dirty = true;
        }
        this.columnX = a.columnX;
        this.columnY = a.columnY;
        this.columnZ = a.columnZ;
        this.bblShape = a.bblShape;
        this.columnColorCue = a.columnColorCue;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

