/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.draw.Color;

public class BorderAppearance
extends ChartAppearance {
    Color color = DefaultConstants.D_BORDER_COLOR;
    int lineStyle = 0;
    int thickness = DefaultConstants.D_BORDER_THICKNESS;
    static final long serialCheck = -6782118890998989001L;
    static final long serialVersionUID = 1737448528115635335L;

    public BorderAppearance() {
    }

    public BorderAppearance(IChartComponent component) {
        super(component);
    }

    public BorderAppearance(Color color, int width, int style) {
        this.color = color;
        this.thickness = width;
        this.lineStyle = style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
        this.updateAll(false, true);
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int value) {
        this.validatePropertyInt("Thickness", value, 0, DefaultConstants.D_LINE_THICKNESS_MAX);
        this.thickness = value;
        this.updateAll(true, true);
    }

    public int getDrawStyle() {
        return this.lineStyle;
    }

    public void setDrawStyle(int value) {
        this.lineStyle = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return !MiscFunctions.equals(this.color, DefaultConstants.D_BORDER_COLOR) || this.lineStyle != 0 || this.thickness != DefaultConstants.D_BORDER_THICKNESS;
    }

    @Override
    public void copy(Object ba) {
        if (ba == null || !(ba instanceof BorderAppearance)) {
            return;
        }
        BorderAppearance a = (BorderAppearance)ba;
        if (this.thickness != a.thickness || this.lineStyle != a.lineStyle || !MiscFunctions.equals(this.color, a.color)) {
            this.dirty = true;
        }
        this.thickness = a.thickness;
        this.lineStyle = a.lineStyle;
        this.color = a.color;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

