/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class BarChartAppearance
extends ChartTypeAppearance {
    int barSpace = DefaultConstants.D_BAR_COLUMN_CHART_INTER_SPACING;
    int seriaSpace = DefaultConstants.D_BAR_COLUMN_CHART_SERIES_SPACING;
    boolean stack = false;
    int stackStyle = DefaultConstants.D_STACK_STYLE;
    static final long serialCheck = 7588043399811000932L;
    static final long serialVersionUID = 4207706389409315649L;

    public BarChartAppearance() {
    }

    public BarChartAppearance(IChartComponent component) {
        super(component);
    }

    public BarChartAppearance(int barSpacing, int seriesSpacing, int stackingStyle) {
        this.barSpace = barSpacing;
        this.seriaSpace = seriesSpacing;
        this.stackStyle = stackingStyle;
    }

    public int getBarSpacing() {
        return this.barSpace;
    }

    public void setBarSpacing(int value) {
        this.barSpace = value;
        this.updateAll(false, true);
    }

    public int getSeriesSpacing() {
        return this.seriaSpace;
    }

    public void setSeriesSpacing(int value) {
        this.seriaSpace = value;
        this.updateAll(false, true);
    }

    public boolean getStack() {
        return this.stack;
    }

    public void setStack(boolean value) {
        this.stack = value;
    }

    public int getStackStyle() {
        return this.stackStyle;
    }

    public void setStackStyle(int value) {
        this.stackStyle = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.barSpace != DefaultConstants.D_BAR_COLUMN_CHART_INTER_SPACING || this.seriaSpace != DefaultConstants.D_BAR_COLUMN_CHART_SERIES_SPACING || this.stackStyle != DefaultConstants.D_STACK_STYLE;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof BarChartAppearance)) {
            return;
        }
        BarChartAppearance a = (BarChartAppearance)ca;
        if (this.barSpace != a.barSpace || this.seriaSpace != a.seriaSpace || a.stackStyle != a.stackStyle) {
            this.dirty = true;
        }
        this.barSpace = a.barSpace;
        this.seriaSpace = a.seriaSpace;
        this.stackStyle = a.stackStyle;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

