/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.util.Random;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class AreaChartAppearance
extends ChartTypeAppearance {
    public transient int randomAnchor;
    int drawStyle = DefaultConstants.D_AREA_CHART_LINE_STYLE;
    int endStyle = DefaultConstants.D_AREA_CHART_END_ICON;
    int lineThickness = DefaultConstants.D_AREA_CHART_LINE_THICKNESS;
    int midPointAnchors = DefaultConstants.D_AREA_CHART_ANCHOR_SIZE;
    int startStyle = DefaultConstants.D_AREA_CHART_START_ICON;
    int transparency = DefaultConstants.D_AREA_CHART_TRANSPARENCY;
    static final long serialCheck = -8752326999382671005L;
    static final long serialVersionUID = -5115076941446866691L;

    public AreaChartAppearance() {
        this(null);
    }

    public AreaChartAppearance(IChartComponent component) {
        super(component);
        this.randomAnchor = 2 + new Random().nextInt(6);
    }

    public AreaChartAppearance(int thickness, int style, int anchors, int startAnchor, int endAnchor, int transparency) {
        this(null);
        this.lineThickness = thickness;
        this.drawStyle = style;
        this.midPointAnchors = anchors;
        this.startStyle = startAnchor;
        this.endStyle = endAnchor;
        this.transparency = transparency;
    }

    public int getTopLayerTransparency() {
        return this.transparency;
    }

    public void setTopLayerTransparency(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.transparency = value;
        this.updateAll(false, true);
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > DefaultConstants.D_LINE_THICKNESS_MAX) {
            value = DefaultConstants.D_LINE_THICKNESS_MAX;
        }
        this.lineThickness = value;
        this.updateAll(false, true);
    }

    public int getLineStartCapStyle() {
        return this.startStyle;
    }

    public void setLineStartCapStyle(int value) {
        if (value == 1) {
            this.randomAnchor = 2 + new Random().nextInt(6);
        }
        this.startStyle = value;
        this.updateAll(false, true);
    }

    public int getLineEndCapStyle() {
        return this.endStyle;
    }

    public void setLineEndCapStyle(int value) {
        this.endStyle = value;
        this.updateAll(false, true);
    }

    public int getLineDrawStyle() {
        return this.drawStyle;
    }

    public void setLineDrawStyle(int value) {
        this.drawStyle = (value & 7) % 5;
        this.updateAll(false, true);
    }

    public int getMidPointAnchors() {
        return this.midPointAnchors;
    }

    public void setMidPointAnchors(int value) {
        this.midPointAnchors = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.drawStyle != DefaultConstants.D_AREA_CHART_LINE_STYLE || this.endStyle != DefaultConstants.D_AREA_CHART_END_ICON || this.startStyle != DefaultConstants.D_AREA_CHART_START_ICON || this.lineThickness != DefaultConstants.D_AREA_CHART_LINE_THICKNESS || this.midPointAnchors != DefaultConstants.D_AREA_CHART_ANCHOR_SIZE || this.transparency != DefaultConstants.D_AREA_CHART_TRANSPARENCY;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof AreaChartAppearance)) {
            return;
        }
        AreaChartAppearance a = (AreaChartAppearance)ca;
        if (this.lineThickness != a.lineThickness || this.startStyle != a.startStyle || this.endStyle != a.endStyle || this.drawStyle != a.drawStyle || this.midPointAnchors != a.midPointAnchors || this.transparency != a.transparency) {
            this.dirty = true;
        }
        this.lineThickness = a.lineThickness;
        if (this.startStyle != a.startStyle && this.startStyle == 1) {
            this.randomAnchor = 2 + new Random().nextInt(6);
        }
        this.startStyle = a.startStyle;
        this.endStyle = a.endStyle;
        this.drawStyle = a.drawStyle;
        this.midPointAnchors = a.midPointAnchors;
        this.transparency = a.transparency;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

