/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.render.activeimage;

import java.util.ArrayList;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Ellipse;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.Wedge;
import oracle.bpm.chart.render.activeimage.HTMLTag;
import oracle.bpm.geom.Polygon;

public class CIMShape
extends HTMLTag {
    public int column = -1;
    public ArrayList<Integer> coords = new ArrayList();
    public int row = -1;
    public Object value = null;
    static final long serialCheck = -143614506158829134L;
    static final long serialVersionUID = 3725850196351238532L;
    static final String RECT = "rect";
    static final String CIRCLE = "circle";
    static final String POLY = "poly";
    static final String DEFAULT = "default";
    static final String SHAPE = "shape";

    CIMShape(String shape) {
        super("area");
        super.setAttribute(SHAPE, shape);
    }

    CIMShape(Primitive p) {
        super("area");
        this.row = p.row;
        this.column = p.column;
        this.value = p;
        if (p instanceof DataPoint) {
            this.fillDataPoint((DataPoint)p);
        } else if (p instanceof Box) {
            this.fillBox((Box)p);
        } else if (p instanceof Ellipse) {
            this.fillEllipse((Ellipse)p);
        } else if (p instanceof oracle.bpm.chart.core.primitives.Polygon) {
            this.fillPolygon((oracle.bpm.chart.core.primitives.Polygon)p);
        } else if (p instanceof Wedge) {
            this.fillWedge((Wedge)p);
        } else if (p.area instanceof Polygon[]) {
            this.fillArea((Polygon[])p.area, false);
        }
    }

    @Override
    public String toString() {
        if (this.coords != null && !this.coords.isEmpty()) {
            String list = "";
            for (Integer coord : this.coords) {
                list = list + coord + ",";
            }
            super.setAttribute("coords", list);
        }
        return super.toString();
    }

    void fillBox(Box p) {
        super.setAttribute(SHAPE, RECT);
        this.setCoords(new int[]{p.rect.getX(), p.rect.getY(), p.rect.getX() + p.rect.getWidth(), p.rect.getY() + p.rect.getHeight()});
    }

    void fillEllipse(Ellipse p) {
        super.setAttribute(SHAPE, CIRCLE);
        this.setCoords(new int[]{p.p1.getX() + p.p2.getX() / 2, p.p1.getY() + p.p2.getY() / 2, p.p2.getX() / 2});
    }

    void fillPolygon(oracle.bpm.chart.core.primitives.Polygon p) {
        int i;
        super.setAttribute(SHAPE, POLY);
        int n = i = p.points == null ? 0 : p.points.length;
        while (i-- > 0) {
            this.coords.add(p.points[i].getX());
            this.coords.add(p.points[i].getY());
        }
    }

    void fillDataPoint(DataPoint p) {
        int radius = p.hitTestRadius;
        if (radius > 0 || !(p.area instanceof Polygon[])) {
            if (radius < 4) {
                radius = 4;
            }
            super.setAttribute(SHAPE, CIRCLE);
            this.coords.add(p.point.getX());
            this.coords.add(p.point.getY());
            this.coords.add(radius);
        } else {
            this.fillArea((Polygon[])p.area, p.is1());
        }
    }

    void fillWedge(Wedge p) {
        super.setAttribute(SHAPE, POLY);
        int r = (p.widthHeight.getX() | 1) / 2;
        if (r < 3) {
            return;
        }
        int x = p.topLeft.getX() + r;
        int y = p.topLeft.getY() + r;
        int a = 360 - p.startAngle;
        int end = a - p.angleSweep;
        this.coords.add(x);
        this.coords.add(y);
        r += 3;
        while (true) {
            this.coords.add(x + (int)(Math.cos(Math.PI * (double)a / 180.0) * (double)r));
            this.coords.add(y + (int)(Math.sin(Math.PI * (double)a / 180.0) * (double)r));
            if (a == end) {
                return;
            }
            if (a < end) {
                if ((a += 20) <= end) continue;
                a = end;
                continue;
            }
            if ((a -= 20) >= end) continue;
            a = end;
        }
    }

    void fillArea(Polygon[] p, boolean firstOnly) {
        super.setAttribute(SHAPE, POLY);
        for (Polygon pp : p) {
            if (pp == null) continue;
            int ii = pp.npoints;
            while (ii-- > 0) {
                this.coords.add(pp.xpoints[ii]);
                this.coords.add(pp.ypoints[ii]);
            }
            if (firstOnly) break;
        }
    }

    void setCoords(int[] iArray) {
        this.coords.clear();
        for (int anIArray : iArray) {
            this.coords.add(anIArray);
        }
    }

    void setCoords(ArrayList<Integer> vArray) {
        this.coords = vArray;
    }
}

