/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.render;

import java.awt.geom.GeneralPath;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.ChartImage;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Ellipse;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.core.primitives.Line;
import oracle.bpm.chart.core.primitives.PointSet;
import oracle.bpm.chart.core.primitives.Polygon;
import oracle.bpm.chart.core.primitives.Polyline;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.core.primitives.Sphere;
import oracle.bpm.chart.core.primitives.Symbol;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.primitives.Wedge;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.GradientPattern;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.LineCap;
import oracle.bpm.draw.LineJoin;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;

public class Render {
    public static void icon(Graphics g, Primitive p, int icon, int iSize, Color drawColor, Color fillColor) {
        boolean noArea;
        int y;
        int x;
        int iHalf = 0;
        if (p instanceof Symbol) {
            x = ((Symbol)p).point.getX();
            y = ((Symbol)p).point.getY();
        } else if (p instanceof DataPoint) {
            x = ((DataPoint)p).point.getX();
            y = ((DataPoint)p).point.getY();
        } else {
            return;
        }
        Stroke str = null;
        if (p.selected != null) {
            fillColor = p.selected.fillColor;
            drawColor = p.selected.drawColor;
            if (drawColor != null) {
                if (p.selected.drawThickness > 1) {
                    str = Render.setStroke(g, p.selected.drawThickness, null, false);
                } else if (p.selected.drawThickness < 1) {
                    drawColor = null;
                }
            }
        } else {
            if (p.fillColor != null) {
                fillColor = p.fillColor;
            }
            if (p.drawColor != null) {
                drawColor = p.drawColor;
            }
        }
        if (fillColor != null) {
            g.setForeground(fillColor);
        }
        oracle.bpm.geom.Polygon po = null;
        boolean bl = noArea = iSize > 1023;
        if (noArea) {
            iSize &= 0x3FF;
        } else {
            if (p.area == null) {
                p.area = new oracle.bpm.geom.Polygon[1];
            }
            po = ((oracle.bpm.geom.Polygon[])p.area)[0];
        }
        if (iSize < 2) {
            iSize = 2;
        }
        boolean newP = po == null;
        switch (icon) {
            case 6: 
            case 7: {
                if (newP) {
                    iHalf = (iSize + 2) / 2;
                    x -= iHalf;
                    y -= iHalf;
                    iSize = iHalf + iHalf;
                    po = icon == 6 ? new oracle.bpm.geom.Polygon(new int[]{x, x + iSize, x + iHalf, x}, new int[]{--y + iSize, y + iSize, y, y + iSize}, 4) : new oracle.bpm.geom.Polygon(new int[]{x, x + iHalf, x + iSize, x}, new int[]{++y, y + iSize, y, y}, 4);
                }
                if (fillColor != null) {
                    g.fillPolygon(po.xpoints, po.ypoints, 4);
                }
                if (drawColor != null) {
                    g.setForeground(drawColor);
                }
                g.drawPolygon(po.xpoints, po.ypoints, 4);
                break;
            }
            case 2: 
            case 3: {
                if (newP) {
                    po = new oracle.bpm.geom.Polygon(new int[13], new int[13], 13);
                    if (icon == 3) {
                        iHalf = (iSize + 2) / 3 * 3 / 2;
                        x -= iHalf;
                        y -= iHalf;
                        iHalf = (iSize + 2) / 3;
                        po.xpoints[10] = po.xpoints[9] = x;
                        po.xpoints[7] = po.xpoints[12] = po.xpoints[10] + iHalf;
                        po.xpoints[8] = po.xpoints[12];
                        po.xpoints[11] = po.xpoints[12];
                        po.xpoints[0] = po.xpoints[12];
                        po.xpoints[5] = po.xpoints[6] = po.xpoints[0] + iHalf;
                        po.xpoints[2] = po.xpoints[6];
                        po.xpoints[1] = po.xpoints[6];
                        po.xpoints[3] = po.xpoints[4] = po.xpoints[1] + iHalf;
                        po.ypoints[1] = po.ypoints[12] = y;
                        po.ypoints[0] = po.ypoints[12];
                        po.ypoints[2] = po.ypoints[3] = po.ypoints[0] + iHalf;
                        po.ypoints[11] = po.ypoints[3];
                        po.ypoints[10] = po.ypoints[3];
                        po.ypoints[5] = po.ypoints[4] = po.ypoints[10] + iHalf;
                        po.ypoints[8] = po.ypoints[4];
                        po.ypoints[9] = po.ypoints[4];
                        po.ypoints[7] = po.ypoints[6] = po.ypoints[9] + iHalf;
                    } else {
                        iHalf = (iSize + 3) / 4 * 2;
                        x -= iHalf;
                        y -= iHalf;
                        po.xpoints[10] = po.xpoints[12] = x;
                        po.xpoints[0] = po.xpoints[12];
                        po.xpoints[11] = po.xpoints[9] = po.xpoints[0] + (iHalf /= 2);
                        po.xpoints[1] = po.xpoints[9];
                        po.xpoints[2] = po.xpoints[8] = po.xpoints[1] + iHalf;
                        po.xpoints[5] = po.xpoints[7] = po.xpoints[2] + iHalf;
                        po.xpoints[3] = po.xpoints[7];
                        po.xpoints[4] = po.xpoints[6] = po.xpoints[3] + iHalf;
                        po.ypoints[1] = po.ypoints[3] = y;
                        po.ypoints[4] = po.ypoints[12] = po.ypoints[1] + iHalf;
                        po.ypoints[2] = po.ypoints[12];
                        po.ypoints[0] = po.ypoints[12];
                        po.ypoints[11] = po.ypoints[5] = po.ypoints[0] + iHalf;
                        po.ypoints[8] = po.ypoints[6] = po.ypoints[11] + iHalf;
                        po.ypoints[10] = po.ypoints[6];
                        po.ypoints[9] = po.ypoints[7] = po.ypoints[10] + iHalf;
                    }
                }
                if (fillColor != null) {
                    g.fillPolygon(po.xpoints, po.ypoints, 13);
                }
                if (drawColor != null) {
                    g.setForeground(drawColor);
                }
                g.drawPolygon(po.xpoints, po.ypoints, 13);
                break;
            }
            case 5: {
                if (newP) {
                    iHalf = (iSize + 3) / 2;
                    iSize = iHalf + iHalf;
                    po = new oracle.bpm.geom.Polygon(new int[]{(x -= iHalf) + iHalf, x + iSize, x + iHalf, x, x + iHalf}, new int[]{y -= iHalf, y + iHalf, y + iSize, y + iHalf, y}, 5);
                }
                if (fillColor != null) {
                    g.fillPolygon(po.xpoints, po.ypoints, 5);
                }
                if (drawColor != null) {
                    g.setForeground(drawColor);
                }
                g.drawPolygon(po.xpoints, po.ypoints, 5);
                break;
            }
            case 8: {
                iHalf = ++iSize / 2;
                x -= iHalf;
                y -= iHalf;
                iHalf = iSize;
                if (fillColor != null) {
                    g.fillOval(x, y, iSize, iSize);
                }
                if (drawColor != null) {
                    g.setForeground(drawColor);
                }
                g.drawOval(x, y, iSize, iSize);
                break;
            }
            default: {
                if (icon == 10) {
                    iHalf = (iSize + 1) * 2 / 3;
                    iSize = iHalf * 2;
                    x -= iSize / 2;
                    y -= iHalf / 2;
                } else if (icon == 9) {
                    iSize = (iSize + 1) * 2 / 3;
                    iHalf = iSize * 2;
                    x -= iSize / 2;
                    y -= iHalf / 2;
                } else {
                    iHalf = iSize / 2;
                    x -= iHalf;
                    y -= iHalf;
                    iHalf = iSize;
                }
                if (icon == 4 || icon == 10 || icon == 9) {
                    if (fillColor != null) {
                        g.fillRect(x, y, iSize, iHalf);
                    }
                    if (drawColor != null) {
                        g.setForeground(drawColor);
                    }
                    g.drawRect(x, y, iSize, iHalf);
                    break;
                }
                if (icon <= 32) {
                    icon = 65;
                }
                if (p instanceof Symbol) {
                    g.setFont(DefaultConstants.D_SCATTER_CHART_CHARACTER_FONT);
                } else {
                    ((DataPoint)p).hitTestRadius = g.getFont().getSize() / 2;
                }
                int xx = x + iSize / 8;
                int yy = y + iSize * 3 / 4;
                if (drawColor != null) {
                    g.setForeground(drawColor);
                }
                if (drawColor == null || fillColor == null || MiscFunctions.equals(fillColor, drawColor)) {
                    g.drawString(String.valueOf((char)icon), xx + 1, yy + 1);
                    break;
                }
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        if (i == 0 && j == 0) continue;
                        g.drawString(String.valueOf((char)icon), xx + i, yy + j);
                    }
                }
                g.setForeground(fillColor);
                g.drawString(String.valueOf((char)icon), xx, yy);
            }
        }
        if (str != null) {
            g.setStroke(str);
        }
        if (newP && !noArea) {
            if (po == null) {
                po = new oracle.bpm.geom.Polygon(new int[]{x, x + iSize, x + iSize, x, x}, new int[]{y, y, y + iHalf, y + iHalf, y}, 5);
            }
            ((oracle.bpm.geom.Polygon[])p.area)[0] = po;
        }
    }

    static void box(Box b, Graphics g) {
        boolean selected;
        Rectangle r = b.rect;
        Color fillClr = b.fillColor;
        Color drawClr = b.drawColor;
        int w = b.drawThickness;
        boolean bl = selected = b.selected != null && b.drawAll();
        if (selected) {
            fillClr = b.selected.fillColor;
            drawClr = b.selected.drawColor;
            w = b.selected.drawThickness;
        }
        if (b.quality > 0 && !selected) {
            Render.box(g, r, b.corners == null ? null : b.corners[0], b.corners == null ? null : b.corners[1], b.corners == null ? null : b.corners[2], b.corners == null ? null : b.corners[3], b.quality, b.lines > 1 ? drawClr : null);
        } else if (fillClr != null) {
            if (b.gradientFillColor == null || g == null) {
                assert (g != null);
                g.setForeground(fillClr);
            } else {
                g.setPattern(new GradientPattern(r.getX(), r.getY(), fillClr, r.getX(), r.getY() + r.getHeight(), b.gradientFillColor));
            }
            g.fill(r);
        }
        if (b.lines != 1 || w < 1) {
            return;
        }
        Stroke str = null;
        if (drawClr != null) {
            g.setForeground(drawClr);
            str = Render.setStroke(g, w, b.lineStyle, true);
        }
        g.drawRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        if (str != null) {
            g.setStroke(str);
        }
    }

    static void box(Graphics g, Rectangle r, Color topLeft, Color topRight, Color botLeft, Color botRight, int quality, Color drawColor) {
        Color topMid = MiscFunctions.average(topLeft, topRight);
        Color botMid = MiscFunctions.average(botLeft, botRight);
        Color mid = MiscFunctions.average(topMid, botMid);
        int halfW = r.getWidth() / 2;
        int halfH = r.getHeight() / 2;
        if (halfW < 2 || halfH < 2) {
            quality = 0;
        }
        Rectangle r1 = new Rectangle(r.getX(), r.getY(), halfW, halfH);
        Rectangle r2 = new Rectangle(r.getX() + halfW, r.getY(), r.getWidth() - halfW, halfH);
        Rectangle r3 = new Rectangle(r.getX(), r.getY() + halfH, halfW, r.getHeight() - halfH);
        Rectangle r4 = new Rectangle(r.getX() + halfW, r.getY() + halfH, r.getWidth() - halfW, r.getHeight() - halfH);
        if (quality-- > 1) {
            Color leftMid = MiscFunctions.average(topLeft, botLeft);
            Color rightMid = MiscFunctions.average(topRight, botRight);
            Render.box(g, r1, topLeft, topMid, leftMid, mid, quality, drawColor);
            Render.box(g, r2, topMid, topRight, mid, rightMid, quality, drawColor);
            Render.box(g, r3, leftMid, mid, botLeft, botMid, quality, drawColor);
            Render.box(g, r4, mid, rightMid, botMid, botRight, quality, drawColor);
            return;
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(topLeft, mid));
            g.fill(r1);
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(topRight, mid));
            g.fill(r2);
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(botLeft, mid));
            g.fill(r3);
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(botRight, mid));
            g.fill(r4);
        }
        if (drawColor == null) {
            return;
        }
        g.setForeground(drawColor);
        g.drawRect(r1.getX(), r1.getY(), r1.getWidth(), r1.getHeight());
        g.drawRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
        g.drawRect(r3.getX(), r3.getY(), r3.getWidth(), r3.getHeight());
        g.drawRect(r4.getX(), r4.getY(), r4.getWidth(), r4.getHeight());
    }

    static void ellipse(Ellipse e, Graphics g) {
        Render.oval(g, e, e.p1.getX(), e.p1.getY(), e.p2.getX(), e.p2.getY());
    }

    static void oval(Graphics g, PrimitiveShape e, int x, int y, int w, int h) {
        Color fillClr = e.fillColor;
        Color drawClr = e.drawColor;
        int ww = e.drawThickness;
        if (e.selected != null) {
            fillClr = e.selected.fillColor;
            drawClr = e.selected.drawColor;
            ww = e.selected.drawThickness;
        }
        if (fillClr != null) {
            g.setForeground(fillClr);
            g.fillOval(x, y, w, h);
        } else if (drawClr == null) {
            return;
        }
        if (ww < 1) {
            return;
        }
        Stroke str = null;
        if (drawClr != null) {
            g.setForeground(drawClr);
            str = Render.setStroke(g, ww, e.lineStyle, false);
        }
        g.drawOval(x, y, w, h);
        if (str != null) {
            g.setStroke(str);
        }
    }

    static void image(ChartImage chartImage, Graphics g) {
        Image image = chartImage.image;
        if (image == null) {
            return;
        }
        Rectangle r = chartImage.bounds;
        if (chartImage.fitStyle == 0) {
            int w = image.getWidth();
            int h = image.getHeight();
            for (int x = 0; x < r.getWidth(); x += w) {
                for (int y = 0; y < r.getHeight(); y += h) {
                    g.drawImage(image, r.getX() + x, r.getY() + y, null);
                }
            }
        } else {
            g.drawImage(image, r.getX(), r.getY(), r.getWidth(), r.getHeight(), null);
        }
    }

    static void line(Line l, Graphics g) {
        Render.line(g, l, l.p1.getX(), l.p1.getY(), l.p2.getX(), l.p2.getY());
    }

    static void line(Graphics g, PrimitiveShape l, int x1, int y1, int x2, int y2) {
        if (l.drawThickness < 1) {
            return;
        }
        if (l.drawColor != null) {
            g.setForeground(l.drawColor);
        } else if (l.fillColor != null) {
            g.setForeground(l.fillColor);
        } else {
            return;
        }
        Stroke str = Render.setStroke(g, l.drawThickness, l.lineStyle, false);
        g.drawLine(x1, y1, x2, y2);
        if (str != null) {
            g.setStroke(str);
        }
    }

    static Stroke setStroke(Graphics g, int w, LineStyle style, boolean rect) {
        int dot;
        int n = dot = style == null ? 0 : style.getDrawStyle();
        if (w < 1) {
            return null;
        }
        if (g == null || dot == 0 && w < 2) {
            return null;
        }
        Stroke str = g.getStroke();
        g.setStroke(Render.stroke(g, w, style, rect));
        return str;
    }

    static Stroke stroke(Graphics g, int w, LineStyle style, boolean rect) {
        int dot;
        int n = dot = style == null ? 0 : style.getDrawStyle();
        if (w < 1 || dot == 0 && w < 2) {
            return null;
        }
        int[] dots = null;
        switch (dot) {
            case 1: {
                dots = new int[]{w * 4, w};
                break;
            }
            case 2: {
                dots = new int[]{w * 4, w, w, w};
                break;
            }
            case 3: {
                dots = new int[]{w * 4, w, w, w, w, w};
                break;
            }
            case 4: {
                dots = new int[]{w};
            }
        }
        return new Stroke(w, dots, LineCap.FLAT, rect ? LineJoin.MITER : LineJoin.BEVEL);
    }

    static void points(PointSet set, Graphics g, boolean select) {
        int icon = set.icon;
        int size = set.iconSize;
        Color fillClr = set.fillColor;
        Color drawClr = set.drawColor;
        if (set.selected != null) {
            fillClr = set.selected.fillColor;
            drawClr = set.selected.drawColor;
        }
        if (icon == 0) {
            g.setFont(set.font == null ? DefaultConstants.D_SCATTER_CHART_CHARACTER_FONT : set.font);
            if (set.character != '\u0000') {
                icon = set.character;
            }
        }
        if (icon == 0) {
            icon = 4;
            size = 4;
        }
        for (DataPoint p : set.points) {
            if (p == null || select && p.selected == null) continue;
            Render.icon(g, p, icon, size, drawClr, fillClr);
            if (size >= 8 || !p.is1() || p.hitTestRadius >= 4) continue;
            p.hitTestRadius = 4;
        }
    }

    static void symbol(Symbol s, Graphics g) {
        Render.icon(g, s, s.icon, s.iconSize, null, null);
    }

    static void polygon(Polygon poly, Graphics g, boolean select) {
        DataPoint dp;
        int i;
        int iLen;
        int w = poly.drawThickness;
        Stroke oldStr = null;
        Color fillClr = poly.fillColor;
        Color drawClr = poly.drawColor;
        if (poly.points != null) {
            if (poly.selected != null) {
                fillClr = poly.selected.fillColor;
                drawClr = poly.selected.drawColor;
                w = poly.selected.drawThickness;
            }
            Stroke str = Render.setStroke(g, w, poly.lineStyle, false);
            Render.poly(g, poly.points, fillClr, drawClr);
            if (str != null) {
                g.setStroke(str);
            }
            return;
        }
        int anchor = poly.lineStyle == null ? 0 : poly.lineStyle.getStartStyle();
        int n = iLen = poly.dataPoints == null ? -1 : poly.dataPoints.length;
        if (iLen < 3 || poly.dataPoints[0].area == null) {
            return;
        }
        int y = poly.dataPoints[iLen - 1].point.getY();
        if (iLen > 3) {
            Stroke str = Render.stroke(g, w, poly.lineStyle, false);
            if (str != null) {
                oldStr = g.getStroke();
            }
            for (i = 0; i < iLen - 3; ++i) {
                dp = poly.dataPoints[i];
                oracle.bpm.geom.Polygon po = ((oracle.bpm.geom.Polygon[])dp.area)[1];
                fillClr = dp.fillColor;
                drawClr = dp.drawColor;
                if (dp.selected != null && dp.drawAll()) {
                    fillClr = dp.selected.fillColor;
                    drawClr = dp.selected.drawColor;
                }
                if (!(fillClr == null || select && dp.selected == null)) {
                    g.setForeground(fillClr);
                    g.fillPolygon(po.xpoints, po.ypoints, 5);
                }
                if (drawClr == null) continue;
                g.setForeground(drawClr);
                if (anchor >= 0 || i == 0) {
                    g.drawLine(po.xpoints[0], po.ypoints[0], po.xpoints[3], po.ypoints[3]);
                }
                if (i + 4 == iLen) {
                    g.drawLine(po.xpoints[1], po.ypoints[1], po.xpoints[2], po.ypoints[2]);
                }
                if (oldStr != null) {
                    g.setStroke(str);
                }
                g.drawLine(po.xpoints[0], po.ypoints[0], po.xpoints[1], po.ypoints[1]);
                if (oldStr == null) continue;
                g.setStroke(oldStr);
            }
            if (drawClr != null) {
                g.drawLine(poly.dataPoints[iLen - 1].point.getX(), y, poly.dataPoints[iLen - 2].point.getX(), y);
            }
        }
        int n2 = i = poly.lineStyle == null ? 0 : poly.lineStyle.getEndStyle();
        if (i > 5) {
            w += (i - 5) * 3 / 5;
        }
        for (i = 0; i <= iLen - 3; ++i) {
            dp = poly.dataPoints[i];
            if (i > 0 && poly.dataPoints[i - 1].column == dp.column) continue;
            if (anchor > 1) {
                Render.icon(g, dp, anchor, w, null, null);
            } else {
                Render.selPoint(g, dp, w);
            }
            if (!dp.is1() || anchor >= 2 && w >= 7) continue;
            dp.hitTestRadius = w < 7 ? 4 : (w + 1) / 2;
        }
    }

    static void polyline(Polyline poly, Graphics g, boolean select) {
        DataPoint dp;
        int i;
        int iLen;
        int n = iLen = poly.points == null ? 0 : poly.points.length - 1;
        if (iLen < 0) {
            return;
        }
        int w = poly.drawThickness;
        int anchor = poly.lineStyle == null ? 0 : poly.lineStyle.getStartStyle();
        Stroke oldStr = null;
        Stroke str = null;
        if (poly.lineStyle != null && w > 0 && poly.lineStyle.getDrawStyle() != 0) {
            str = Render.stroke(g, w, poly.lineStyle, false);
        }
        if (iLen > 0 && w >= 0) {
            Color drawClr;
            Color fillClr;
            if (str != null) {
                oldStr = g.getStroke();
            }
            if (oldStr != null || w < 2) {
                for (i = 0; i < iLen; ++i) {
                    DataPoint dp1 = poly.points[i];
                    DataPoint dp2 = poly.points[i + 1];
                    if (oldStr != null) {
                        g.setStroke(str);
                    }
                    fillClr = dp1.fillColor;
                    drawClr = dp1.drawColor;
                    if (dp1.selected != null && dp1.drawAll()) {
                        fillClr = dp1.selected.fillColor;
                        drawClr = dp1.selected.drawColor;
                    }
                    if (!(fillClr == null || select && dp1.selected == null)) {
                        g.setForeground(fillClr);
                        g.drawLine(dp1.point.getX(), dp1.point.getY(), dp2.point.getX(), dp2.point.getY());
                    }
                    if (drawClr == null || w == 0) continue;
                    g.setForeground(drawClr);
                    if (w == 1) {
                        g.drawLine(dp1.point.getX(), dp1.point.getY() - 1, dp2.point.getX(), dp2.point.getY() - 1);
                        continue;
                    }
                    if (oldStr != null) {
                        g.setStroke(oldStr);
                    }
                    GeneralPath p = new GeneralPath();
                    p.moveTo(dp1.point.getX(), dp1.point.getY());
                    p.lineTo(dp2.point.getX(), dp2.point.getY());
                    g.draw(str.asAwt().createStrokedShape(p));
                    System.out.println("TODO Render.polyline() Est\u00e1 usando el GeneralPath() de awt");
                }
            } else if (poly.points[0].area != null) {
                for (i = 0; i < iLen; ++i) {
                    dp = poly.points[i];
                    if (((oracle.bpm.geom.Polygon[])dp.area).length < 2) continue;
                    oracle.bpm.geom.Polygon po = ((oracle.bpm.geom.Polygon[])dp.area)[1];
                    fillClr = dp.fillColor;
                    drawClr = dp.drawColor;
                    if (dp.selected != null && dp.drawAll()) {
                        fillClr = dp.selected.fillColor;
                        drawClr = dp.selected.drawColor;
                    }
                    if (!(fillClr == null || select && dp.selected == null)) {
                        g.setForeground(fillClr);
                        g.fillPolygon(po.xpoints, po.ypoints, 5);
                    }
                    if (drawClr == null) continue;
                    g.setForeground(drawClr);
                    g.drawLine(po.xpoints[1], po.ypoints[1], po.xpoints[2], po.ypoints[2]);
                    if (anchor == 0 || i == 0) {
                        g.drawLine(po.xpoints[0], po.ypoints[0], po.xpoints[3], po.ypoints[3]);
                    }
                    if (i + 1 == iLen) {
                        g.drawLine(po.xpoints[1], po.ypoints[1], po.xpoints[2], po.ypoints[2]);
                    }
                    g.drawLine(po.xpoints[0], po.ypoints[0], po.xpoints[1], po.ypoints[1]);
                    g.drawLine(po.xpoints[3], po.ypoints[3], po.xpoints[2], po.ypoints[2]);
                }
            }
        }
        if (oldStr != null) {
            g.setStroke(oldStr);
        }
        if (!poly.hitMe) {
            return;
        }
        int n2 = i = poly.lineStyle == null ? 0 : poly.lineStyle.getEndStyle();
        if (w < 1) {
            w = 1;
        }
        if (i > 5) {
            w += (i - 5) * 3 / 5;
        }
        for (i = 0; i <= iLen; ++i) {
            dp = poly.points[i];
            if (i > 0 && poly.points[i - 1].column == dp.column) continue;
            if (anchor > 1) {
                Render.icon(g, dp, anchor, w, null, null);
            } else {
                Render.selPoint(g, dp, w);
            }
            if (!dp.is1() || anchor >= 2 && w >= 7) continue;
            dp.hitTestRadius = w < 7 ? 4 : (w + 1) / 2;
        }
    }

    static void selPoint(Graphics g, Primitive p, int w) {
        int x;
        if (p.selected == null || p.drawAll()) {
            return;
        }
        if (w < 7) {
            w = 7;
        }
        int y = 0;
        if (p instanceof DataPoint) {
            x = ((DataPoint)p).point.getX();
            y = ((DataPoint)p).point.getY();
        } else if (p instanceof Box) {
            if (((Box)p).quality < 0) {
                return;
            }
            Rectangle r = ((Box)p).rect;
            y = Primitive.hit(p);
            x = r.getX();
            if ((y & 1) == 0) {
                x += r.getWidth();
            }
            y = r.getY() + (y > 2 ? r.getHeight() : 0);
        } else if (p instanceof IFGOFF) {
            y = Primitive.hit(p) - 1;
            if (((IFGOFF)p).quality < 0 || !(p.area instanceof oracle.bpm.geom.Polygon[]) || y < 0) {
                return;
            }
            x = ((oracle.bpm.geom.Polygon[])p.area)[0].xpoints[y];
            y = ((oracle.bpm.geom.Polygon[])p.area)[0].ypoints[y];
        } else {
            return;
        }
        if (p.selected.fillColor != null) {
            g.setForeground(p.selected.fillColor);
            g.fillRect(x - w / 2, y - w / 2, w, w);
        }
        if (p.selected.drawColor != null) {
            Stroke str = null;
            if (p.selected.drawThickness <= 1) {
                return;
            }
            str = Render.setStroke(g, p.selected.drawThickness, null, false);
            g.setForeground(p.selected.drawColor);
            g.drawRect(x - w / 2, y - w / 2, w, w);
            if (str != null) {
                g.setStroke(str);
            }
        }
    }

    static void sphere(Sphere s, Graphics g) {
        if (s.fillColor != null) {
            g.setForeground(s.fillColor);
            g.fillOval((int)s.pos.x, (int)s.pos.y, (int)s.radius * 2, (int)s.radius * 2);
        } else if (s.drawColor == null) {
            return;
        }
        if (s.drawColor != null) {
            g.setForeground(s.drawColor);
        }
        g.drawOval((int)s.pos.x, (int)s.pos.y, (int)s.radius * 2, (int)s.radius * 2);
    }

    static void wedge(Wedge w, Graphics g) {
        int r = w.widthHeight.getX() | 1;
        if (r < 2) {
            return;
        }
        int x = w.topLeft.getX();
        int y = w.topLeft.getY();
        int a = w.startAngle;
        Stroke str = null;
        Color fillClr = w.fillColor;
        Color drawClr = w.drawColor;
        if (w.selected != null) {
            fillClr = w.selected.fillColor;
            drawClr = w.selected.drawColor;
            if (drawClr != null) {
                if (w.selected.drawThickness > 1) {
                    str = Render.setStroke(g, w.selected.drawThickness, null, false);
                } else if (w.selected.drawThickness < 1) {
                    drawClr = null;
                }
            }
        }
        if (fillClr != null) {
            g.setForeground(fillClr);
            g.fillArc(x, y, r, r, a, w.angleSweep);
        }
        if (drawClr == null) {
            return;
        }
        g.setForeground(drawClr);
        g.drawArc(x, y, r, r, a, w.angleSweep);
        a = 360 - a;
        g.drawLine(x += (r /= 2), y += r, x + (int)(Math.cos(Math.PI * (double)a / 180.0) * (double)r), y + (int)(Math.sin(Math.PI * (double)a / 180.0) * (double)r));
        g.drawLine(x, y, x + (int)(Math.cos(Math.PI * (double)(a -= w.angleSweep) / 180.0) * (double)r), y + (int)(Math.sin(Math.PI * (double)a / 180.0) * (double)r));
        if (str != null) {
            g.setStroke(str);
        }
    }

    static void poly(Graphics g, Point[] p, Color back, Color fore) {
        int iLen = p.length;
        if (iLen < 2) {
            return;
        }
        int[] x = new int[iLen + 1];
        int[] y = new int[iLen + 1];
        for (int i = 0; i < iLen; ++i) {
            x[i] = p[i].getX();
            y[i] = p[i].getY();
        }
        x[iLen] = x[0];
        y[iLen] = y[0];
        if (back != null) {
            g.setForeground(back);
            g.fillPolygon(x, y, iLen + 1);
        } else if (fore == null) {
            return;
        }
        if (fore != null) {
            g.setForeground(fore);
        }
        g.drawPolygon(x, y, iLen + 1);
    }

    static void text(Text t, Graphics g) {
        int w;
        LabelStyle style = t.labelStyle;
        String s = t.textString;
        int o = -1;
        int i = s == null ? 0 : s.length();
        int orient = style.getOrientation();
        if (i == 0) {
            return;
        }
        if (i != 0) {
            StringBuffer sb = new StringBuffer(s);
            while (i-- > 0) {
                if (sb.charAt(i) >= ' ') continue;
                o = i;
                sb.setCharAt(o, ' ');
            }
            if (o >= 0) {
                s = new String(sb);
            }
        }
        orient = 2 - orient;
        Font f = style.getFont();
        if (f == null) {
            f = DefaultConstants.D_TEXT_FONT;
        }
        int x = t.bounds.getX();
        int y = t.bounds.getY();
        int w0 = t.bounds.getWidth();
        int h0 = t.bounds.getHeight();
        if (orient < 2) {
            i = w0;
            w0 = h0;
            h0 = i;
        }
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight();
        if (w0 > 0 && h0 > 0 && style.getFontSizeBestFit()) {
            if (h0 < 4) {
                return;
            }
            FontStyle fontStyle = f.getStyle();
            String sName = f.getName();
            o = i = f.getSize();
            if (h > h0) {
                o = h0;
                i = o - 1;
                f = Font.valueOf(sName, fontStyle, i);
                g.setFont(f);
            }
            while (true) {
                w = fm.stringWidth(s) + 2;
                h = fm.getHeight();
                if (w <= w0) {
                    if (i++ < o) {
                        f = g.getFont();
                        break;
                    }
                } else if (i-- > o || i < 4) break;
                f = g.getFont();
                g.setFont(Font.valueOf(sName, fontStyle, i));
                fm = g.getFontMetrics();
            }
            g.setFont(f);
            fm = g.getFontMetrics();
            h = fm.getHeight();
        }
        int shift = t.id < 0 ? 0 : h / 3;
        i = style.getHorizontalAlign();
        int v = style.getVerticalAlign();
        if (orient == 2) {
            Render.textHoriz(t, g, i, v, shift);
            return;
        }
        if (i == 2) {
            shift = -shift;
        }
        i = 2 - i;
        v = 2 - v;
        w = fm.stringWidth(s);
        if (w0 > 0 && h0 > 0 && !style.getFontSizeBestFit() && style.getClipText()) {
            while (w > w0) {
                s = s.substring(0, s.length() - 1);
                w = fm.stringWidth(s);
            }
        }
        if (orient == 1) {
            y += w0 + shift;
        } else {
            x += h0;
        }
        o = 1 - orient * 2;
        y = i > 0 ? (y += o * (w0 - w - 2) / i) : (y += 1 + o);
        x = v > 0 ? (x -= o * (h0 - h - o) / v) : (x -= o);
        g.setForeground(style.getFontColor());
        g.drawVerticalString(s, x -= o * f.getSize(), y, 128);
    }

    static void textHoriz(Text t, Graphics g, int hAlign, int vAlign, int shift) {
        String txt;
        int iMin;
        int iLines;
        boolean auto;
        boolean wrap = t.labelStyle.getWrapText();
        String text = t.textString;
        int x = t.bounds.getX();
        int y = t.bounds.getY();
        int width = t.bounds.getWidth();
        int height = t.bounds.getHeight();
        int compW = 0;
        int compH = 0;
        FontMetrics fm = g.getFontMetrics();
        boolean bl = auto = width < 1 || height < 1;
        if (auto) {
            compW = -width;
            compH = -height;
            wrap = false;
            height = 0;
            width = 0;
        }
        int i = 0;
        int iSpace = -1;
        int i0 = -1;
        int iLen = text.length();
        int iDot = fm.charWidth('.');
        int iW = fm.charWidth('W');
        if (!auto && width < iDot || iDot < 1) {
            return;
        }
        int iFD = (fm.getDescent() + 1) / 2;
        int iEnd = height + 1;
        int iLineH = fm.getHeight() - iFD;
        boolean dots = true;
        int n = iLines = iEnd > iLineH ? iEnd / iLineH : 1;
        if (wrap && iLen > (iEnd = width * iLines / iDot)) {
            if (iW <= iDot + 1) {
                ++iEnd;
            }
            iLen = iEnd;
            text = text.substring(0, iLen);
        }
        int iMin0 = width / iW;
        int iCount = 0;
        String[] v = new String[iLines--];
        char ch = '\u0000';
        while (true) {
            if (i < iLen && (ch = text.charAt(i)) == ' ') {
                ++i;
                continue;
            }
            if (i == iLen) break;
            i0 = i0 == 0 ? i : 0;
            iMin = iMin0;
            int iBig = 0;
            iEnd = 0;
            boolean big = false;
            if (ch < ' ' && !auto && iCount + 1 < iLines) {
                i0 = i;
            } else {
                while (++i < iLen) {
                    ch = text.charAt(i);
                    if (ch < ' ') {
                        iSpace = i;
                        break;
                    }
                    if (!big && !auto) {
                        big = i >= iMin;
                        if (big && !(big = (iEnd = fm.stringWidth(text.substring(i0, i + 1))) > width)) {
                            iMin = i - i0 + (width - iEnd) / iW;
                        }
                        if (big) {
                            iBig = i;
                            if (wrap || i == 0) break;
                        }
                    }
                    if (!wrap || ch != ' ') continue;
                    iSpace = i;
                }
            }
            if (iCount < iLines) {
                if (i < iLen && iSpace > 0) {
                    if (i == iBig) {
                        iBig = 0;
                    }
                    i = iSpace;
                } else if (wrap && iLen > i && i > i0 + 1 && Character.isLetter(ch)) {
                    if (fm.stringWidth(text.substring(i0, i) + '-') + 2 > width) {
                        --i;
                    }
                    iBig = -1;
                }
            }
            txt = text.substring(i0, i);
            if (auto) {
                if (ch < ' ') {
                    String[] vv = new String[++iLines + 1];
                    iMin = iLines;
                    while (iMin-- > 0) {
                        vv[iMin] = v[iMin];
                    }
                    v = vv;
                }
                if ((iMin = fm.stringWidth(txt)) > width) {
                    width = iMin;
                }
                height += iLineH;
            } else if (iBig < 0) {
                txt = txt + '-';
            } else if ((iBig -= i0) > 0 || iCount == iLines && i != iLen) {
                big = iCount < iLines && wrap ? false : dots;
                if (big) {
                    if (iEnd == 0 || iBig == 0) {
                        iEnd = fm.stringWidth(txt) + iDot;
                    }
                    if (iEnd + iDot * 2 <= width) {
                        iBig = 0;
                    } else {
                        if (iBig == 0) {
                            iBig = i - i0;
                        }
                        if (big = iBig > (iEnd = iW < iDot + 1 ? 3 : 2)) {
                            iBig -= iEnd;
                        }
                    }
                }
                if (iBig > 0 && iBig < i - i0) {
                    txt = txt.substring(0, iBig);
                }
                if (big) {
                    txt = txt + "...";
                }
            }
            v[iCount++] = txt;
            if (iCount > iLines || i >= iLen) break;
            if (ch < ' ') {
                ++i;
            }
            text = text.substring(i);
            iLen = text.length();
            i0 = 0;
            i = 0;
            iSpace = 0;
            if (i >= iLen) break;
        }
        iMin = t.drawThickness + 4;
        if (auto) {
            width += 4;
            if (compW > 0 || compH > 0) {
                hAlign = 0;
                vAlign = 0;
                if (y + 22 + iMin + height > compH) {
                    if ((y -= height + iMin) < 2) {
                        y = 2;
                    }
                } else {
                    y += 19;
                }
                if (x + width + iMin > compW && (x -= width + iMin) < 2) {
                    x = 2;
                }
            } else {
                if (vAlign < 2) {
                    y -= height / (2 - vAlign);
                }
                if (hAlign < 2) {
                    x -= width / (2 - hAlign);
                }
            }
        }
        if (t.fillColor != null) {
            g.setForeground(t.fillColor);
            g.fillRect(x - iMin / 2, y - iMin / 2, width + iMin, height + iMin);
        }
        if (t.drawThickness > 0 && t.drawColor != null) {
            g.setForeground(t.drawColor);
            Stroke str = Render.setStroke(g, t.drawThickness, t.lineStyle, true);
            g.drawRect(x - iMin / 2, y - iMin / 2, width + iMin, height + iMin);
            if (str != null) {
                g.setStroke(str);
            }
        }
        iMin = iLineH - iFD;
        if (iLineH >= height) {
            iMin -= (iLineH - height + 1) / 2;
        } else if (vAlign < 2) {
            if (vAlign == 0) {
                i = height - iCount * iLineH;
                if (i > 1) {
                    iMin += i >>> 1;
                }
            } else if (height > iLineH) {
                iMin = height - (iLineH * (iCount - 1) + iFD);
            }
        }
        if (vAlign > 0) {
            iMin += vAlign == 2 ? shift : -shift;
        }
        i = 0;
        g.setForeground(t.labelStyle.getFontColor());
        while (i < iCount) {
            if ((txt = v[i++]) == null) {
                return;
            }
            iLen = txt.length();
            iEnd = fm.stringWidth(txt);
            i0 = x;
            i0 = hAlign == 0 ? (i0 += (width - iEnd) / 2) : (hAlign == 1 ? (i0 += width - iEnd - 3 - shift) : (i0 += 1 + shift));
            g.drawString(txt, i0, iMin + y);
            iMin += iLineH;
        }
    }
}

