/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.render;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.layers.ThreeDGridLayer;
import oracle.bpm.chart.core.primitives.Box3D;
import oracle.bpm.chart.core.primitives.Epoch;
import oracle.bpm.chart.core.primitives.Face;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.core.primitives.Line3D;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.core.primitives.Sphere;
import oracle.bpm.chart.core.primitives.Text3D;
import oracle.bpm.chart.core.primitives.Wedge3D;
import oracle.bpm.chart.core.util.Matrix3D;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.render.Render;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Polygon;
import oracle.bpm.geom.Rectangle;

class IFGGraphics3D {
    transient int ang00 = 0;
    transient int axisLabels;
    transient Graphics g;
    transient int[] id;
    transient Matrix3D matrix;
    transient Matrix3D mat;
    transient boolean opaque = false;
    transient int order = 74565;
    transient int shadows = 0;
    transient boolean swap = false;
    transient float[] v;
    transient int[] xx;
    transient int[] yy;

    IFGGraphics3D() {
    }

    static void face(Graphics g, int[] xs, int[] ys, Color c1, Color c2, Color c3, Color c4, int quality, Color fore) {
        Color mid1 = MiscFunctions.average(c1, c2);
        Color mid2 = MiscFunctions.average(c3, c4);
        Color mid = MiscFunctions.average(mid1, mid2);
        int[] x1 = new int[5];
        int[] x2 = new int[5];
        int[] x3 = new int[5];
        int[] x4 = new int[5];
        int[] y1 = new int[5];
        int[] y2 = new int[5];
        int[] y3 = new int[5];
        int[] y4 = new int[5];
        x1[0] = x1[4] = xs[0];
        y1[0] = y1[4] = ys[0];
        x2[0] = x2[4] = (xs[0] + xs[1]) / 2;
        x1[1] = x2[4];
        y2[0] = y2[4] = (ys[0] + ys[1]) / 2;
        y1[1] = y2[4];
        x4[0] = x4[4] = (xs[0] + xs[3]) / 2;
        x1[3] = x4[4];
        y4[0] = y4[4] = (ys[0] + ys[3]) / 2;
        y1[3] = y4[4];
        x2[1] = xs[1];
        y2[1] = ys[1];
        x2[2] = x3[1] = (xs[1] + xs[2]) / 2;
        y2[2] = y3[1] = (ys[1] + ys[2]) / 2;
        x3[2] = xs[2];
        y3[2] = ys[2];
        x4[3] = xs[3];
        y4[3] = ys[3];
        x3[3] = x4[2] = (xs[2] + xs[3]) / 2;
        y3[3] = y4[2] = (ys[2] + ys[3]) / 2;
        x3[4] = x4[1] = (xs[0] + xs[2]) / 2;
        x3[0] = x4[1];
        x2[3] = x4[1];
        x1[2] = x4[1];
        y3[4] = y4[1] = (ys[0] + ys[2]) / 2;
        y3[0] = y4[1];
        y2[3] = y4[1];
        y1[2] = y4[1];
        if (IFGGraphics3D.equal(xs[0], xs[2], ys[0], ys[2]) || IFGGraphics3D.equal(xs[1], xs[3], ys[1], ys[3]) || IFGGraphics3D.equal(xs[0], xs[1], ys[0], ys[1]) && IFGGraphics3D.equal(xs[2], xs[3], ys[2], ys[3]) || IFGGraphics3D.equal(xs[0], xs[3], ys[0], ys[3]) && IFGGraphics3D.equal(xs[2], xs[1], ys[2], ys[1])) {
            quality = 0;
        }
        if (quality-- > 1) {
            Color mid3 = MiscFunctions.average(c1, c3);
            Color mid4 = MiscFunctions.average(c2, c4);
            IFGGraphics3D.face(g, x1, y1, c1, mid1, mid3, mid, quality, fore);
            IFGGraphics3D.face(g, x4, y4, mid1, c2, mid, mid4, quality, fore);
            IFGGraphics3D.face(g, x2, y2, mid3, mid, c3, mid2, quality, fore);
            IFGGraphics3D.face(g, x3, y3, mid, mid4, mid2, c4, quality, fore);
            return;
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(c1, mid));
            g.fillPolygon(x1, y1, 5);
            if (fore == null) {
                g.drawPolygon(x1, y1, 5);
            }
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(c2, mid));
            g.fillPolygon(x4, y4, 5);
            if (fore == null) {
                g.drawPolygon(x4, y4, 5);
            }
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(c3, mid));
            g.fillPolygon(x2, y2, 5);
            if (fore == null) {
                g.drawPolygon(x2, y2, 5);
            }
        }
        if (mid != null) {
            g.setForeground(MiscFunctions.average(c4, mid));
            g.fillPolygon(x3, y3, 5);
            if (fore == null) {
                g.drawPolygon(x3, y3, 5);
            }
        }
        if (fore == null) {
            return;
        }
        g.setForeground(fore);
        g.drawPolygon(x1, y1, 5);
        g.drawPolygon(x2, y2, 5);
        g.drawPolygon(x3, y3, 5);
        g.drawPolygon(x4, y4, 5);
    }

    static boolean equal(int x1, int x2, int y1, int y2) {
        return x1 - x2 <= 2 && x2 - x1 <= 2 && y1 - y2 <= 2 && y2 - y1 <= 2;
    }

    void init(Object o) {
        this.g = (Graphics)o;
        if (this.v == null) {
            this.v = new float[50];
            this.xx = new int[5];
            this.yy = new int[5];
            this.id = new int[]{2, 6, 7, 3, 4, 5, 7, 6, 1, 3, 7, 5, 0, 1, 5, 4, 0, 4, 6, 2, 0, 2, 3, 1};
        }
    }

    void init(Object component, Epoch e) {
        int aX;
        if (this.g == null || e.volume == null) {
            return;
        }
        if (this.matrix == null) {
            this.matrix = new Matrix3D();
        }
        this.matrix.unit();
        this.order = e.order;
        this.shadows = ((ColorAppearance)((IChartComponent)component).getChartAppearance((int)6)).shadows3D;
        View3DAppearance app = (View3DAppearance)((IChartComponent)component).getChartAppearance(24);
        if ((this.order & 0x80) == 0) {
            this.matrix.translate(-e.volume.x / 2.0f, -e.volume.y / 2.0f, -e.volume.z / 2.0f);
        }
        if ((aX = app.getXRotation() + 180) >= 360) {
            aX -= 360;
        }
        this.matrix.xrot(aX);
        this.matrix.yrot(app.getYRotation());
        this.matrix.zrot(app.getZRotation());
        this.matrix.scale(app.getScale() / 100.0f);
        this.matrix.translate(e.payload.getX() + e.payload.getWidth() / 2, e.payload.getY() + e.payload.getHeight() / 2, 0.0f);
        this.opaque = (this.order & 8) != 0;
    }

    void fillSphere3D(Sphere sphere) {
        this.v[0] = sphere.pos.x;
        this.v[1] = sphere.pos.y;
        this.v[2] = sphere.pos.z;
        float r = this.matrix.transform(sphere.radius);
        this.matrix.transform(this.v, 1);
        Render.oval(this.g, sphere, (int)(this.v[0] - r), (int)(this.v[1] - r), (int)(2.0f * r), (int)(2.0f * r));
    }

    void drawLine3D(Line3D line) {
        if (line.drawThickness < 1) {
            return;
        }
        this.v[0] = line.p1.x;
        this.v[1] = line.p1.y;
        this.v[2] = line.p1.z;
        this.v[3] = line.p2.x;
        this.v[4] = line.p2.y;
        this.v[5] = line.p2.z;
        this.matrix.transform(this.v, 2);
        if (line.p1 != line.p2) {
            Render.line(this.g, line, (int)this.v[0], (int)this.v[1], (int)this.v[3], (int)this.v[4]);
        }
        if (line.fillColor != null) {
            int d = 3 + (int)this.matrix.transform(4.0f);
            if (d > 6) {
                d = 6;
            }
            this.g.setForeground(line.fillColor);
            this.g.fillOval((int)(this.v[0] + 0.5f - (float)(d / 2)), (int)(this.v[1] + 0.5f - (float)(d / 2)), d, d);
        }
    }

    void setAlignment(int orient, int align, int axis) {
        this.axisLabels |= (orient | align << 3) << axis * 6;
    }

    void fixAlignment(Text3D t) {
        if (t.id < 0 || this.axisLabels == 0) {
            return;
        }
        int axis = t.id & 7;
        int axisKey = axis % 3;
        int orient = this.axisLabels >> axisKey * 6 & 3;
        if (ThreeDGridLayer.isShortText(t.id) && orient != 0) {
            orient = 8;
        }
        t.labelStyle.setOrientation(orient & 3);
        int horiz = this.axisLabels >> axisKey * 6 + 3 & 3;
        if (axis > 2) {
            horiz = horiz == 2 ? 1 : 2;
        }
        axis = 0;
        if (orient == 8) {
            axis = horiz == 2 ? 1 : 2;
            horiz = 0;
        }
        t.labelStyle.setHorizontalAlign(horiz);
        t.labelStyle.setVerticalAlign(axis);
    }

    void drawString3D(Text3D text) {
        this.v[0] = text.pos.x;
        this.v[1] = text.pos.y;
        this.v[2] = text.pos.z;
        this.matrix.transform(this.v, 1);
        text.bounds = new Rectangle((int)this.v[0], (int)this.v[1], text.bounds.getWidth(), text.bounds.getHeight());
        this.fixAlignment(text);
        Render.text(text, this.g);
    }

    void drawBox3D(Box3D box) {
        boolean opaq;
        int i = 24;
        int ii = 1139551;
        while (i-- > 0) {
            this.v[i] = ii >> i & 1;
        }
        if (this.mat == null) {
            this.mat = new Matrix3D();
        }
        this.mat.unit();
        this.mat.scale(Math.abs(box.p2.x - box.p1.x), Math.abs(box.p2.y - box.p1.y), Math.abs(box.p2.z - box.p1.z));
        this.mat.translate(box.p1.x, box.p1.y, box.p1.z);
        this.mat.transform(this.v, 8);
        this.matrix.transform(this.v, 8);
        Color fillClr = box.fillColor;
        Color drawClr = box.drawColor;
        Stroke str = null;
        if (box.selected != null) {
            fillClr = box.selected.fillColor;
            drawClr = box.selected.drawColor;
            if (drawClr != null) {
                i = box.selected.drawThickness;
                if (i < 1) {
                    drawClr = null;
                }
                if (i > 1) {
                    str = Render.setStroke(this.g, i, null, false);
                }
            }
        }
        boolean bl = opaq = this.opaque && fillClr != null;
        if (opaq && box.selected != null) {
            opaq = fillClr.getAlpha() > 252;
        }
        for (int iLen = 1; iLen < 6; ++iLen) {
            ii = (this.order >> (5 - iLen) * 4 & 7) * 4;
            for (i = 0; i < 4; ++i) {
                this.xx[i] = (int)this.v[this.id[ii + i] * 3];
                this.yy[i] = (int)this.v[this.id[ii + i] * 3 + 1];
            }
            this.xx[4] = this.xx[0];
            this.yy[4] = this.yy[0];
            if (iLen > 2) {
                if (this.sideClr(this.g, fillClr, ii / 4, box.negative)) {
                    this.g.fillPolygon(this.xx, this.yy, 5);
                    if (box.drawColor == null) {
                        this.g.drawPolygon(this.xx, this.yy, 5);
                    }
                }
                if (box.hitMe) {
                    if (iLen == 3 && box.area == null) {
                        box.area = new Polygon[]{new Polygon(new int[4], new int[4], 4), new Polygon(new int[4], new int[4], 4), new Polygon(new int[4], new int[4], 4)};
                    }
                    for (i = 0; i < 4; ++i) {
                        ((Polygon[])box.area)[iLen - 3].xpoints[i] = this.xx[i];
                        ((Polygon[])box.area)[iLen - 3].ypoints[i] = this.yy[i];
                    }
                }
            }
            if (box.drawColor == null || iLen <= 2 && opaq) continue;
            this.g.setForeground(drawClr);
            this.g.drawPolygon(this.xx, this.yy, 5);
        }
        if (str != null) {
            this.g.setStroke(str);
        }
    }

    void drawOFF(IFGOFF off, PrimitiveShape prim) {
        int i = off.vert.length;
        while (i-- > 0) {
            this.v[i] = off.vert[i];
        }
        this.matrix.transform(this.v, off.nverts);
        if (off.face == null) {
            this.axisLabels = 0;
            for (i = 0; i < 3; ++i) {
                int orient;
                int n = orient = Math.abs(this.v[i * 6 + 3] - this.v[i * 6 + 6]) > Math.abs(this.v[i * 6 + 4] - this.v[i * 6 + 7]) ? 1 : 0;
                int align = orient == 0 ? ((this.v[i * 6 + 3] + this.v[i * 6 + 6]) / 2.0f > this.v[0] ? 2 : 1) : ((this.v[i * 6 + 4] + this.v[i * 6 + 7]) / 2.0f > this.v[1] ? 1 : 2);
                this.setAlignment(orient, align, i);
            }
            return;
        }
        if (off.hitMe) {
            i = off.face.length;
            if (off.area == null) {
                off.area = new Polygon[i];
                while (i-- > 0) {
                    ((Polygon[])off.area)[i] = new Polygon(new int[4], new int[4], 4);
                }
            }
        }
        for (i = 0; i < off.face.length; ++i) {
            this.face(this.g, off, i, off.hitMe ? ((Polygon[])off.area)[i] : null);
        }
    }

    boolean inRange(double a) {
        boolean ok;
        double d;
        a -= (double)this.ang00;
        if (d < 0.0) {
            a = -a;
        }
        boolean bl = ok = a < 90.0 || a > 270.0 && a < 450.0;
        return this.swap ? ok : !ok;
    }

    void drawWedge3D(Wedge3D pie) {
        boolean opaq;
        int jj;
        if (pie.radius <= 0.0f) {
            this.matrix.xo = pie.center.x;
            this.matrix.yo = pie.center.y;
            this.matrix.zo = 0.0f;
            return;
        }
        float startAngle = pie.startAngle;
        float step = pie.endAngle - startAngle;
        if (step <= 0.0f) {
            return;
        }
        this.ang00 = ChartCore.zeroAngle(this.order);
        this.swap = ChartCore.swapAngle(this.order);
        if (startAngle >= 360.0f) {
            startAngle -= 360.0f;
        }
        int steps = (int)(step / 10.0f) + 1;
        step /= (float)steps;
        int i = (steps + 2) * 6;
        if (this.v.length < i) {
            this.v = new float[i];
        }
        int width = (int)(pie.radius * pie.thickness / 100.0f);
        int iii = 0;
        int ang0 = this.ang00 + 90;
        if (ang0 > 360) {
            ang0 -= 360;
        }
        int iAll = 0;
        int iStart = -1;
        int iEnd = -1;
        if (this.inRange(startAngle)) {
            iStart = 2;
        }
        boolean b1st = (pie.skip & 3) < 3;
        boolean b2nd = (pie.skip & 3) != 1;
        for (jj = 0; jj < 2; ++jj) {
            float j = -0.5f + (float)jj;
            i = -1;
            ++iAll;
            this.v[iii++] = pie.center.x;
            this.v[iii++] = pie.center.y;
            this.v[iii++] = pie.center.z + j * (float)width;
            float a1 = startAngle;
            while (++i <= steps) {
                ++iAll;
                float a2 = a1 + step;
                if (jj == 0 && i > 0 && i < steps && ((float)ang0 >= a1 && (float)ang0 <= a2 || (float)(ang0 + 360) >= a1 && (float)(ang0 + 360) <= a2 || (float)(ang0 + 180) >= a1 && (float)(ang0 + 180) <= a2 || (float)(ang0 - 180) >= a1 && (float)(ang0 - 180) <= a2)) {
                    if (iStart < 0) {
                        iStart = iAll;
                    } else if (iEnd < 0) {
                        iEnd = iAll + 1;
                    }
                }
                if (iStart < 0) {
                    if (this.inRange(a1)) {
                        iStart = iAll;
                    }
                } else if (iStart == 2 && iEnd < 0 && !this.inRange(a1)) {
                    iEnd = iAll + 1;
                }
                this.v[iii++] = pie.center.x + (float)((double)pie.radius * Math.cos(Math.PI * (double)a1 / 180.0));
                this.v[iii++] = pie.center.y + (float)((double)pie.radius * Math.sin(Math.PI * (double)a1 / 180.0));
                this.v[iii++] = pie.center.z + j * (float)width;
                a1 = a2;
            }
        }
        if (iStart < 0 && this.inRange(pie.endAngle)) {
            iStart = 2;
        }
        this.matrix.transform(this.v, iAll);
        Color fillClr = pie.fillColor;
        Color drawClr = pie.drawColor;
        Stroke str = null;
        if (pie.selected != null) {
            fillClr = pie.selected.fillColor;
            drawClr = pie.selected.drawColor;
            if (drawClr != null) {
                i = pie.selected.drawThickness;
                if (i < 1) {
                    drawClr = null;
                }
                if (i > 1) {
                    str = Render.setStroke(this.g, i, null, false);
                }
            }
        }
        boolean bl = opaq = this.opaque && fillClr != null;
        if (opaq && pie.selected != null) {
            boolean bl2 = opaq = fillClr.getAlpha() > 252;
        }
        if (this.xx.length < (steps += 2) * 2 + 1) {
            this.xx = new int[steps * 2 + 1];
            this.yy = new int[steps * 2 + 1];
        }
        for (jj = 0; jj < 2; ++jj) {
            iAll = ((this.order & 0x70) != 64 ? 1 - jj : jj) * steps * 3;
            for (i = 0; i < steps; ++i) {
                this.xx[i] = (int)this.v[i * 3 + iAll];
                this.yy[i] = (int)this.v[i * 3 + iAll + 1];
            }
            this.xx[steps] = this.xx[0];
            this.yy[steps] = this.yy[0];
            if (b2nd && fillClr != null && jj > 0) {
                this.g.setForeground(fillClr);
                this.g.fillPolygon(this.xx, this.yy, steps + 1);
                if (drawClr == null) {
                    this.g.drawPolygon(this.xx, this.yy, steps + 1);
                }
            }
            if (drawClr != null && (jj == 0 && !opaq && b1st || jj == 1 && b2nd)) {
                this.g.setForeground(drawClr);
                this.g.drawPolygon(this.xx, this.yy, steps + 1);
            }
            if (jj == 0) {
                pie.area = new Polygon[]{null, null, null};
                if (b1st) {
                    this.fillCuts(this.g, fillClr, drawClr, steps);
                }
                for (i = 1; i < steps; ++i) {
                    this.xx[i - 1] = (int)this.v[i * 3];
                    this.yy[i - 1] = (int)this.v[i * 3 + 1];
                    this.xx[steps * 2 - i - 2] = (int)this.v[i * 3 + steps * 3];
                    this.yy[steps * 2 - i - 2] = (int)this.v[i * 3 + steps * 3 + 1];
                }
                this.xx[steps * 2 - 2] = this.xx[0];
                this.yy[steps * 2 - 2] = this.yy[0];
                if (!b2nd || iStart < 0) continue;
                int steps2 = steps;
                if (steps < 19 && iEnd >= 0 && this.v[5] > this.v[(steps - 1) * 3 + 2]) {
                    iEnd = -1;
                }
                if (iStart != 2 || iEnd >= 2) {
                    steps2 = this.fillEdge(steps2, iStart - 2, iEnd - 2);
                }
                if (fillClr != null) {
                    this.g.setForeground(MiscFunctions.sideColor(fillClr, 6, this.shadows));
                    this.g.fillPolygon(this.xx, this.yy, steps2 * 2 - 1);
                }
                if (drawClr != null) {
                    this.g.setForeground(drawClr);
                }
                this.g.drawPolygon(this.xx, this.yy, steps2 * 2 - 1);
                ((Polygon[])pie.area)[0] = new Polygon(this.xx, this.yy, steps2 * 2 - 2);
                if (steps < 18 + iEnd || iEnd <= iStart) continue;
                steps2 = this.fillEdge(steps, iEnd + 15, -1);
                if (fillClr != null) {
                    this.g.setForeground(MiscFunctions.sideColor(fillClr, 6, this.shadows));
                    this.g.fillPolygon(this.xx, this.yy, steps2 * 2 - 1);
                }
                if (drawClr != null) {
                    this.g.setForeground(drawClr);
                }
                this.g.drawPolygon(this.xx, this.yy, steps2 * 2 - 1);
                ((Polygon[])pie.area)[2] = new Polygon(this.xx, this.yy, steps2 * 2 - 2);
                continue;
            }
            ((Polygon[])pie.area)[1] = new Polygon(this.xx, this.yy, steps - 1);
        }
        if ((pie.skip & 1) != 0) {
            pie.skip = (pie.skip & 2) != 0 ? (pie.skip &= 0xFFFFFFFD) : (pie.skip |= 2);
        }
        if (str != null) {
            this.g.setStroke(str);
        }
    }

    void fillCuts(Graphics g, Color fillClr, Color drawClr, int steps) {
        boolean top = this.v[steps * 3 + 5] > this.v[steps * 6 - 1];
        this.xx[0] = this.xx[4] = (int)this.v[0];
        this.yy[0] = this.yy[4] = (int)this.v[1];
        this.xx[3] = (int)this.v[steps * 3];
        this.yy[3] = (int)this.v[steps * 3 + 1];
        for (int i = 0; i < 2; ++i) {
            if (top == (i == 0)) {
                this.xx[1] = (int)this.v[3];
                this.yy[1] = (int)this.v[4];
                this.xx[2] = (int)this.v[steps * 3 + 3];
                this.yy[2] = (int)this.v[steps * 3 + 4];
            } else {
                this.xx[1] = (int)this.v[steps * 3 - 3];
                this.yy[1] = (int)this.v[steps * 3 - 2];
                this.xx[2] = (int)this.v[steps * 6 - 3];
                this.yy[2] = (int)this.v[steps * 6 - 2];
            }
            if (fillClr != null) {
                g.setForeground(MiscFunctions.sideColor(fillClr, 7, this.shadows));
                g.fillPolygon(this.xx, this.yy, 5);
            }
            if (drawClr != null) {
                g.setForeground(drawClr);
            }
            g.drawPolygon(this.xx, this.yy, 5);
        }
    }

    int fillEdge(int steps, int iStart, int iEnd) {
        int count;
        if (iStart == 0) {
            count = iEnd * 2;
            for (int i = iEnd; i > 0; --i) {
                this.xx[count - i] = this.xx[steps * 2 - i - 2];
                this.yy[count - i] = this.yy[steps * 2 - i - 2];
            }
        } else {
            if (iStart + 1 < steps) {
                ++iStart;
            }
            count = steps - iStart;
            if (iEnd++ > iStart) {
                count = iEnd - iStart;
            }
            count = count * 2 - 1;
            iEnd = iEnd <= iStart ? steps : iEnd;
            int ii = 0;
            int i = iStart;
            while (i < iEnd) {
                this.xx[ii] = this.xx[i - 1];
                this.yy[ii] = this.yy[i - 1];
                ++i;
                ++ii;
            }
            --ii;
            i = iEnd - 1;
            while (i >= iStart) {
                this.xx[count - ii] = this.xx[steps * 2 - i - 2];
                this.yy[count - ii] = this.yy[steps * 2 - i - 2];
                --i;
                --ii;
            }
            ++count;
        }
        this.xx[count] = this.xx[0];
        this.yy[count] = this.yy[0];
        return count / 2 + 1;
    }

    void face(Graphics g, IFGOFF off, int id, Polygon poly) {
        Stroke str;
        boolean b;
        int i;
        Face f = off.face[id];
        if (f == null) {
            return;
        }
        int iLen = f.index.length;
        int[] xs = new int[iLen + 1];
        int[] ys = new int[iLen + 1];
        for (i = 0; i < iLen; ++i) {
            xs[i] = (int)this.v[f.index[i] * 3];
            ys[i] = (int)this.v[f.index[i] * 3 + 1];
            if (poly == null) continue;
            poly.xpoints[i] = xs[i];
            poly.ypoints[i] = ys[i];
        }
        xs[iLen] = xs[0];
        ys[iLen] = ys[0];
        Color fillClr = off.fillColor;
        Color drawClr = off.drawColor;
        i = 1;
        boolean bl = b = off.selected != null && off.drawAll();
        if (b) {
            fillClr = off.selected.fillColor;
            drawClr = off.selected.drawColor;
            if (drawClr != null && (i = off.selected.drawThickness) < 1) {
                drawClr = null;
            }
        }
        boolean bl2 = b = b || off.corners == null;
        if ((b || iLen != 4) && fillClr != null && this.sideClr(g, fillClr, f.side, false)) {
            g.fillPolygon(xs, ys, iLen + 1);
            g.drawPolygon(xs, ys, iLen + 1);
        }
        if (off.quality > 0 && iLen == 4) {
            IFGGraphics3D.face(g, xs, ys, b ? null : off.corners[0], b ? null : off.corners[1], b ? null : off.corners[2], b ? null : off.corners[3], off.quality, off.lines > 1 ? drawClr : null);
        }
        Stroke stroke = str = i < 2 ? null : Render.setStroke(g, i, null, false);
        if (drawClr != null && off.lines == 1) {
            g.setForeground(drawClr);
            g.drawPolygon(xs, ys, iLen + 1);
        }
        if (str != null) {
            g.setStroke(str);
        }
    }

    boolean sideClr(Graphics g, Color c, int side, boolean negative) {
        if (c == null || side < -1) {
            return false;
        }
        int invert = 3;
        if ((this.order & 0x800) != 0) {
            if (side == 1) {
                side = 0;
            } else if (side == 0) {
                side = 1;
            }
            invert = 5;
        }
        if (negative) {
            if (side == invert) {
                side = 0;
            } else if (side == 0) {
                side = invert;
            }
        }
        if ((c = MiscFunctions.sideColor(c, side, this.shadows)) == null) {
            return false;
        }
        g.setForeground(c);
        return true;
    }
}

