/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.render;

import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.Box3D;
import oracle.bpm.chart.core.primitives.ChartImage;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Ellipse;
import oracle.bpm.chart.core.primitives.Epoch;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.core.primitives.Line;
import oracle.bpm.chart.core.primitives.Line3D;
import oracle.bpm.chart.core.primitives.PointSet;
import oracle.bpm.chart.core.primitives.Polygon;
import oracle.bpm.chart.core.primitives.Polyline;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.core.primitives.Sphere;
import oracle.bpm.chart.core.primitives.Symbol;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.primitives.Text3D;
import oracle.bpm.chart.core.primitives.Wedge;
import oracle.bpm.chart.core.primitives.Wedge3D;
import oracle.bpm.chart.render.IFGGraphics3D;
import oracle.bpm.chart.render.Render;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.StrokeControlMode;
import oracle.bpm.ui.Image;

public class ChartRender {
    public transient boolean order = false;
    transient Image chartImage;
    transient IChartComponent component;
    private transient IFGGraphics3D graphics3d;

    public ChartRender(IChartComponent component) {
        this.component = component;
        this.graphics3d = new IFGGraphics3D();
    }

    public static void renderTip(Graphics g, Text t) {
        if (t != null) {
            Render.text(t, g);
        }
    }

    public void renderChart(Object grImg, SceneGraph scene, int sceneWidth, int sceneHeight) {
        this.renderChart(grImg, scene, sceneWidth, sceneHeight, false, false, null, null);
    }

    public synchronized void renderChart(Object grImg, SceneGraph scene, int sceneWidth, int sceneHeight, boolean topSelect, boolean selOnly, Primitive selMain, PrimitiveShape selSel) {
        boolean bNull;
        if (scene == null) {
            return;
        }
        if (scene.count() == 0) {
            return;
        }
        Graphics gOld = null;
        Graphics g = grImg instanceof Graphics ? (Graphics)grImg : null;
        boolean bl = bNull = g == null;
        if (bNull || topSelect) {
            Image img;
            if (grImg instanceof Image) {
                img = (Image)grImg;
            } else {
                img = this.chartImage;
                if (img != null && (img.getIconWidth() != sceneWidth || img.getIconHeight() != sceneHeight)) {
                    img = null;
                }
                if (img == null) {
                    selOnly = false;
                    img = Image.create(sceneWidth, sceneHeight);
                }
            }
            if (topSelect) {
                this.chartImage = img;
                gOld = g;
            }
            g = img.getGraphics();
        }
        if (g == null) {
            return;
        }
        if (((ColorAppearance)this.component.getChartAppearance(6)).getAntialias()) {
            g.setAntialiasing(AntialiasingMode.ON);
            g.setStrokeControl(StrokeControlMode.NORMALIZE);
            if (gOld != null) {
                gOld.setAntialiasing(AntialiasingMode.ON);
                gOld.setStrokeControl(StrokeControlMode.NORMALIZE);
            }
        }
        if (!selOnly || !topSelect) {
            this.renderSceneGraph(scene, g, topSelect, false, selMain, selSel);
        }
        if (topSelect) {
            g.dispose();
            assert (gOld != null);
            gOld.drawImage(this.chartImage, 0, 0, null);
            if (selMain != null) {
                this.renderSceneGraph(scene, gOld, topSelect, true, selMain, selSel);
            }
        }
        if (bNull) {
            g.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void renderSceneGraph(SceneGraph scene, Graphics g, boolean topSelect, boolean select, Primitive selMain, PrimitiveShape selSel) {
        if (scene == null || g == null) {
            return;
        }
        this.graphics3d.init(g);
        iMax = iNum = scene.count();
        if (topSelect) {
            --iMax;
            if (selMain != null) {
                selMain.selected = null;
            }
        }
        sel = null;
        block18: for (i = 0; i <= iMax; ++i) {
            v0 = p = i == iNum ? sel : scene.get(i);
            if (select) {
                if (selMain instanceof DataPoint) {
                    points = null;
                    if (p.hitMe) {
                        if (p instanceof Polygon) {
                            points = ((Polygon)p).dataPoints;
                        } else if (p instanceof Polyline) {
                            points = ((Polyline)p).points;
                        } else if (p instanceof PointSet) {
                            points = ((PointSet)p).points;
                        }
                    }
                    v1 = iLen = points == null ? -1 : points.length;
                    while (iLen-- > 0 && points[iLen] != selMain) {
                    }
                    if (iLen < 0) {
                        continue;
                    }
                } else {
                    p = selMain;
                }
                selMain.selected = selSel;
            }
            if (p == null) continue;
            type = p.type();
            switch (type) {
                case 10: {
                    Render.line((Line)p, g);
                    ** GOTO lbl98
                }
                case 24: {
                    this.graphics3d.drawString3D((Text3D)p);
                    ** GOTO lbl98
                }
                case 23: {
                    Render.text((Text)p, g);
                    ** GOTO lbl98
                }
                case 1: 
                case 27: {
                    if (p.selected != null && i < iNum) {
                        sel = p;
                        if (!select && p.drawAll()) continue block18;
                    }
                    if (type == 27) {
                        Render.wedge((Wedge)p, g);
                    } else if ((i == iNum || topSelect) && !p.drawAll()) {
                        Render.selPoint(g, p, 7);
                    } else {
                        Render.box((Box)p, g);
                    }
                    ** GOTO lbl98
                }
                case 6: {
                    Render.ellipse((Ellipse)p, g);
                    ** GOTO lbl98
                }
                case 12: {
                    Render.points((PointSet)p, g, select);
                    ** GOTO lbl98
                }
                case 21: {
                    Render.symbol((Symbol)p, g);
                    ** GOTO lbl98
                }
                case 14: {
                    Render.polygon((Polygon)p, g, select);
                    ** GOTO lbl98
                }
                case 17: {
                    Render.polyline((Polyline)p, g, select);
                    ** GOTO lbl98
                }
                case 29: {
                    Render.image((ChartImage)p, g);
                    ** GOTO lbl98
                }
                case 9: {
                    if (p.selected == null || p.drawAll()) ** GOTO lbl81
                    if (i != iNum && !topSelect) ** GOTO lbl80
                    Render.selPoint(g, p, 7);
                    if (!topSelect) ** GOTO lbl81
                    ** GOTO lbl98
lbl80:
                    // 1 sources

                    sel = p;
lbl81:
                    // 3 sources

                    if (i < iNum) {
                        this.graphics3d.drawOFF((IFGOFF)p, (PrimitiveShape)p);
                    }
                    ** GOTO lbl98
                }
                case 20: {
                    this.graphics3d.fillSphere3D((Sphere)p);
                    ** GOTO lbl98
                }
                case 3: {
                    this.graphics3d.drawBox3D((Box3D)p);
                    ** GOTO lbl98
                }
                case 11: {
                    this.graphics3d.drawLine3D((Line3D)p);
                    ** GOTO lbl98
                }
                case 28: {
                    this.graphics3d.drawWedge3D((Wedge3D)p);
                    ** GOTO lbl98
                }
                case 7: {
                    this.graphics3d.init(this.component, (Epoch)p);
                }
lbl98:
                // 20 sources

                default: {
                    if (select) break block18;
                }
            }
        }
    }
}

