/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.util;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import oracle.bpm.ui.Image;

public class ChartImageWriter {
    public static void encode(Image img, String imgType, OutputStream stream) {
        boolean success = false;
        Object imgEncoder = null;
        try {
            Class<?> encodeParamClass = Class.forName("com.sun.media.jai.codec.ImageEncodeParam");
            Class<?> imgCodecClass = Class.forName("com.sun.media.jai.codec.ImageCodec");
            Class<?> encoderClass = Class.forName("com.sun.media.jai.codec.ImageEncoder");
            if (imgEncoder == null) {
                imgEncoder = imgCodecClass.getMethod("createImageEncoder", Class.forName("java.lang.String"), Class.forName("java.io.OutputStream"), encodeParamClass).invoke(null, imgType, stream, null);
            }
            if (imgEncoder != null && encoderClass.isInstance(imgEncoder)) {
                encoderClass.getMethod("encode", Class.forName("java.awt.image.RenderedImage")).invoke(imgEncoder, img);
                success = true;
            }
        }
        catch (ClassNotFoundException cnf) {
            System.err.println("Could not load Encoder.  Trying com.sun.image.codec.jpeg.JPEGImageEncoder ...");
        }
        catch (ExceptionInInitializerError ei) {
        }
        catch (LinkageError le) {
        }
        catch (NoSuchMethodException nsm) {
            nsm.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        if (!success) {
            try {
                Class<?> jpegCodecClass = Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
                Class<?> jpegEncoderClass = Class.forName("com.sun.image.codec.jpeg.JPEGImageEncoder");
                if (imgEncoder == null || !jpegEncoderClass.isInstance(imgEncoder)) {
                    imgEncoder = jpegCodecClass.getMethod("createJPEGEncoder", Class.forName("java.io.OutputStream")).invoke(jpegEncoderClass, stream);
                }
                if (imgEncoder != null && jpegEncoderClass.isInstance(imgEncoder)) {
                    jpegEncoderClass.getMethod("encode", Class.forName("java.awt.image.BufferedImage")).invoke(imgEncoder, img);
                }
            }
            catch (ClassNotFoundException cnf) {
                System.err.println("Could not load Encoder com.sun.image.codec.jpeg.JPEGImageEncoder");
            }
            catch (ExceptionInInitializerError ei) {
            }
            catch (LinkageError le) {
            }
            catch (NoSuchMethodException nsm) {
                nsm.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
        }
    }

    public static void encode(Image img, Object imgEncoder) {
        try {
            Class<?> encodeParamClass = Class.forName("com.sun.media.jai.codec.ImageEncodeParam");
            Class<?> imgCodecClass = Class.forName("com.sun.media.jai.codec.ImageCodec");
            Class<?> encoderClass = Class.forName("com.sun.media.jai.codec.ImageEncoder");
            Class<?> jpegCodecClass = Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
            Class<?> jpegEncoderClass = Class.forName("com.sun.image.codec.jpeg.JPEGImageEncoder");
            if (imgEncoder == null) {
                return;
            }
            if (encoderClass.isInstance(imgEncoder)) {
                encoderClass.getMethod("encode", Class.forName("java.awt.image.RenderedImage")).invoke(imgEncoder, img);
            } else if (jpegEncoderClass.isInstance(imgEncoder)) {
                jpegEncoderClass.getMethod("encode", Class.forName("java.awt.image.BufferedImage")).invoke(imgEncoder, img);
            }
        }
        catch (ClassNotFoundException cnf) {
            System.err.println("Could not load Encoder.  Trying com.sun.image.codec.jpeg.JPEGImageEncoder ...");
        }
        catch (ExceptionInInitializerError ei) {
        }
        catch (LinkageError le) {
        }
        catch (NoSuchMethodException nsm) {
            nsm.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
    }
}

