/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Polygon;

public class Primitive {
    public transient Object area;
    public transient int column = -1;
    public transient Color drawColor;
    public transient Color fillColor;
    public transient boolean hitMe = false;
    public transient int row = -1;
    public transient PrimitiveShape selected;
    public transient Object value;
    transient int hit1 = 0;
    static final int ONE = 8;
    static final int MOUSE = 7;
    public static final int NONE = -1;
    public static final int BOX = 1;
    public static final int BOX3D = 3;
    public static final int POINT = 4;
    public static final int ELLIPSE = 6;
    public static final int EPOCH = 7;
    public static final int IFGOFF = 9;
    public static final int LINE = 10;
    public static final int LINE3D = 11;
    public static final int POINTS = 12;
    public static final int POLYGON = 14;
    public static final int POLYLINE = 17;
    public static final int SPHERE = 20;
    public static final int SYMBOL = 21;
    public static final int TEXT = 23;
    public static final int TEXT3D = 24;
    public static final int WEDGE = 27;
    public static final int WEDGE3D = 28;
    public static final int IMAGE = 29;

    public Primitive() {
    }

    public Primitive(int r, int c) {
        this.row = r;
        this.column = c;
    }

    public static int hit(Primitive p) {
        return p == null ? -1 : p.hit1 & 7;
    }

    public static int update(Primitive p, int newHit) {
        if (p != null) {
            if (newHit < 0) {
                newHit = 0;
            }
            p.hit1 = newHit = newHit & 0xFFFFFFF7 | p.hit1 & 8;
        }
        return newHit;
    }

    public Primitive[] getPrimitives() {
        return null;
    }

    public boolean hitTest(Point p) {
        if (this.hitMe && this.area instanceof Polygon[]) {
            Polygon[] polygons = (Polygon[])this.area;
            int i = polygons.length;
            while (i-- > 0) {
                if (polygons[i] == null || !polygons[i].contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    public void set1(boolean enable) {
        if (enable) {
            this.hit1 = 8;
        }
    }

    public boolean is1() {
        return (this.hit1 & 8) != 0;
    }

    public boolean drawAll() {
        return (this.hit1 & 0xF) == 0;
    }

    public int lastHit() {
        return this.hit1 & 8 | this.hit1 >> 4 & 7;
    }

    public int fullHit() {
        return (this.hit1 & 0xF) != 0 ? this.hit1 & 0xF : this.hit1 >> 4 & 7;
    }

    public int type() {
        return -1;
    }
}

