/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.geom.Point;

public class Polygon
extends PrimitiveShape {
    public DataPoint[] dataPoints;
    public Point[] points;

    public Polygon(DataPoint[] points) {
        int iLen;
        this.dataPoints = points;
        this.hitMe = true;
        int n = iLen = points == null ? -1 : points.length - 3;
        if (iLen < 0) {
            return;
        }
        if (points != null) {
            int y0 = points[iLen + 2].point.getY();
            int lastWidth = (points[1].point.getX() - points[0].point.getX()) / 2;
            if (lastWidth > 4) {
                lastWidth = 4;
            }
            if (lastWidth < 1) {
                lastWidth = 1;
            }
            for (int i = 0; i <= iLen; ++i) {
                DataPoint p1 = points[i];
                DataPoint p2 = i == iLen ? p1 : points[i + 1];
                int[] xp = new int[5];
                int[] yp = new int[5];
                int x = p1.point.getX();
                int y = p1.point.getY();
                if (i == iLen) {
                    x -= lastWidth / 2;
                    y0 = (y -= lastWidth / 2) + lastWidth;
                }
                xp[4] = xp[3] = x;
                xp[0] = xp[3];
                yp[0] = yp[4] = y;
                x = p2.point.getX();
                if (i == iLen) {
                    x += lastWidth;
                }
                xp[1] = xp[2] = x;
                yp[1] = p2.point.getY();
                yp[2] = yp[3] = y0;
                p1.area = new oracle.bpm.geom.Polygon[]{null, new oracle.bpm.geom.Polygon(xp, yp, 5)};
            }
        }
    }

    public Polygon(Point[] points) {
        this.points = points;
    }

    @Override
    public Primitive[] getPrimitives() {
        return this.dataPoints;
    }

    @Override
    public boolean hitTest(Point point) {
        boolean hit = super.hitTest(point);
        if (hit) {
            return true;
        }
        if (!this.hitMe || this.points == null) {
            return false;
        }
        int i = -1;
        int ii = this.points.length;
        oracle.bpm.geom.Polygon p = new oracle.bpm.geom.Polygon(new int[ii + 1], new int[ii + 1], ii + 1);
        while (++i < ii) {
            p.xpoints[i] = this.points[i].getX();
            p.ypoints[i] = this.points[i].getY();
            if (i != 0) continue;
            p.xpoints[ii] = this.points[i].getX();
            p.ypoints[ii] = this.points[i].getY();
        }
        return p.contains(point);
    }

    @Override
    public int type() {
        return 14;
    }
}

