/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.layers.Layer;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.MarginsAppearance;
import oracle.bpm.chart.resources.appearance.TitleAppearance;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.geom.Rectangle;

public class TitlePanel
extends Layer {
    private transient int location;

    public TitlePanel(IChartComponent component, ChartCore core, int location) {
        super(component, core);
        this.location = location;
    }

    @Override
    public ChartAppearance getAppearance() {
        switch (this.location) {
            case 0: {
                return this.component.getChartAppearance(2);
            }
            case 1: {
                return this.component.getChartAppearance(3);
            }
            case 2: {
                return this.component.getChartAppearance(4);
            }
            case 3: {
                return this.component.getChartAppearance(5);
            }
        }
        return null;
    }

    public int getExtent() {
        return ((TitleAppearance)this.getAppearance()).getExtent();
    }

    @Override
    public boolean isVisible() {
        return ((TitleAppearance)this.getAppearance()).getVisible();
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        TitleAppearance titleApp = (TitleAppearance)this.getAppearance();
        if (!titleApp.getVisible()) {
            return;
        }
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.TITLE_LAYER);
        String formatText = LabelFormatter.replaceKeywords(titleApp.getText());
        LabelStyle label = new LabelStyle();
        label.setFont(titleApp.getFont());
        label.setFontSizeBestFit(titleApp.getFontSizeBestFit());
        label.setFontColor(titleApp.getFontColor());
        label.setWrapText(titleApp.getWrapText());
        label.setHorizontalAlign(titleApp.getHorizontalAlign());
        label.setVerticalAlign(titleApp.getVerticalAlign());
        label.setOrientation(titleApp.getTextOrientation());
        scene.add(new Text(this.innerBounds, formatText, label));
    }

    @Override
    void calculateInnerBounds() {
        TitleAppearance titleApp = (TitleAppearance)this.getAppearance();
        MarginsAppearance margins = titleApp.getMargins();
        this.innerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY(), this.outerBounds.getWidth(), this.outerBounds.getHeight());
        int x = this.innerBounds.getX() + margins.getLeft();
        int y = this.innerBounds.getY() + margins.getTop();
        int w = this.innerBounds.getWidth() - (margins.getLeft() + margins.getRight());
        int h = this.innerBounds.getHeight() - (margins.getTop() + margins.getBottom());
        this.innerBounds = new Rectangle(x, y, w, h);
    }
}

