/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Layer;
import oracle.bpm.chart.core.layers.TitlePanel;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.ChartImage;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.BackgroundAppearance;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Image;

public class TitleLayer
extends Layer {
    public transient TitlePanel[] titlePanels = new TitlePanel[4];
    private static final int borderSize = 5;

    public TitleLayer(IChartComponent component, ChartCore core) {
        super(component, core);
        for (int i = 0; i < 4; ++i) {
            this.titlePanels[i] = new TitlePanel(component, core, i);
        }
    }

    @Override
    public void setBounds(Rectangle bounds) {
        int bottomHeight;
        super.setBounds(bounds);
        int topHeight = this.titlePanels[0].isVisible() ? this.titlePanels[0].getExtent() : 5;
        int leftWidth = this.titlePanels[1].isVisible() ? this.titlePanels[1].getExtent() : 5;
        int rightWidth = this.titlePanels[2].isVisible() ? this.titlePanels[2].getExtent() : 5;
        int n = bottomHeight = this.titlePanels[3].isVisible() ? this.titlePanels[3].getExtent() : 5;
        if (this.titlePanels[0].isVisible()) {
            this.titlePanels[0].setBounds(this.outerBounds.getX(), this.outerBounds.getY(), this.outerBounds.getWidth(), topHeight);
        }
        if (this.titlePanels[1].isVisible()) {
            this.titlePanels[1].setBounds(this.outerBounds.getX(), topHeight, leftWidth, this.outerBounds.getHeight() - (topHeight + bottomHeight));
        }
        if (this.titlePanels[2].isVisible()) {
            this.titlePanels[2].setBounds(this.outerBounds.getWidth() - rightWidth, topHeight, rightWidth, this.outerBounds.getHeight() - (topHeight + bottomHeight));
        }
        if (this.titlePanels[3].isVisible()) {
            this.titlePanels[3].setBounds(this.outerBounds.getX(), this.outerBounds.getHeight() - bottomHeight, this.outerBounds.getWidth(), bottomHeight);
        }
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        String s;
        BackgroundAppearance app = (BackgroundAppearance)this.component.getChartAppearance(26);
        Box backBox = new Box(new Rectangle(0, 0, this.core.componentWidth, this.core.componentHeight));
        backBox.drawThickness = 0;
        if (this.core.opaque) {
            backBox.fillColor = app.getColor();
        }
        scene.add(backBox);
        Image img = app.getImage();
        if (img == null && (s = app.getImagePath()) != null) {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (s.charAt(i) != '\\') continue;
                if (i > 1 && s.charAt(i - 1) == '\\') {
                    --i;
                    continue;
                }
                s = i == 0 ? String.valueOf('\\') + s : s.substring(0, i) + '\\' + s.substring(i);
                --i;
            }
            img = this.file(s);
        }
        if (img != null) {
            scene.add(new ChartImage(img, this.outerBounds, app.getImageStyle()));
        }
    }

    @Override
    void calculateInnerBounds() {
        int topHeight = this.titlePanels[0].isVisible() ? this.titlePanels[0].getExtent() : 5;
        int leftWidth = this.titlePanels[1].isVisible() ? this.titlePanels[1].getExtent() : 5;
        int rightWidth = this.titlePanels[2].isVisible() ? this.titlePanels[2].getExtent() : 5;
        int bottomHeight = this.titlePanels[3].isVisible() ? this.titlePanels[3].getExtent() : 5;
        this.innerBounds = new Rectangle(this.outerBounds.getX() + leftWidth, this.outerBounds.getY() + topHeight, this.outerBounds.getWidth() - (leftWidth + rightWidth), this.outerBounds.getHeight() - (topHeight + bottomHeight));
    }

    Image file(String name) {
        return null;
    }
}

