/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis3D;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.layers.LinearAxis3D;
import oracle.bpm.chart.core.layers.SetAxis3D;
import oracle.bpm.chart.core.primitives.Epoch;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.core.primitives.Line3D;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AxisAppearance;
import oracle.bpm.chart.resources.appearance.ChartGridAppearance;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.draw.Color;

public class ThreeDGridLayer
extends ChartLayer3D {
    transient Axis3D[] axs = new Axis3D[6];
    transient ChartType chartType = ChartType.COLUMN_CHART_3D;
    transient LabelStyle[] sts = new LabelStyle[6];
    static final int SHORT_TEXT = 16;

    public ThreeDGridLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    public static boolean isShortText(int id) {
        return (id & 0x10) != 0;
    }

    public void setChartType(ChartType type) {
        this.chartType = type;
        if (this.chartType.equals(ChartType.PIE_CHART_3D)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.sts[i] = new LabelStyle(DefaultConstants.D_AXIS_LABEL_FONT, null, false, false, false, 2, 0, 0);
        }
        this.axs[0] = new SetAxis3D(this.component, this.core, 2);
        this.axs[3] = new SetAxis3D(this.component, this.core, 2);
        if (this.chartType.equals(ChartType.BAR_CHART_3D) || this.chartType.equals(ChartType.STACK_BAR_CHART_3D)) {
            this.axs[2] = new LinearAxis3D(this.component, this.core, 0);
            this.axs[5] = new LinearAxis3D(this.component, this.core, 0);
            this.axs[1] = new SetAxis3D(this.component, this.core, 1);
            this.axs[4] = new SetAxis3D(this.component, this.core, 1);
            if (this.chartType.equals(ChartType.STACK_BAR_CHART_3D)) {
                this.axs[4].itemLabelFormat = "";
                this.axs[1].itemLabelFormat = "";
                if (this.core.stackStyle == 1) {
                    this.axs[5].itemLabelFormat = "<DATA_VALUE:+0>%";
                    this.axs[2].itemLabelFormat = "<DATA_VALUE:+0>%";
                }
            }
        } else {
            this.axs[2] = new SetAxis3D(this.component, this.core, 0);
            this.axs[5] = new SetAxis3D(this.component, this.core, 0);
            this.axs[1] = new LinearAxis3D(this.component, this.core, 1);
            this.axs[4] = new LinearAxis3D(this.component, this.core, 1);
            if (this.chartType.equals(ChartType.STACK_COLUMN_CHART_3D)) {
                this.axs[5].itemLabelFormat = "";
                this.axs[2].itemLabelFormat = "";
                if (this.core.stackStyle == 1) {
                    this.axs[4].itemLabelFormat = "<DATA_VALUE:+0>%";
                    this.axs[1].itemLabelFormat = "<DATA_VALUE:+0>%";
                }
            }
        }
        this.axs[2].axisApp = this.axs[5].axisApp = (AxisAppearance)this.component.getChartAppearance(9);
        this.axs[1].axisApp = this.axs[4].axisApp = (AxisAppearance)this.component.getChartAppearance(10);
        this.axs[0].axisApp = this.axs[3].axisApp = (AxisAppearance)this.component.getChartAppearance(11);
        this.resetAxisLabelFormat();
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        Vector3D k;
        int iz;
        int iy;
        int i;
        if (!this.isVisible() || this.axs[0] == null) {
            return;
        }
        super.fillSceneGraph(scene);
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double dataMin = this.core.dataMin;
        double dataMax = this.core.dataMax;
        if (this.core.stackStyle == 1) {
            dataMin = dataMax > 0.0 ? 0.0 : -100.0;
            dataMax = dataMax > 0.0 ? 100.0 : 0.0;
        }
        float x = this.volume.x;
        float y = this.volume.y;
        float z = this.volume.z;
        Vector3D[] vv = new Vector3D[]{new Vector3D(x, y, z), new Vector3D(x, y, 0.0f), new Vector3D(x, 0.0f, z), new Vector3D(x, 0.0f, 0.0f), new Vector3D(0.0f, y, z), new Vector3D(0.0f, y, 0.0f), new Vector3D(0.0f, 0.0f, z), new Vector3D()};
        int order = this.core.order;
        int[] id = new int[]{2, 6, 7, 3, 4, 5, 7, 6, 1, 3, 7, 5, 0, 1, 5, 4, 0, 4, 6, 2, 0, 2, 3, 1};
        int[][] ids = new int[3][4];
        for (i = 0; i < 3; ++i) {
            int shift = order >> (5 - i) * 4 & 7;
            System.arraycopy(id, shift * 4, ids[i], 0, 4);
        }
        int i0 = this.center(ids);
        int ix = i0 + 4;
        if (ix > 7) {
            ix = i0 - 4;
        }
        if (!this.hasIn2(ids, iy = i0 + 2)) {
            iy = i0 - 2;
        }
        if (!this.hasIn2(ids, iz = i0 + 1)) {
            iz = i0 - 1;
        }
        int ixy = this.forth(ids, i0, ix, iy);
        int ixz = this.forth(ids, i0, ix, iz);
        int iyz = this.forth(ids, i0, iy, iz);
        Color c = ((ChartGridAppearance)this.component.getChartAppearance(27)).getBackColor();
        for (i = 0; i < 3; ++i) {
            scene.add(IFGOFF.rectangle(vv[ids[i][0]], vv[ids[i][1]], vv[ids[i][2]], vv[ids[i][3]], c));
        }
        Vector3D[] startPoints = new Vector3D[]{vv[iy], vv[iz], vv[iz], vv[ix], vv[ix], vv[iy]};
        Vector3D[] endPoints = new Vector3D[]{vv[iyz], vv[iyz], vv[ixz], vv[ixz], vv[ixy], vv[ixy]};
        Vector3D[] spanPlane = new Vector3D[]{new Vector3D(0.0f, -y, 0.0f), new Vector3D(0.0f, 0.0f, -z), new Vector3D(0.0f, 0.0f, -z), new Vector3D(-x, 0.0f, 0.0f), new Vector3D(-x, 0.0f, 0.0f), new Vector3D(0.0f, -y, 0.0f)};
        if (iy != 4 && iy != 5 && iy != 6 && iy != 7) {
            k = startPoints[5];
            startPoints[5] = endPoints[5];
            endPoints[5] = k;
            spanPlane[3].x = spanPlane[4].x = x;
        }
        if (iz != 4 && iz != 5 && iz != 6 && iz != 7) {
            k = startPoints[2];
            startPoints[2] = endPoints[2];
            endPoints[2] = k;
        }
        if (ix != 2 && ix != 3 && ix != 6 && ix != 7) {
            k = startPoints[4];
            startPoints[4] = endPoints[4];
            endPoints[4] = k;
            spanPlane[0].y = spanPlane[5].y = y;
        }
        if (iz != 2 && iz != 3 && iz != 6 && iz != 7) {
            k = startPoints[1];
            startPoints[1] = endPoints[1];
            endPoints[1] = k;
        }
        if (ix != 1 && ix != 3 && ix != 5 && ix != 7) {
            k = startPoints[3];
            startPoints[3] = endPoints[3];
            endPoints[3] = k;
            spanPlane[1].z = spanPlane[2].z = z;
        }
        if (iy != 1 && iy != 3 && iy != 5 && iy != 7) {
            k = startPoints[0];
            startPoints[0] = endPoints[0];
            endPoints[0] = k;
        }
        float[] vert = new float[21];
        vert[0] = x / 2.0f;
        vert[1] = y / 2.0f;
        vert[2] = z / 2.0f;
        for (i = 0; i < 3; ++i) {
            vert[i * 6 + 3] = startPoints[i].x;
            vert[i * 6 + 4] = startPoints[i].y;
            vert[i * 6 + 5] = startPoints[i].z;
            vert[i * 6 + 6] = endPoints[i].x;
            vert[i * 6 + 7] = endPoints[i].y;
            vert[i * 6 + 8] = endPoints[i].z;
        }
        scene.add(new IFGOFF(vert));
        float[] spanStart = new float[]{this.volume.y, this.volume.z, this.volume.z, this.volume.x, this.volume.x, this.volume.y};
        if (this.chartType.equals(ChartType.BAR_CHART_3D) || this.chartType.equals(ChartType.STACK_BAR_CHART_3D)) {
            if (this.chartType.equals(ChartType.STACK_BAR_CHART_3D)) {
                colCount = 0;
            }
            this.axs[0].itemCount = this.axs[3].itemCount = rowCount;
            this.axs[1].itemCount = this.axs[4].itemCount = colCount;
        } else {
            if (this.chartType.equals(ChartType.STACK_COLUMN_CHART_3D)) {
                colCount = 0;
            }
            this.axs[0].itemCount = this.axs[3].itemCount = rowCount;
            this.axs[2].itemCount = this.axs[5].itemCount = colCount;
        }
        this.axs[0].strLabels = this.axs[3].strLabels = new String[rowCount];
        for (int rowc = 0; rowc < rowCount; ++rowc) {
            this.axs[0].strLabels[rowc] = this.axs[3].strLabels[rowc] = this.data.getRowLabel(rowc);
        }
        for (i = 0; i < 6; ++i) {
            this.axs[i].id = i;
            this.axs[i].setData(this.data);
            this.axs[i].outerBounds = this.innerBounds;
            this.axs[i].labelStyle = this.sts[i];
            this.axs[i].startPoint = startPoints[i];
            this.axs[i].endPoint = endPoints[i];
            this.axs[i].spanPlane = spanPlane[i];
            this.axs[i].dataMax = (float)dataMax;
            this.axs[i].dataMin = (float)dataMin;
            this.axs[i].fillSceneGraph(scene);
        }
        AxisAppearance ap = (AxisAppearance)this.component.getChartAppearance(9);
        if (ap.getVisible()) {
            i = ap.getLineDrawStyle();
            if (i == DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE) {
                i = DefaultConstants.D_AXIS_3D_LINE_STYLE;
            }
            scene.add(new Line3D(vv[i0], vv[ix], i, ap.getLineThickness(), ap.getLineColor()));
        }
        if ((ap = (AxisAppearance)this.component.getChartAppearance(10)).getVisible()) {
            i = ap.getLineDrawStyle();
            if (i == DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE) {
                i = DefaultConstants.D_AXIS_3D_LINE_STYLE;
            }
            scene.add(new Line3D(vv[i0], vv[iy], i, ap.getLineThickness(), ap.getLineColor()));
        }
        if ((ap = (AxisAppearance)this.component.getChartAppearance(11)).getVisible()) {
            i = ap.getLineDrawStyle();
            if (i == DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE) {
                i = DefaultConstants.D_AXIS_3D_LINE_STYLE;
            }
            scene.add(new Line3D(vv[i0], vv[iz], i, ap.getLineThickness(), ap.getLineColor()));
        }
        for (i = 0; i < 6; ++i) {
            this.axs[i].drawEdge(scene);
        }
        scene.add(new Epoch());
    }

    int center(int[][] ids) {
        int x = 0;
        int i = 0;
        int j = 0;
        for (x = 0; x < 4; ++x) {
            for (i = 1; i < 3; ++i) {
                for (j = 0; j < 4 && ids[i][j] != ids[0][x]; ++j) {
                }
                if (j > 3) break;
            }
            if (i != 3) continue;
            return ids[0][x];
        }
        return -1;
    }

    boolean hasIn2(int[][] ids, int id) {
        int x = 0;
        int i = -1;
        block0: while (++i < 3 && x < 2) {
            for (int j = 0; j < 4; ++j) {
                if (ids[i][j] != id) continue;
                ++x;
                continue block0;
            }
        }
        return x > 1;
    }

    int forth(int[][] ids, int i0, int i1, int i2) {
        for (int i = 0; i < 3; ++i) {
            int x = 0;
            int a = -1;
            for (int j = 0; j < 4; ++j) {
                int v = ids[i][j];
                if (v == i0 || v == i1 || v == i2) {
                    ++x;
                    continue;
                }
                a = v;
            }
            if (x <= 2) continue;
            return a;
        }
        return -1;
    }

    void resetAxisLabelFormat() {
        for (int i = 0; i < 3; ++i) {
            AxisAppearance axisApp = this.axs[i].axisApp;
            axisApp.setNoUpdate(true);
            axisApp.getLabels().setItemFormatString(this.axs[i].itemLabelFormat);
            axisApp.setNoUpdate(false);
        }
    }
}

