/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.Axis3D;
import oracle.bpm.chart.core.primitives.Text3D;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.shared.styles.ChartType;

class SetAxis3D
extends Axis3D {
    SetAxis3D(IChartComponent component, ChartCore core, int axisNumber) {
        super(component, core, axisNumber);
        this.itemLabelFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_ITEM;
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        boolean heatMap;
        this.retrieveAppearanceProperties();
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        Vector3D delta = Vector3D.sub(this.endPoint, this.startPoint);
        int totalWidth = (int)delta.length();
        delta.normalize();
        ChartType charType = this.core.getChartType();
        float shiftZ = (float)Axis.setDataItemWidth(rowCount, rowCount, 0, 0, totalWidth) / 2.0f;
        float shiftXY = (float)Axis.setDataItemWidth(colCount, colCount, 0, 0, totalWidth) / 2.0f;
        boolean bl = heatMap = this.axisNumber == 2 && charType.equals(ChartType.HEAT_MAP_CHART_3D);
        if ((this.drawingStyle & 0x40000) != 0 && (this.labels == null || this.labels.length != this.itemCount)) {
            this.labels = new Text3D[this.itemCount];
        }
        for (int i = 0; i < this.itemCount; ++i) {
            int k = this.itemCount;
            if (heatMap || this.axisNumber == 0 && charType != ChartType.COLUMN_CHART_3D) {
                --k;
            }
            k = Axis.setDataItemLinear(k, this.itemCount, totalWidth, i);
            Vector3D p_i = Vector3D.add(this.startPoint, Vector3D.scale(k, delta));
            if (this.axisNumber == 1 && charType == ChartType.BAR_CHART_3D) {
                p_i.y += shiftXY;
            }
            if (this.axisNumber == 0 && charType == ChartType.COLUMN_CHART_3D) {
                p_i.x += shiftXY;
            }
            if (this.axisNumber == 2 && charType != ChartType.HEAT_MAP_CHART_3D) {
                p_i.z += shiftZ;
            }
            this.drawSpan(scene, p_i);
            if ((this.drawingStyle & 0x40000) == 0) continue;
            ChartCore.Environment.put("DATA_VALUE", i);
            ChartCore.Environment.put("ITEM_LABEL", this.strLabels == null ? this.data.getColumnLabel(i) : this.strLabels[i]);
            if (heatMap && (i == 0 || i == this.itemCount - 1)) {
                p_i = new Vector3D(p_i);
                p_i.z = (float)((double)p_i.z + (i == 0 ? (double)shiftZ / 1.8 : (double)(-shiftZ) / 1.8));
            }
            this.addLabel(p_i, i);
        }
        this.drawLabels(scene);
    }
}

