/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import java.util.Vector;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.primitives.Line;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.primitives.Wedge;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.core.util.Platform;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.IChartDataFilter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.PieChartAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class PieLayer
extends ChartLayer {
    public Vector<Point> others;
    Point center = new Point(0, 0);
    int halfW;
    int halfH;
    int radius;
    private LabelStyle labelStyle;
    private LineStyle lineStyle;

    public PieLayer(IChartComponent component, ChartCore chartcore) {
        super(component, chartcore);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(16);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        int y0;
        int iRows;
        super.fillSceneGraph(scene);
        if (this.others != null) {
            this.others.removeAllElements();
        }
        if ((iRows = this.data.getRowCount()) < 1) {
            return;
        }
        PieChartAppearance pieApp = (PieChartAppearance)this.getAppearance();
        int iW = this.outerBounds.getWidth();
        int iH = this.outerBounds.getHeight();
        int pieRow = pieApp.getRowIndex();
        int iR = 1;
        if (pieRow < 0) {
            int iC = 1;
            while (iR * iC < iRows) {
                if (iW >= iH) {
                    ++iR;
                } else {
                    ++iC;
                }
                iW = this.outerBounds.getWidth() / iR;
                iH = this.outerBounds.getHeight() / iC;
            }
        } else {
            iR = 0;
            pieRow = 0;
        }
        int x0 = (int)((View3DAppearance)this.component.getChartAppearance(24)).getScale();
        this.radius = (iW < iH ? iW : iH) * x0 / 125;
        if (this.radius < 5) {
            this.radius = 5;
        }
        if (pieApp.getLabels().getFormat() != 0 && !pieApp.getLabelsOnPie()) {
            x0 = pieApp.getLabels().getFont().getSize() * 2 + 7;
            if (x0 > (y0 = this.radius / 3)) {
                x0 = y0;
            }
            this.radius -= x0;
        }
        if ((this.radius -= 5) < 5) {
            return;
        }
        this.halfW = (iW + 1) / 2;
        this.halfH = (iH + 1) / 2;
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.CHART_LAYER);
        x0 = this.outerBounds.getX() + this.halfW;
        y0 = this.outerBounds.getY() + this.halfH;
        if (pieRow < 0) {
            pieRow = 0;
        }
        while (pieRow < iRows) {
            int x = x0;
            int y = y0;
            if (iR != 0) {
                x += pieRow % iR * iW;
                y += pieRow / iR * iH;
            }
            this.center = new Point(x, y);
            this.drawRow(pieApp, scene, pieRow++);
            if (iR != 0) continue;
            break;
        }
    }

    void drawRow(PieChartAppearance pieApp, SceneGraph scene, int pieRow) {
        Wedge w1;
        double theta_i;
        double dataPercentage;
        int j;
        double val;
        int colCount = this.data.getColumnCount();
        IChartDataFilter filter = null;
        if (this.data instanceof IChartDataFilter) {
            filter = (IChartDataFilter)((Object)this.data);
            pieRow = filter.getFilteredRowNumber(pieRow);
        }
        if (pieRow < 0) {
            pieRow = 0;
        }
        double cumulativeDataTotalOfRow = 0.0;
        for (int c = 0; c < colCount; ++c) {
            val = this.data.getValue(pieRow, c);
            if (val != val) continue;
            cumulativeDataTotalOfRow += Math.abs(val);
        }
        if (cumulativeDataTotalOfRow == 0.0) {
            return;
        }
        String[] colLabels = new String[colCount];
        ChartCore.Environment.put("DATA_ROW", pieRow);
        for (int c = 0; c < colCount; ++c) {
            Object dVal = this.data.getObjectValue(pieRow, c);
            val = ChartDataAdapter.toDouble(dVal);
            if (val != val) continue;
            ChartCore.Environment.put("DATA_COLUMN", c);
            ChartCore.Environment.put("ITEM_LABEL", this.data.getColumnLabel(c));
            ChartCore.Environment.put("DATA_VALUE", dVal);
            ChartCore.Environment.put("PERCENT_VALUE", Math.abs(val) * 100.0 / cumulativeDataTotalOfRow);
            colLabels[c] = LabelFormatter.replaceKeywords(pieApp.getFormatString());
        }
        int iW = pieApp.getBreakDistancePercentage();
        int breakDist = iW * this.radius / 100;
        int breakAlt = pieApp.getBreakAlternatingSlices() ? 1 : 2;
        double startAngleDouble = this.degreeToRadian(pieApp.getStartAngle());
        this.labelStyle = new LabelStyle(pieApp.getLabels().getFont(), pieApp.getLabels().getFontColor(), false, false, false, 0, 0, 0);
        this.lineStyle = new LineStyle();
        this.lineStyle.setDrawStyle(pieApp.getLabels().getLeaderDrawStyle());
        Primitive[] all = new Primitive[colCount * 3];
        iW = 0;
        double othersCumulativeTotal = 0.0;
        for (j = 0; j < colCount; ++j) {
            Object dVal = this.data.getObjectValue(pieRow, j);
            val = ChartDataAdapter.toDouble(dVal);
            if (val != val) continue;
            int realColNumber = filter != null ? filter.getRealColumnNumber(j) : j;
            dataPercentage = Math.abs(val) * 100.0 / cumulativeDataTotalOfRow;
            if (dataPercentage < pieApp.getOthersCategoryPercent()) {
                if (this.others == null) {
                    this.others = new Vector();
                }
                this.others.addElement(new Point(pieRow, j));
                othersCumulativeTotal += Math.abs(val);
                continue;
            }
            theta_i = Axis.dataToAngleLinear(0.0, cumulativeDataTotalOfRow, 0.0, Math.PI * 2, Math.abs(val));
            Point newCenter = this.center;
            if (colCount > 1 && (pieApp.getBreakAllSlices() || breakAlt == (iW & 1) || pieApp.isSliceBroken(pieRow, realColNumber))) {
                newCenter = Axis.angularToCartesian(this.center, breakDist, startAngleDouble + theta_i / 2.0);
            }
            w1 = new Wedge(newCenter, this.radius, this.radianToDegree(startAngleDouble), this.radianToDegree(theta_i), this.colorModel.getFillColor(pieRow, j, val), this.colorModel.getOutlineColor(pieRow, j, val));
            w1.row = pieRow;
            ChartCore.Environment.put("DATA_ROW", w1.row);
            w1.column = j;
            ChartCore.Environment.put("DATA_COLUMN", w1.column);
            all[iW * 3] = w1;
            if (pieApp.getLabels().getFormat() != 0) {
                ChartCore.Environment.put("ITEM_LABEL", this.data.getColumnLabel(j));
                ChartCore.Environment.put("DATA_VALUE", dVal);
                ChartCore.Environment.put("PERCENT_VALUE", dataPercentage);
                this.addTextLabelsToScene(all, iW, colLabels[j], pieApp, newCenter, startAngleDouble + theta_i / 2.0);
            }
            startAngleDouble += theta_i;
            ++iW;
        }
        if (othersCumulativeTotal > 0.0) {
            dataPercentage = othersCumulativeTotal * 100.0 / cumulativeDataTotalOfRow;
            theta_i = Axis.dataToAngleLinear(0.0, cumulativeDataTotalOfRow, 0.0, Math.PI * 2, othersCumulativeTotal);
            Point newCenter = this.center;
            if (pieApp.getBreakAllSlices() || pieApp.getBreakOthersSlice() || breakAlt == (iW & 1)) {
                newCenter = Axis.angularToCartesian(newCenter, breakDist, startAngleDouble + theta_i / 2.0);
            }
            w1 = new Wedge(newCenter, this.radius, this.radianToDegree(startAngleDouble), this.radianToDegree(theta_i), this.colorModel.getFillColor(pieRow, colCount - 1, othersCumulativeTotal), this.colorModel.getOutlineColor(pieRow, colCount - 1, othersCumulativeTotal));
            w1.row = pieRow;
            ChartCore.Environment.put("DATA_ROW", w1.row);
            w1.column = colCount;
            ChartCore.Environment.put("DATA_COLUMN", w1.column);
            all[iW * 3] = w1;
            if (pieApp.getLabels().getFormat() != 0) {
                ChartCore.Environment.put("ITEM_LABEL", "");
                ChartCore.Environment.put("DATA_VALUE", othersCumulativeTotal);
                ChartCore.Environment.put("PERCENT_VALUE", dataPercentage);
                this.addTextLabelsToScene(all, iW, LabelFormatter.replaceKeywords(pieApp.getFormatString()) + " (Other)", pieApp, newCenter, startAngleDouble + theta_i / 2.0);
            }
            startAngleDouble += theta_i;
        }
        for (j = 0; j < colCount; ++j) {
            if (all[j * 3] == null) continue;
            scene.add(all[j * 3]);
        }
        for (j = 0; j < colCount; ++j) {
            if (all[j * 3 + 1] != null) {
                scene.add(all[j * 3 + 1]);
            }
            if (all[j * 3 + 2] == null) continue;
            scene.add(all[j * 3 + 2]);
        }
    }

    double radianToDegree(double theta) {
        double degrees;
        for (degrees = theta * 180.0 / Math.PI; degrees > 360.0; degrees -= 360.0) {
        }
        while (degrees < 0.0) {
            degrees += 360.0;
        }
        return degrees;
    }

    double degreeToRadian(double degree) {
        return degree / 180.0 * Math.PI;
    }

    void addTextLabelsToScene(Primitive[] all, int iW, String labelStr, PieChartAppearance pieApp, Point newCenter, double theta) {
        Point textPt;
        int shift = 0;
        int lineW = -1;
        int centerLen = 0;
        int thick = pieApp.getLabels().getBorderThickness();
        if (!pieApp.getLabelsOnPie()) {
            lineW = pieApp.getLabels().getLeaderLineThickness();
            Dimension strSize = Platform.getSize(labelStr, pieApp.getLabels().getFont());
            shift = (int)Math.abs(Math.sin(theta) * (double)strSize.getHeight()) + (int)Math.abs(Math.cos(theta) * (double)(strSize.getWidth() + 8)) / 2;
            centerLen = shift + 15 + thick;
        }
        int space = shift - thick - 3;
        while (true) {
            textPt = Axis.angularToCartesian(newCenter, lineW < 0 ? (double)(this.radius * 2 / 3) : (double)(this.radius + centerLen), theta);
            if (lineW < 0 || centerLen < 0) break;
            int i = space + (this.center.getX() - this.halfW) - textPt.getX();
            if (i > 1) {
                centerLen -= i / 2;
                continue;
            }
            i = textPt.getX() + space - (this.center.getX() + this.halfW);
            if (i > 1) {
                centerLen -= i / 2;
                continue;
            }
            i = space + (this.center.getY() - this.halfH) - textPt.getY();
            if (i > 1) {
                centerLen -= i / 2;
                continue;
            }
            i = textPt.getY() + space - (this.center.getY() + this.halfH);
            if (i <= 1) break;
            centerLen -= i / 2;
        }
        Text t1 = new Text(new Rectangle(textPt.getX(), textPt.getY(), 0, 0), labelStr, this.labelStyle);
        t1.lineStyle.setDrawStyle(pieApp.getLabels().getBorderDrawStyle());
        t1.drawThickness = thick;
        t1.drawColor = pieApp.getLabels().getBorderColor();
        t1.fillColor = pieApp.getLabels().getFillColor();
        all[iW * 3 + 2] = t1;
        if (pieApp.getLabels().getLeaderLinesVisible() && lineW > 0 && (centerLen -= shift) > -3) {
            Point leaderLineStart = Axis.angularToCartesian(newCenter, this.radius * 2 / 3, theta);
            Point leaderLineEnd = Axis.angularToCartesian(newCenter, this.radius + centerLen, theta);
            Line leaderLine = new Line(leaderLineStart, leaderLineEnd, this.lineStyle);
            leaderLine.drawThickness = lineW;
            leaderLine.drawColor = pieApp.getLabels().getBorderColor();
            if (leaderLine.drawColor == null) {
                leaderLine.drawColor = Color.BLACK;
            }
            all[iW * 3 + 1] = leaderLine;
        }
    }
}

