/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis3D;
import oracle.bpm.chart.core.primitives.Text3D;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartGridAppearance;

class LinearAxis3D
extends Axis3D {
    LinearAxis3D(IChartComponent component, ChartCore core, int axisNumber) {
        super(component, core, axisNumber);
        ChartGridAppearance app = (ChartGridAppearance)component.getChartAppearance(27);
        this.itemLabelFormat = app == null ? DefaultConstants.D_AXIS_LABEL_FORMAT_DATA : app.getDefaultLinearAxisFormat();
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        this.retrieveAppearanceProperties();
        double data_increment = 1.0;
        double incrementFudge = Math.abs(this.dataMax - this.dataMin);
        if ((this.drawingStyle & 2) != 0) {
            double dMin = (double)(this.axisNumber == 0 ? this.outerBounds.getWidth() : this.outerBounds.getHeight()) / 2.0 / (double)(this.labelStyle.getFont().getSize() + 3);
            if (this.core.stackStyle == 1 || (this.drawingStyle & 4) != 0) {
                if (dMin >= 10.0) {
                    dMin = 10.0;
                } else if (dMin <= 1.0) {
                    dMin = 1.0;
                } else if (dMin >= 5.0) {
                    dMin = 5.0;
                } else if (dMin < 4.0) {
                    dMin = 2.0;
                }
                data_increment = this.tickPercentage / 100.0;
                if (data_increment < 1.0 / dMin) {
                    data_increment = 1.0 / dMin;
                }
                data_increment *= incrementFudge;
            } else {
                double d;
                data_increment = this.tickInterval;
                if (dMin > 11.0) {
                    dMin = 11.0;
                }
                if (dMin < 1.0) {
                    dMin = 1.0;
                }
                dMin = incrementFudge / dMin;
                if (data_increment < d) {
                    data_increment = dMin;
                    int iPower = 1;
                    while (data_increment < 1.0) {
                        data_increment *= 10.0;
                        ++iPower;
                    }
                    while (data_increment > 10.0) {
                        data_increment /= 10.0;
                        --iPower;
                    }
                    data_increment = data_increment < 1.1 ? 1.0 : (data_increment < 1.7 ? 1.5 : (data_increment < 2.2 ? 2.0 : (data_increment < 2.8 ? 2.5 : (data_increment < 3.5 ? 3.0 : (data_increment < 4.5 ? 4.0 : (data_increment < 6.0 ? 5.0 : (data_increment < 8.0 ? 8.0 : 10.0)))))));
                    while (iPower != 1) {
                        if (iPower > 1) {
                            --iPower;
                            data_increment /= 10.0;
                            continue;
                        }
                        ++iPower;
                        data_increment *= 10.0;
                    }
                    if (data_increment > incrementFudge) {
                        data_increment = incrementFudge;
                    }
                }
            }
        }
        double value = this.dataMin;
        if (this.dataMin < 0.0f && this.dataMax >= 0.0f) {
            value = (double)(-((int)(-value / data_increment))) * data_increment;
        }
        this.itemCount = (int)(Math.abs(((double)this.dataMax - value) / data_increment) + 0.99);
        if ((this.drawingStyle & 0x40000) != 0 && (this.labels == null || this.labels.length != this.itemCount)) {
            this.labels = new Text3D[this.itemCount];
        }
        incrementFudge = (double)this.dataMax + data_increment / 100.0;
        boolean isEmpty = true;
        for (int i = 0; i < this.itemCount && value <= incrementFudge; value += data_increment, ++i) {
            isEmpty = false;
            Vector3D p_i = Axis3D.axisDataPointLinear3D(this.startPoint, this.endPoint, this.dataMin, this.dataMax, (float)value);
            this.drawSpan(scene, p_i);
            if ((this.drawingStyle & 0x40000) == 0) continue;
            ChartCore.Environment.put("DATA_VALUE", value);
            ChartCore.Environment.put("ITEM_LABEL", i + 1);
            this.addLabel(p_i, i);
        }
        if (isEmpty && (this.drawingStyle & 0x40000) != 0) {
            Vector3D p = Axis3D.axisDataPointLinear3D(this.startPoint, this.endPoint, this.dataMin, this.dataMax, (float)value);
            if (this.labels == null || this.labels.length == 0) {
                this.labels = new Text3D[1];
            }
            this.addLabel(p, 0);
        }
        this.drawLabels(scene);
    }
}

