/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import java.util.Date;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.layers.TimeSpan;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.core.util.Platform;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartGridAppearance;
import oracle.bpm.geom.Point;

class LinearAxis
extends Axis {
    LinearAxis(IChartComponent component, ChartCore core, int axisNum, int type) {
        super(component, core, axisNum, type);
        if (type == 3) {
            this.dateDataColumn = 0;
            this.itemLabelFormat = DefaultConstants.D_CANDLE_CHART_AXIS_LABEL_DATE_FORMAT_ITEM;
        } else {
            ChartGridAppearance app;
            this.itemLabelFormat = type == 0 ? ((app = (ChartGridAppearance)component.getChartAppearance(27)) == null ? DefaultConstants.D_AXIS_LABEL_FORMAT_DATA : app.getDefaultLinearAxisFormat()) : DefaultConstants.D_AXIS_LABEL_FORMAT_ITEM;
        }
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        boolean horiz = (this.drawingStyle & 0x8000) != 0;
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.AXIS);
        if (this.axisType == 3) {
            this.fillDate(scene, horiz);
            return;
        }
        double data_increment = 1.0;
        double incrementFudge = Math.abs(this.dataMax - this.dataMin);
        if ((this.drawingStyle & 2) != 0) {
            double dMin = (double)(this.axisNumber == 0 ? this.innerBounds.getWidth() : this.innerBounds.getHeight()) / (double)(this.labelStyle.getFont().getSize() + 3);
            if (this.axisType == 1) {
                data_increment = incrementFudge / (double)(this.data.getRowCount() - 1);
            } else if (this.axisType == 2) {
                data_increment = incrementFudge / (double)(this.data.getColumnCount() - 1);
            } else if (this.core.stackStyle == 1 || (this.drawingStyle & 4) != 0) {
                if (dMin >= 10.0) {
                    dMin = 10.0;
                } else if (dMin <= 1.0) {
                    dMin = 1.0;
                } else if (dMin >= 5.0) {
                    dMin = 5.0;
                } else if (dMin < 4.0) {
                    dMin = 2.0;
                }
                data_increment = this.tickPercentage / 100.0;
                if (data_increment < 1.0 / dMin) {
                    data_increment = 1.0 / dMin;
                }
                data_increment *= incrementFudge;
            } else {
                double d;
                data_increment = this.tickInterval;
                if (dMin > 11.0) {
                    dMin = 11.0;
                }
                if (dMin < 1.0) {
                    dMin = 1.0;
                }
                dMin = incrementFudge / dMin;
                if (data_increment < d) {
                    data_increment = dMin;
                    int iPower = 1;
                    while (data_increment < 1.0) {
                        data_increment *= 10.0;
                        ++iPower;
                    }
                    while (data_increment > 10.0) {
                        data_increment /= 10.0;
                        --iPower;
                    }
                    data_increment = data_increment < 1.1 ? 1.0 : (data_increment < 1.7 ? 1.5 : (data_increment < 2.2 ? 2.0 : (data_increment < 2.8 ? 2.5 : (data_increment < 3.5 ? 3.0 : (data_increment < 4.5 ? 4.0 : (data_increment < 6.0 ? 5.0 : (data_increment < 8.0 ? 8.0 : 10.0)))))));
                    while (iPower != 1) {
                        if (iPower > 1) {
                            --iPower;
                            data_increment /= 10.0;
                            continue;
                        }
                        ++iPower;
                        data_increment *= 10.0;
                    }
                    if (data_increment > incrementFudge) {
                        data_increment = incrementFudge;
                    }
                }
            }
        }
        double increment_major = this.dataMin;
        if (this.axisType == 0 && this.dataMin < 0.0 && this.dataMax >= 0.0) {
            increment_major = (double)(-((int)(-increment_major / data_increment))) * data_increment;
        }
        double increment_minor = increment_major + data_increment / 2.0;
        incrementFudge = data_increment / 1000.0;
        int itemNum = 0;
        boolean j = false;
        if (horiz) {
            boolean isEmpty = true;
            while (increment_major < this.dataMax + incrementFudge) {
                isEmpty = false;
                Point p_i_min = Axis.dataToPointLinearHorizontal(this.dataMin, this.dataMax, this.startPoint, this.endPoint, increment_minor);
                Point p_i_maj = Axis.dataToPointLinearHorizontal(this.dataMin, this.dataMax, this.startPoint, this.endPoint, increment_major);
                this.addLine(scene, p_i_maj.getX(), p_i_maj.getY(), true, horiz);
                if (increment_minor <= this.dataMax) {
                    this.addLine(scene, p_i_min.getX(), p_i_min.getY(), false, horiz);
                }
                if ((this.drawingStyle & 0x40000) != 0) {
                    int y = p_i_maj.getY() + this.gap;
                    p_i_maj = new Point(p_i_maj.getX(), y);
                    String s = null;
                    if (this.axisType == 1 || this.axisType == 2) {
                        s = this.labels[itemNum];
                    } else {
                        ChartCore.Environment.put("DATA_VALUE", increment_major);
                        ChartCore.Environment.put("ITEM_LABEL", itemNum + 1);
                        s = LabelFormatter.replaceKeywords(this.itemLabelFormat);
                    }
                    scene.add(new Text(p_i_maj, s, this.labelStyle));
                }
                increment_major += data_increment;
                increment_minor += data_increment;
                ++itemNum;
            }
            if (isEmpty) {
                Point p = Axis.dataToPointLinearHorizontal(this.dataMin, this.dataMax, this.startPoint, this.endPoint, increment_major);
                int y = p.getY() + this.gap;
                p = new Point(p.getX(), y);
                scene.add(new Text(p, "0", this.labelStyle));
            }
        } else {
            boolean isEmpty = true;
            while (increment_major < this.dataMax + incrementFudge) {
                isEmpty = false;
                Point p_i_min = Axis.dataToPointLinearVertical(this.dataMin, this.dataMax, this.startPoint, this.endPoint, increment_minor);
                Point p_i_maj = Axis.dataToPointLinearVertical(this.dataMin, this.dataMax, this.startPoint, this.endPoint, increment_major);
                this.addLine(scene, p_i_maj.getX(), p_i_maj.getY(), true, horiz);
                if (increment_minor <= this.dataMax) {
                    this.addLine(scene, p_i_min.getX(), p_i_min.getY(), false, horiz);
                }
                if ((this.drawingStyle & 0x40000) != 0) {
                    int x = p_i_maj.getX() - this.gap;
                    p_i_maj = new Point(x, p_i_maj.getY());
                    String s = null;
                    if (this.axisType == 1 || this.axisType == 2) {
                        s = this.labels[itemNum];
                    } else {
                        ChartCore.Environment.put("DATA_VALUE", increment_major);
                        ChartCore.Environment.put("ITEM_LABEL", itemNum + 1);
                        s = LabelFormatter.replaceKeywords(this.itemLabelFormat);
                    }
                    scene.add(new Text(p_i_maj, s, this.labelStyle));
                }
                increment_major += data_increment;
                increment_minor += data_increment;
                ++itemNum;
            }
            if (isEmpty) {
                Point p = Axis.dataToPointLinearVertical(this.dataMin, this.dataMax, this.startPoint, this.endPoint, increment_major);
                int x = p.getX() - this.gap;
                p = new Point(x, p.getY());
                scene.add(new Text(p, "0", this.labelStyle));
            }
        }
    }

    @Override
    int getExtent() {
        boolean checkVert;
        int ext = this.extent;
        int tick = this.gap;
        tick += 6;
        if (ext >= 0) {
            tick = ext;
        }
        if ((this.drawingStyle & 0x40000) == 0) {
            return tick;
        }
        boolean doWidth = false;
        boolean bl = checkVert = (this.drawingStyle & 0x8000) != 0;
        if (ext < 0) {
            if (checkVert) {
                doWidth = this.labelStyle.getOrientation() != 0;
            } else {
                boolean bl2 = doWidth = this.labelStyle.getOrientation() == 0;
            }
        }
        if (this.labelStyle.getOrientation() == 0) {
            checkVert = false;
        }
        int count = 3;
        ext = 0;
        int rowCount = this.data.getRowCount();
        if (this.axisType == 1) {
            count = this.data.getRowCount();
        } else if (this.axisType == 2) {
            count = this.data.getColumnCount();
        }
        if (this.labels == null || this.labels.length < count) {
            this.labels = new String[count];
        }
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.AXIS);
        while (count-- > 0) {
            int i;
            if (this.axisType == 3) {
                Date d = null;
                if (this.dateDataColumn > -1) {
                    if (count < rowCount) {
                        d = (Date)this.data.getObjectValue(count, this.dateDataColumn);
                    }
                } else if (this.startDate != null) {
                    d = new Date(this.startDate.getTime() + (long)count);
                }
                if (d == null) continue;
                ChartCore.Environment.put("ITEM_LABEL", d);
                ChartCore.Environment.put("DATA_VALUE", d);
            } else if (this.axisType == 1) {
                ChartCore.Environment.put("DATA_VALUE", (double)rowCount - (double)count - 1.0);
                ChartCore.Environment.put("ITEM_LABEL", this.data.getRowLabel(rowCount - count - 1));
            } else if (this.axisType == 2) {
                ChartCore.Environment.put("DATA_VALUE", count);
                ChartCore.Environment.put("ITEM_LABEL", this.data.getColumnLabel(count));
            } else {
                ChartCore.Environment.put("DATA_VALUE", count == 0 ? this.dataMin : (count == 1 ? this.dataMax : (this.dataMax - this.dataMin) / 3.0));
                ChartCore.Environment.put("ITEM_LABEL", 10);
            }
            String str = this.labels[count] = LabelFormatter.replaceKeywords(this.itemLabelFormat);
            if (checkVert && str.length() > 2) {
                checkVert = false;
            }
            if (!doWidth || (i = Platform.getStringSizePixels(this.labels[count], this.labelStyle.getFont()).getWidth()) <= ext) continue;
            ext = i;
        }
        if (this.extent >= 0) {
            return this.extent;
        }
        if (checkVert) {
            this.labelStyle.setOrientation(0);
            this.labelStyle.setVerticalAlign(2);
            this.labelStyle.setHorizontalAlign(0);
        } else if (doWidth) {
            return ext * 9 / 8 + tick;
        }
        return this.labelStyle.getFont().getSize() * 9 / 8 + tick;
    }

    void fillDate(SceneGraph scene, boolean horiz) {
        int rowCount = this.data.getRowCount();
        TimeSpan delta = new TimeSpan(this.dateInterval.ticks);
        if ((this.drawingStyle & 4) > 0) {
            delta = new TimeSpan((long)((double)(this.endDate.getTime() - this.startDate.getTime()) * this.tickPercentage / 100.0));
        }
        if (this.dateSkipN > 0) {
            delta = delta.add(delta.ticks * (long)this.dateSkipN);
        }
        int axisLength = horiz ? this.outerBounds.getWidth() : this.outerBounds.getHeight();
        int boxWidth = (int)Axis.setDataItemWidth(rowCount, 1, 0, 0, axisLength);
        if (this.dateDataColumn > -1) {
            int i = 0;
            while (i < rowCount) {
                int j = Axis.setDataItemLinear(rowCount, 1, axisLength, i) + boxWidth / 2;
                Point p = Axis.dataToPointLinearHorizontal(0.0, axisLength, this.startPoint, this.endPoint, j);
                this.addLine(scene, p.getX(), p.getY(), true, horiz);
                Date d_i = (Date)this.data.getObjectValue(i, this.dateDataColumn);
                if (d_i != null) {
                    p = horiz ? new Point(p.getX(), p.getY() + this.gap) : new Point(p.getX() - this.gap, p.getY());
                    if ((this.drawingStyle & 0x40000) > 0) {
                        ChartCore.Environment.put("ITEM_LABEL", d_i);
                        ChartCore.Environment.put("DATA_VALUE", d_i);
                        scene.add(new Text(p, LabelFormatter.replaceKeywords(this.itemLabelFormat), this.labelStyle));
                    }
                }
                i = i + 1 + this.dateSkipN;
            }
        } else {
            Date d_i = this.startDate;
            while (d_i.compareTo(this.endDate) <= 0) {
                float p_i = Axis.dateDataDateLinear(this.startDate, this.endDate, axisLength, d_i);
                Point p = Axis.dataToPointLinearHorizontal(0.0, axisLength, this.startPoint, this.endPoint, p_i);
                this.addLine(scene, p.getX(), p.getY(), true, horiz);
                p = horiz ? new Point(p.getX(), p.getY() + this.gap) : new Point(p.getX() - this.gap, p.getY());
                if ((this.drawingStyle & 0x40000) > 0) {
                    ChartCore.Environment.put("ITEM_LABEL", d_i);
                    ChartCore.Environment.put("DATA_VALUE", d_i);
                    scene.add(new Text(p, LabelFormatter.replaceKeywords(this.itemLabelFormat), this.labelStyle));
                }
                d_i = new Date(d_i.getTime() + delta.ticks);
            }
        }
    }
}

