/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.primitives.Face;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.LineChartAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;

public class Line3DLayer
extends ChartLayer3D {
    public Line3DLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(15);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        int fix;
        super.fillSceneGraph(scene);
        LineChartAppearance lineApp = (LineChartAppearance)this.getAppearance();
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double dataMin = this.data.getDataMin();
        double dataMax = this.data.getDataMax();
        int cols = colCount - 1;
        if (cols < 1) {
            cols = 1;
        }
        if ((fix = lineApp.getThickness()) < 0) {
            fix = 0;
        }
        float yHeight = (float)((double)(this.volume.y * (float)fix) / 200.0);
        float zWidth = this.volume.z * 0.9f / (float)rowCount;
        float zZero = zWidth / 20.0f;
        int order0 = this.core.order;
        fix = ChartCore.zeroAngle(order0);
        if (fix == 360) {
            fix = 0;
        }
        if (fix == 180) {
            int aX = ((View3DAppearance)this.component.getChartAppearance(24)).getXRotation() + 180;
            int aY = ((View3DAppearance)this.component.getChartAppearance(24)).getYRotation();
            if (aX >= 360) {
                aX -= 360;
            }
            if (aX == 0 || aX == 180) {
                fix = aY > 90 ? -2 : -1;
            } else if (aY == 90 && aX < 180) {
                fix = -3;
            }
        }
        order0 = ChartCore.fixTop(order0);
        for (int ii = 0; ii < rowCount; ++ii) {
            int row = this.core.flipRow ? rowCount - 1 - ii : ii;
            for (int jj = 0; jj < colCount; ++jj) {
                int i0;
                boolean bLeftSide;
                int j;
                int col = j = this.core.flipCol ? colCount - 1 - jj : jj;
                int iNext = colCount == 1 || j + 1 >= colCount ? 0 : 1;
                Object dVal = this.data.getObjectValue(row, col);
                double val = ChartDataAdapter.toDouble(dVal);
                if (val != val) continue;
                double valNext = this.data.getValue(row, col + iNext);
                while (valNext != valNext && col + iNext + 1 < colCount) {
                    valNext = this.data.getValue(row, col + ++iNext);
                }
                boolean bRightSide = iNext == 0;
                boolean bl = bLeftSide = !bRightSide;
                if (j == 0) {
                    bLeftSide = true;
                } else if (this.core.flipCol) {
                    i0 = col;
                    while (i0-- > 0 && Double.isNaN(this.data.getValue(row, i0))) {
                    }
                    if (i0 < 0) {
                        bLeftSide = true;
                    }
                }
                if (j + iNext >= colCount - 1) {
                    bRightSide = true;
                }
                if (valNext != valNext) {
                    iNext = 0;
                    valNext = val;
                }
                IFGOFF result = new IFGOFF();
                result.nverts = 8;
                result.nedges = 12;
                float x1 = (float)Axis.dataToDoubleLinear(0.0, cols, 0.0, this.volume.x, j);
                float y1 = (float)Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, val);
                float z = (float)Axis.dataToDoubleLinear(0.0, rowCount, 0.0, this.volume.z, row) + zZero;
                float x2 = (float)Axis.dataToDoubleLinear(0.0, cols, 0.0, this.volume.x, j + iNext);
                float y2 = (float)Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, valNext);
                result.vert = new float[]{x1, y1 + yHeight, z, x2, y2 + yHeight, z, x1, y1 + yHeight, z + zWidth, x2, y2 + yHeight, z + zWidth, x1, y1 - yHeight, z, x2, y2 - yHeight, z, x1, y1 - yHeight, z + zWidth, x2, y2 - yHeight, z + zWidth};
                int order = order0;
                int bottom = 3;
                boolean swap = false;
                int angle = (int)(Math.atan((y2 - y1) / (x2 - x1)) * 180.0 / Math.PI);
                if (fix < 0) {
                    swap = fix < -2 ? angle > 0 : angle > 0 == (fix == -1);
                } else if (fix < 90) {
                    if (fix - angle < 0) {
                        swap = true;
                    }
                } else if (fix < 180 && fix - angle > 180) {
                    swap = true;
                }
                if (fix > 270) {
                    if (fix - angle > 360) {
                        swap = true;
                    }
                } else if (fix > 180 && fix - angle < 180) {
                    swap = true;
                }
                if (swap) {
                    order = ChartCore.fixTop(ChartCore.swapTop(this.core.order));
                }
                int skip = 4;
                if (bRightSide) {
                    ++skip;
                }
                if (bLeftSide) {
                    ++skip;
                }
                result.face = new Face[skip];
                skip = 0;
                result.fillColor = this.colorModel.getFillColor(row, col, val);
                result.drawColor = this.colorModel.getOutlineColor(row, col, val);
                for (i0 = 0; i0 < 6; ++i0) {
                    boolean noFill = false;
                    int ii0 = order >> (5 - i0) * 4 & 7;
                    if (!bRightSide || !bLeftSide) {
                        if (bLeftSide) {
                            if (ii0 == 5) {
                                ++skip;
                                continue;
                            }
                        } else if (bRightSide) {
                            if (ii0 == 1) {
                                ++skip;
                                continue;
                            }
                        } else if (ii0 == 1 || ii0 == 5) {
                            ++skip;
                            continue;
                        }
                    }
                    if (i0 < 3 && ii0 != 3 && ii0 != bottom) {
                        noFill = true;
                    }
                    int[] ids = null;
                    ids = ii0 == 0 ? new int[]{4, 5, 7, 6} : (ii0 == 1 ? new int[]{0, 4, 6, 2} : (ii0 == 2 ? new int[]{0, 1, 5, 4} : (ii0 == 3 ? new int[]{0, 2, 3, 1} : (ii0 == 4 ? new int[]{2, 6, 7, 3} : new int[]{1, 3, 7, 5}))));
                    result.face[i0 - skip] = new Face(ids, noFill ? -2 : ii0);
                }
                result.column = col;
                result.row = row;
                scene.add(result);
            }
        }
    }
}

