/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import java.util.Locale;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.msg.ChartMsg;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.geom.Rectangle;

public abstract class Layer {
    transient IChartComponent component;
    transient ChartCore core;
    transient IChartData data;
    transient Rectangle innerBounds = new Rectangle();
    transient Rectangle outerBounds = new Rectangle();
    private transient boolean visible = false;
    public static final String AXIS_100 = "<DATA_VALUE:+0>%";
    public static final String LABEL = "LABEL_RENDER_LOCATION";

    public Layer(IChartComponent component, ChartCore core) {
        this.core = core;
        this.component = component;
    }

    public ChartAppearance getAppearance() {
        return null;
    }

    public void fillSceneGraph(SceneGraph scene) {
    }

    public void setBounds(Rectangle bounds) {
        this.outerBounds = bounds;
        this.calculateInnerBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    public Rectangle getOuterBounds() {
        return this.outerBounds;
    }

    public Rectangle getInnerBounds() {
        return this.innerBounds;
    }

    public IChartData getData() {
        return this.data;
    }

    public void setData(IChartData data) {
        this.data = data;
    }

    public String getDataInvalidMessage() {
        return ChartMsg.INSUFFICIENT_DATA.getString(Locale.getDefault());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    void calculateInnerBounds() {
        this.innerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY(), this.outerBounds.getWidth(), this.outerBounds.getHeight());
    }
}

