/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis3D;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.layers.HeatMapLayer;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.HeatMapChartAppearance;
import oracle.bpm.draw.Color;

public class Heatmap3DLayer
extends ChartLayer3D {
    public Heatmap3DLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(19);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        int rowCount0 = this.data.getRowCount();
        int colCount0 = this.data.getColumnCount();
        double dataMin = this.data.getDataMin();
        double dataMax = this.data.getDataMax();
        if (dataMax == dataMin) {
            dataMax += 0.1;
            dataMin -= 0.1;
        }
        HeatMapChartAppearance heatMapApp = (HeatMapChartAppearance)this.getAppearance();
        int rowCount = rowCount0;
        int colCount = colCount0;
        if (rowCount == 1) {
            rowCount = 2;
        }
        if (colCount == 1) {
            colCount = 2;
        }
        boolean hitOne = heatMapApp.getCanSelectDataPointOnly();
        Color clr1 = this.colorModel.getFillColor(0, 0, dataMin);
        Color clr2 = this.colorModel.getFillColor(rowCount - 1, colCount - 1, dataMax);
        Vector3D[][] pp = new Vector3D[rowCount][colCount];
        Color[][] back = new Color[rowCount][colCount];
        Color[][] fore = new Color[rowCount][colCount];
        int lines = heatMapApp.getStyleOfLines();
        int quality = heatMapApp.getRenderQuality();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                int col;
                int row = i < rowCount0 ? i : i - 1;
                Object dVal = this.data.getObjectValue(row, col = j < colCount0 ? j : j - 1);
                double val = ChartDataAdapter.toDouble(dVal);
                if (val != val) {
                    val = HeatMapLayer.lostValue(this.data, row, col, rowCount0, colCount0);
                }
                Vector3D vc = Axis3D.dataTo3DLinearSpace(this.volume, dataMin, dataMax, val, rowCount, colCount, j, i);
                vc.x = (float)((double)vc.x + 0.5);
                vc.y = (float)((double)vc.y + 0.5);
                vc.z = (float)((double)vc.z + 0.5);
                pp[i][j] = vc;
                back[i][j] = MiscFunctions.altitude(clr1, clr2, (val - dataMin) / (dataMax - dataMin));
                fore[i][j] = this.colorModel.getOutlineColor(row, col, val);
            }
        }
        for (int ii = 0; ii < rowCount - 1; ++ii) {
            for (int jj = 1; jj < colCount; ++jj) {
                Color[] colorArray;
                int i = this.core.flipRow ? rowCount - 2 - ii : ii;
                int j = this.core.flipCol ? colCount - jj : jj;
                Color color = back[i][j];
                Color color2 = fore[i][j];
                if (quality < 1) {
                    colorArray = null;
                } else {
                    Color[] colorArray2 = new Color[4];
                    colorArray2[0] = back[i][j];
                    colorArray2[1] = back[i + 1][j];
                    colorArray2[2] = back[i][j - 1];
                    colorArray = colorArray2;
                    colorArray2[3] = back[i + 1][j - 1];
                }
                IFGOFF pr = new IFGOFF(pp, color, color2, colorArray, quality, lines, i, j);
                pr.set1(hitOne);
                scene.add(pr);
            }
        }
    }
}

