/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.HeatMapChartAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Rectangle;

public class HeatMapLayer
extends ChartLayer {
    public HeatMapLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(19);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        int j;
        int i;
        HeatMapChartAppearance heatMapApp = (HeatMapChartAppearance)this.getAppearance();
        int rowCount0 = this.data.getRowCount();
        int colCount0 = this.data.getColumnCount();
        double dataMin = this.data.getDataMin();
        double dataMax = this.data.getDataMax();
        int rowCount = rowCount0;
        int colCount = colCount0;
        if (rowCount == 1) {
            rowCount = 2;
        }
        if (colCount == 1) {
            colCount = 2;
        }
        boolean hitOne = heatMapApp.getCanSelectDataPointOnly();
        Color clr1 = this.colorModel.getFillColor(0, 0, dataMin);
        Color clr2 = this.colorModel.getFillColor(rowCount - 1, colCount - 1, dataMax);
        int[][] xx = new int[rowCount][colCount];
        int[][] yy = new int[rowCount][colCount];
        Box[][] bb = new Box[rowCount][colCount];
        int lines = heatMapApp.getStyleOfLines();
        int quality = heatMapApp.getRenderQuality();
        for (i = 0; i < rowCount; ++i) {
            for (j = 0; j < colCount; ++j) {
                int col;
                xx[i][j] = (int)((double)this.outerBounds.getWidth() / (double)(colCount - 1) * (double)j);
                yy[i][j] = (int)((double)this.outerBounds.getHeight() / (double)(rowCount - 1) * (double)i);
                int row = i < rowCount0 ? i : i - 1;
                Object dVal = this.data.getObjectValue(row, col = j < colCount0 ? j : j - 1);
                double val = ChartDataAdapter.toDouble(dVal);
                if (val != val) {
                    val = HeatMapLayer.lostValue(this.data, row, col, rowCount0, colCount0);
                }
                bb[i][j] = new Box(row, col, dataMin == dataMax ? clr1 : MiscFunctions.altitude(clr1, clr2, (val - dataMin) / (dataMax - dataMin)), this.colorModel.getOutlineColor(row, col, val), quality, lines);
                bb[i][j].set1(hitOne);
            }
        }
        for (i = 0; i < rowCount - 1; ++i) {
            for (j = 0; j < colCount - 1; ++j) {
                bb[i][j].rect = new Rectangle(this.outerBounds.getX() + xx[i][j], this.outerBounds.getY() + yy[i][j], xx[i + 1][j + 1] - xx[i][j], yy[i + 1][j + 1] - yy[i][j]);
                scene.add(bb[i][j]);
                if (quality <= 0) continue;
                bb[i][j].corners = new Color[]{bb[i][j].fillColor, bb[i][j + 1].fillColor, bb[i + 1][j].fillColor, bb[i + 1][j + 1].fillColor};
            }
        }
    }

    static double lostValue(IChartData data, int i, int j, int rows, int cols) {
        int i0 = 0;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        double d0 = Double.NaN;
        double d1 = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        int x0 = -1;
        int x1 = -1;
        int x2 = -1;
        int x3 = -1;
        int y0 = -1;
        int y1 = -1;
        int y2 = -1;
        int y3 = -1;
        for (int delta = 1; delta < rows && delta < cols; ++delta) {
            i2 = -delta;
            if (j + i2 < 0) {
                i2 = -j;
            }
            if (j + (i3 = delta) >= cols && (i3 = cols - j - 1) < 0) {
                i3 = cols - 1;
            }
            if (d2 != d2 && (d2 = data.getValue(i, j + i2)) == d2) {
                x2 = 0;
                y2 = i2;
                if (d3 == d3) break;
            }
            if (d3 != d3 && (d3 = data.getValue(i, j + i3)) == d3) {
                x3 = 0;
                y3 = i3;
                if (d2 == d2) break;
            }
            if (i + (i0 = -delta) < 0) {
                i0 = -i;
            }
            if (i + (i1 = delta) >= rows && (i1 = rows - i - 1) < 0) {
                i1 = rows - 1;
            }
            if (d0 != d0 && (d0 = data.getValue(i + i0, j)) == d0) {
                x0 = i0;
                y0 = 0;
                if (d1 == d1) break;
            }
            if (d1 != d1 && (d1 = data.getValue(i + i1, j)) == d1) {
                x1 = i1;
                y1 = 0;
                if (d0 == d0) break;
            }
            if (d0 != d0) {
                d0 = data.getValue(i + i0, j + i2);
                if (d0 == d0) {
                    x0 = i0;
                    y1 = i2;
                    if (d3 == d3 || d1 == d1) {
                        break;
                    }
                } else {
                    d0 = data.getValue(i + i0, j + i3);
                    if (d0 == d0) {
                        x0 = i0;
                        y0 = i3;
                        if (d2 == d2 || d1 == d1) break;
                    }
                }
            }
            if (d1 != d1) {
                d1 = data.getValue(i + i1, j + i2);
                if (d1 == d1) {
                    x1 = i1;
                    y1 = i2;
                    if (d3 == d3 || d0 == d0) {
                        break;
                    }
                } else {
                    d1 = data.getValue(i + i1, j + i3);
                    if (d1 == d1) {
                        x1 = i1;
                        y1 = i3;
                        if (d2 == d2 || d0 == d0) break;
                    }
                }
            }
            if (d0 == d0 && (d2 == d2 || d3 == d3) || d1 == d1 && (d2 == d2 || d3 == d3)) break;
        }
        i3 = -1;
        i2 = -1;
        i1 = -1;
        i0 = -1;
        if (d0 == d0 && d1 == d1) {
            i0 = x0;
            i1 = y0;
            i2 = x1;
            i3 = y1;
        } else if (d2 == d2 && d3 == d3) {
            i0 = x2;
            i1 = y2;
            i2 = x3;
            i3 = y3;
            d0 = d2;
            d1 = d3;
        } else {
            if (d0 == d0) {
                i0 = x0;
                i1 = y0;
            }
            if (d1 == d1) {
                i2 = x1;
                i3 = y1;
            }
            if (d2 == d2) {
                if (i0 < 0) {
                    i0 = x2;
                    i1 = y2;
                    d0 = d2;
                } else if (i2 < 0) {
                    i2 = x2;
                    i3 = y2;
                    d1 = d2;
                } else {
                    d2 = Double.NaN;
                }
            }
            if (d3 == d3) {
                if (i0 < 0) {
                    i0 = x3;
                    i1 = y3;
                    d0 = d3;
                } else if (i2 < 0) {
                    i2 = x3;
                    i3 = y3;
                    d1 = d3;
                } else {
                    d3 = Double.NaN;
                }
            }
        }
        if (i0 < 0 || i2 < 0) {
            if (d0 == d0) {
                return d0;
            }
            if (d1 == d1) {
                return d1;
            }
            if (d2 == d2) {
                return d2;
            }
            if (d3 == d3) {
                return d3;
            }
            return 0.0;
        }
        if (i1 > 0 && i3 < 0 || i1 < 0 && i3 > 0) {
            if (i1 < 0) {
                i1 = -i1;
            }
            if (i3 < 0) {
                i3 = -i3;
            }
            return d0 + (d1 - d0) * (double)i1 / (double)(i1 + i3);
        }
        if (i0 > 0 && i2 < 0 || i0 < 0 && i2 > 0) {
            if (i0 < 0) {
                i0 = -i0;
            }
            if (i2 < 0) {
                i2 = -i2;
            }
            return d0 + (d1 - d0) * (double)i0 / (double)(i0 + i2);
        }
        return (d0 + d1) / 2.0;
    }
}

