/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ColumnChartAppearance;
import oracle.bpm.geom.Point;

public class ColumnLayer
extends ChartLayer {
    public ColumnLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(13);
    }

    @Override
    public String getDataInvalidMessage() {
        if (((ColumnChartAppearance)this.component.getChartAppearance(13)).getStack()) {
            return "Stacked BasicChartComponent Error: data should be either all positive or negative";
        }
        return super.getDataInvalidMessage();
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        int itemSpace;
        super.fillSceneGraph(scene);
        ColumnChartAppearance columnApp = (ColumnChartAppearance)this.getAppearance();
        if (columnApp.getStack()) {
            this.fillSceneGraphStacked(scene);
            return;
        }
        int seriaSpace = columnApp.getSeriesSpacing();
        if (seriaSpace < 0) {
            seriaSpace = 0;
        }
        if (seriaSpace > 100) {
            seriaSpace = 100;
        }
        if ((itemSpace = columnApp.getColumnSpacing()) < 0) {
            itemSpace = 0;
        }
        if (itemSpace > 100) {
            itemSpace = 100;
        }
        if (itemSpace > seriaSpace) {
            seriaSpace = itemSpace;
        }
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double dataMin = this.core.dataMin;
        double dataMax = this.core.dataMax;
        double zero = 0.0;
        if (dataMax < 0.0) {
            zero = dataMax;
        } else if (dataMin > 0.0) {
            zero = dataMin;
        }
        Point zeroLine = Axis.dataToPointLinearVertical(dataMin, dataMax, new Point(this.outerBounds.getX(), this.outerBounds.getY() + this.outerBounds.getHeight()), new Point(this.outerBounds.getX(), this.outerBounds.getY()), zero);
        int item_i = 0;
        int barWidth = Axis.itemPoint(colCount * rowCount, colCount, seriaSpace, itemSpace, this.outerBounds.getWidth(), -1);
        int barShift = Axis.itemPoint(colCount * rowCount, colCount, seriaSpace, itemSpace, this.outerBounds.getWidth(), -3);
        for (int i = 0; i < rowCount; ++i) {
            int j = 0;
            while (j < colCount) {
                Object dVal = this.data.getObjectValue(i, j);
                double val = ChartDataAdapter.toDouble(dVal);
                item_i = i * colCount + j;
                Point point2 = Axis.dataToPointLinearVertical(dataMin, dataMax, new Point(this.outerBounds.getX(), this.outerBounds.getY() + this.outerBounds.getHeight()), new Point(this.outerBounds.getX(), this.outerBounds.getY()), val);
                int x = barShift + this.outerBounds.getX() + Axis.itemPoint(colCount * rowCount, colCount, seriaSpace, itemSpace, this.outerBounds.getWidth(), item_i);
                point2 = new Point(x, point2.getY());
                Box b1 = null;
                b1 = val > 0.0 ? new Box(point2, barWidth, zeroLine.getY() - point2.getY()) : new Box(new Point(point2.getX(), zeroLine.getY()), barWidth, point2.getY() - zeroLine.getY());
                b1.drawColor = this.colorModel.getOutlineColor(i, j, val);
                b1.fillColor = this.colorModel.getFillColor(i, j, val);
                b1.row = i;
                b1.column = j++;
                b1.hitMe = true;
                b1.orientation = 1;
                scene.add(b1);
            }
        }
    }

    public void fillSceneGraphStacked(SceneGraph scene) {
        boolean negative;
        ColumnChartAppearance columnApp = (ColumnChartAppearance)this.getAppearance();
        int stackStyle = columnApp.getStackStyle();
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double oldval = 0.0;
        double dataMin = this.core.dataMin;
        double dataMax = this.core.dataMax;
        int seriaSpace = columnApp.getSeriesSpacing();
        if (seriaSpace < 0) {
            seriaSpace = 0;
        }
        if (seriaSpace > 100) {
            seriaSpace = 100;
        }
        double zero = 0.0;
        if (dataMax < 0.0) {
            zero = dataMax;
        } else if (dataMin > 0.0) {
            zero = dataMin;
        }
        Point zeroLine = Axis.dataToPointLinearVertical(dataMin, dataMax, new Point(this.outerBounds.getX(), this.outerBounds.getY() + this.outerBounds.getHeight()), new Point(this.outerBounds.getX(), this.outerBounds.getY()), zero);
        int barWidth = Axis.itemPoint(rowCount, 1, seriaSpace, 0, this.outerBounds.getWidth(), -1);
        boolean bl = negative = dataMax <= 0.0;
        if (stackStyle == 1) {
            if (negative) {
                dataMax = 0.0;
            } else {
                dataMin = 0.0;
            }
        }
        for (int i = 0; i < rowCount; ++i) {
            double val;
            double factor = 1.0;
            if (stackStyle == 1) {
                val = ChartCore.getStackedRowValue(this.data, i, colCount);
                if (val == 0.0) continue;
                factor = negative ? dataMin / val : dataMax / val;
            }
            oldval = 0.0;
            val = 0.0;
            for (int j = 0; j < colCount; ++j) {
                oldval = val;
                double v = this.data.getValue(i, j);
                if (v != v || v == 0.0 || (val += v) < dataMin || val > dataMax) continue;
                if (oldval < dataMin) {
                    oldval = dataMin;
                }
                if (oldval > dataMax) {
                    oldval = dataMax;
                }
                Point point2 = Axis.dataToPointLinearVertical(dataMin, dataMax, new Point(this.outerBounds.getX(), this.outerBounds.getY() + this.outerBounds.getHeight()), new Point(this.outerBounds.getX(), this.outerBounds.getY()), val * factor);
                Point point3 = Axis.dataToPointLinearVertical(dataMin, dataMax, new Point(this.outerBounds.getX(), this.outerBounds.getY() + this.outerBounds.getHeight()), new Point(this.outerBounds.getX(), this.outerBounds.getY()), oldval * factor);
                int x = this.outerBounds.getX() + Axis.itemPoint(rowCount, 1, seriaSpace, 0, this.outerBounds.getWidth(), i);
                point2 = new Point(x, point2.getY());
                Box b1 = null;
                b1 = val > 0.0 ? new Box(point2, barWidth, point3.getY() - point2.getY()) : new Box(new Point(point2.getX(), point3.getY()), barWidth, point2.getY() - point3.getY());
                b1.drawColor = this.colorModel.getOutlineColor(i, j, val);
                b1.fillColor = this.colorModel.getFillColor(i, j, val);
                b1.row = i;
                b1.column = j;
                b1.hitMe = true;
                b1.orientation = 1;
                scene.add(b1);
            }
        }
    }

    @Override
    void validateDataForChart() {
        super.validateDataForChart();
        ColumnChartAppearance type = (ColumnChartAppearance)this.component.getChartAppearance(13);
        if (type.getStack() && (this.data == null || this.data.getDataMin() < 0.0 && this.data.getDataMax() > 0.0)) {
            this.dataIsValid = false;
        }
    }
}

