/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.Line;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.CandleChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.DataAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;

public class CandleLayer
extends ChartLayer {
    public CandleLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(25);
    }

    @Override
    public String getDataInvalidMessage() {
        return "Candle Chart should have at least 1 row and 5 columns, 1 date type and 4 numeric columns";
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        int rowCount = this.data.getRowCount();
        CandleChartAppearance cdApp = (CandleChartAppearance)this.getAppearance();
        double ochl_min = Math.min(Math.min(this.data.getDataMinColumn(1), this.data.getDataMinColumn(2)), Math.min(this.data.getDataMinColumn(3), this.data.getDataMinColumn(4)));
        double ochl_max = Math.max(Math.max(this.data.getDataMaxColumn(1), this.data.getDataMaxColumn(2)), Math.max(this.data.getDataMaxColumn(3), this.data.getDataMaxColumn(4)));
        int boxWidth = (int)Axis.setDataItemWidth(rowCount, 1, 0, 0, this.outerBounds.getWidth() - 2);
        int shift = (boxWidth + 3) / 4;
        double dataVolMin = this.data.getDataMinColumn(5);
        double dataVolMax = this.data.getDataMaxColumn(5);
        for (int i = 0; i < rowCount; ++i) {
            Color clr;
            Box b1;
            double open = this.data.getValue(i, 1);
            double close = this.data.getValue(i, 4);
            int X = Axis.setDataItemLinear(rowCount, 1, this.outerBounds.getWidth(), i) + boxWidth / 4;
            Point p1 = new Point(this.outerBounds.getX() + X, this.outerBounds.getY() + this.outerBounds.getHeight());
            Point p2 = new Point(this.outerBounds.getX() + X, this.outerBounds.getY());
            Point openPoint = Axis.dataToPointLinearVertical(ochl_min, ochl_max, p1, p2, open);
            Point closePoint = Axis.dataToPointLinearVertical(ochl_min, ochl_max, p1, p2, close);
            if (close > open) {
                b1 = new Box(closePoint, boxWidth / 2, Math.abs(closePoint.getY() - openPoint.getY()));
                clr = cdApp.getPositiveRangeColor();
            } else {
                b1 = new Box(openPoint, boxWidth / 2, Math.abs(closePoint.getY() - openPoint.getY()));
                clr = cdApp.getNegativeRangeColor();
            }
            if (clr != null) {
                b1.fillColor = Color.valueOf(clr.getRed(), clr.getGreen(), clr.getBlue(), this.colorModel.getAlpha());
            }
            b1.drawColor = this.colorModel.getOutlineColor(0, 0, 0.0);
            b1.hitMe = true;
            b1.row = i;
            b1.column = 1;
            if (cdApp.getVolumeVisible()) {
                double vol = this.data.getValue(i, 5);
                Point volPoint = Axis.dataToPointLinearVertical(dataVolMin, dataVolMax, p1, p2, vol);
                Box volBox = new Box(volPoint, boxWidth / 2, this.outerBounds.getY() + this.outerBounds.getHeight() - volPoint.getY() - 1);
                volBox.drawColor = this.colorModel.getOutlineColor(0, 0, 0.0);
                clr = cdApp.getVolumeColor();
                if (clr != null) {
                    volBox.fillColor = Color.valueOf(clr.getRed(), clr.getGreen(), clr.getBlue(), this.colorModel.getAlpha());
                }
                volBox.hitMe = true;
                volBox.row = i;
                volBox.column = 1;
                scene.add(volBox);
            }
            String format = "0.00";
            if (cdApp.getHighLowVisible()) {
                p1 = new Point(p1.getX() + shift, p1.getY());
                p2 = new Point(p2.getX() + shift, p2.getY());
                double high = this.data.getValue(i, 2);
                double low = this.data.getValue(i, 3);
                Point highPoint = Axis.dataToPointLinearVertical(ochl_min, ochl_max, p1, p2, high);
                Point lowPoint = Axis.dataToPointLinearVertical(ochl_min, ochl_max, p1, p2, low);
                Line line = new Line(highPoint, lowPoint);
                clr = cdApp.getWickColor();
                if (clr != null) {
                    line.drawColor = Color.valueOf(clr.getRed(), clr.getGreen(), clr.getBlue(), this.colorModel.getAlpha());
                }
                line.drawThickness = cdApp.getWickThickness();
                line.hitMe = true;
                line.row = i;
                line.column = 1;
                scene.add(line);
            }
            if (!cdApp.getOpenCloseVisible()) continue;
            scene.add(b1);
        }
    }

    @Override
    void validateDataForChart() {
        super.validateDataForChart();
        this.dataIsValid = this.data != null && this.data.getColumnCount() > 4 && this.data.getRowCount() > 0 && this.data.isColumnDateTime(0) && this.data.isColumnNumeric(1) && this.data.isColumnNumeric(2) && this.data.isColumnNumeric(3) && this.data.isColumnNumeric(4) && !((DataAppearance)this.component.getChartAppearance(8)).getSwapRowsAndColumns();
    }
}

