/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.Ellipse;
import oracle.bpm.chart.core.primitives.Polygon;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.IChartDataFilter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.BubbleChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class BubbleLayer
extends ChartLayer {
    public BubbleLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(17);
    }

    @Override
    public String getDataInvalidMessage() {
        return "Bubble Chart should include one row and three numeric columns";
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        BubbleChartAppearance bubbleApp = (BubbleChartAppearance)this.getAppearance();
        int colX = bubbleApp.getColumnX();
        int colY = bubbleApp.getColumnY();
        int colZ = bubbleApp.getColumnZ();
        if (this.data instanceof IChartDataFilter) {
            IChartDataFilter filter = (IChartDataFilter)((Object)this.data);
            colX = filter.getFilteredColumnNumber(bubbleApp.getColumnX());
            colY = filter.getFilteredColumnNumber(bubbleApp.getColumnY());
            colZ = filter.getFilteredColumnNumber(bubbleApp.getColumnZ());
            if (colX == -1 || colY == -1 || colZ == -1) {
                colX = 0;
                colY = 1;
                colZ = 2;
            }
        }
        double X_min = this.data.getDataMinColumn(colX);
        double X_max = this.data.getDataMaxColumn(colX);
        double Y_min = this.data.getDataMinColumn(colY);
        double Y_max = this.data.getDataMaxColumn(colY);
        double radiusRange = Math.abs(this.data.getDataMaxColumn(colZ) - this.data.getDataMinColumn(colZ));
        int minVisibleRadius = 3;
        double radiusMin = this.data.getDataMinColumn(colZ);
        Point topLeft = this.outerBounds.getOrigin();
        Point bottomRight = new Point(this.outerBounds.getX() + this.outerBounds.getWidth(), this.outerBounds.getY() + this.outerBounds.getHeight());
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        PrimitiveShape bubble = new PrimitiveShape();
        double bubbleFactor = this.getOuterBounds().getWidth() < this.getOuterBounds().getHeight() ? 0.2 * (double)this.getOuterBounds().getWidth() : 0.2 * (double)this.getOuterBounds().getHeight();
        double colorCueDataMax = 1.0;
        double colorCueDataMin = 0.0;
        Color stColor = null;
        Color edColor = null;
        if (bubbleApp.getColorCueColumn() >= 0) {
            colorCueDataMax = this.data.getDataMaxColumn(bubbleApp.getColorCueColumn());
            colorCueDataMin = this.data.getDataMinColumn(bubbleApp.getColorCueColumn());
            stColor = ((ColorAppearance)this.component.getChartAppearance(6)).getColorBegin();
            edColor = ((ColorAppearance)this.component.getChartAppearance(6)).getColorEnd();
        }
        int row = 0;
        while (row < rowCount) {
            Object dValX = this.data.getObjectValue(row, colX);
            if (dValX instanceof Number) {
                double d = ((Number)dValX).doubleValue();
            }
            double valX = ChartDataAdapter.toDouble(dValX);
            Object dValY = this.data.getObjectValue(row, colY);
            double valY = ChartDataAdapter.toDouble(dValY);
            Object dValZ = this.data.getObjectValue(row, colZ);
            double valZ = ChartDataAdapter.toDouble(dValZ);
            Point point = Axis.dataToPointLinearPlane(X_min, X_max, Y_min, Y_max, topLeft, bottomRight, valX, valY);
            int radius = (int)((valZ - radiusMin) / radiusRange * bubbleFactor + 0.5);
            if (radius < minVisibleRadius) {
                radius = minVisibleRadius;
            }
            switch (bubbleApp.getBubbleShape()) {
                case 1: {
                    bubble = new Ellipse(point, radius);
                    break;
                }
                case 2: {
                    bubble = new Box(new Rectangle(point.getX() - radius, point.getY() - radius, radius * 2, radius * 2));
                    break;
                }
                default: {
                    radius += 1 + radius / 5;
                    int cos = (int)((double)radius * Math.cos(0.5235987755982988) + 0.5);
                    int sin = (int)((double)radius * Math.sin(0.5235987755982988) + 0.5);
                    Point[] pts = new Point[]{new Point(point.getX(), point.getY() - radius), new Point(point.getX() + cos, point.getY() + sin), new Point(point.getX() - cos, point.getY() + sin)};
                    if (bubbleApp.getBubbleShape() == 3) {
                        pts[0] = new Point(pts[0].getX(), pts[0].getY() + radius + radius);
                        pts[1] = new Point(pts[1].getX(), pts[1].getY() - sin - sin);
                        pts[2] = new Point(pts[2].getX(), pts[2].getY() - sin - sin);
                    }
                    bubble = new Polygon(pts);
                }
            }
            bubble.fillColor = bubbleApp.getColorCueColumn() >= 0 ? Axis.data2ColorLinear(stColor, edColor, colorCueDataMax, colorCueDataMin, this.data.getValue(row, bubbleApp.getColorCueColumn()), this.colorModel.getAlpha()) : this.colorModel.getFillColor(row, colZ, valX);
            bubble.drawColor = this.colorModel.getOutlineColor(row, colZ, valX);
            bubble.row = row++;
            bubble.column = colZ;
            bubble.hitMe = true;
            scene.add(bubble);
        }
    }

    @Override
    void validateDataForChart() {
        this.dataIsValid = false;
        if (this.data == null || this.data.getRowCount() < 1) {
            return;
        }
        int numericColumnCounter = 0;
        int i = this.data.getColumnCount();
        while (i-- > 0) {
            if (!this.data.isColumnNumeric(i) || ++numericColumnCounter < 3) continue;
            this.dataIsValid = true;
            break;
        }
    }
}

