/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.colormodel;

import oracle.bpm.chart.core.colormodel.IColorModel;
import oracle.bpm.chart.data.ChartDataFilter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.draw.Color;

public class SimpleColorModel
implements IColorModel {
    public transient boolean colorByRow = true;
    transient int alphaValue = DefaultConstants.D_COLOR_ALPHA;
    transient int colCount = 0;
    transient Color colorEnd = DefaultConstants.D_COLOR_END;
    transient int colorScaling = DefaultConstants.D_COLOR_SCALE;
    transient Color colorStart = DefaultConstants.D_COLOR_START;
    transient IChartData data;
    transient int depth = 2;
    transient boolean grayModel = false;
    transient Color line = Color.BLACK;
    transient int[] randomScale;
    transient int rowCount = 0;
    transient boolean swapRowCol = false;
    private transient Color[][] clrs;

    public SimpleColorModel(ColorAppearance app) {
        if (app == null) {
            return;
        }
        this.colorStart = app.getColorBegin();
        this.colorEnd = app.getColorEnd();
        if (this.colorEnd == null) {
            this.colorEnd = this.colorStart;
        }
        this.alphaValue = app.getAlphaLevel();
        if (!app.getOutline()) {
            this.line = null;
        } else {
            this.line = app.getOutlineColor();
            if (this.line != null) {
                this.line = Color.valueOf(this.line.getRed(), this.line.getGreen(), this.line.getBlue(), this.getAlpha());
            }
        }
        this.colorScaling = app.getScaling();
        this.grayModel = app.getGrayscale();
        if (this.colorScaling == 4 || app.getModelStyle() == 5) {
            this.randomScale = app.getRandomScales();
        }
        this.colorByRow = app.getColorByRow();
        this.depth = 1 + app.getScalingDepth();
    }

    @Override
    public Color getOutlineColor(int row, int column, double dataValue) {
        return this.line;
    }

    @Override
    public Color getFillColor(int row, int column, double dataValue) {
        return null;
    }

    @Override
    public void setData(IChartData data) {
        this.data = data;
        this.rowCount = data == null ? 0 : data.getRowCount();
        this.colCount = data == null ? 0 : data.getColumnCount();
        this.swapRowCol = false;
        if (data instanceof ChartDataFilter && (this.swapRowCol = ((ChartDataFilter)data).getSwapRowsAndColumns())) {
            int i = this.rowCount;
            this.rowCount = this.colCount;
            this.colCount = i;
        }
        this.clrs = null;
        this.initializeColors();
    }

    @Override
    public IChartData getData() {
        return this.data;
    }

    @Override
    public int getAlpha() {
        return this.alphaValue;
    }

    void initializeColors() {
        this.clrs = null;
    }

    boolean getGrayscale() {
        return this.grayModel;
    }

    Color getColor(int row, int col) {
        if (this.clrs == null || this.clrs.length <= row || this.clrs[0].length <= col) {
            this.clrs = new Color[this.rowCount > row ? this.rowCount : row + 1][this.colCount > col ? this.colCount : col + 1];
        }
        return this.clrs[row][col];
    }

    Color setColor(Color c, int row, int col) {
        Color color = c;
        this.clrs[row][col] = color;
        return color;
    }

    Color scaleColor(Color c, int id, int iCount) {
        return this.scaleColor(c.getRed(), c.getGreen(), c.getBlue(), id, iCount);
    }

    Color scaleColor(int r, int g, int b, int id, int iCount) {
        int scale = this.colorScaling;
        if (scale != 0) {
            if (scale == 4 && this.randomScale != null) {
                iCount = this.randomScale.length;
                id = this.randomScale[id % iCount];
                scale = 1;
                if (id < 0) {
                    ++scale;
                    id = -id;
                }
            }
            if (scale == 2 || scale == 3 && id % 2 == 1) {
                double p = 0.12 * (double)this.depth * (double)id / (double)iCount;
                r -= (int)((double)r * p);
                g -= (int)((double)g * p);
                b -= (int)((double)b * p);
            } else {
                double p = 0.14 * (double)this.depth * (double)id / (double)iCount * (2.5 - (double)id / (double)iCount);
                r += (int)((double)(255 - r) * p);
                g += (int)((double)(255 - g) * p);
                b += (int)((double)(255 - b) * p);
            }
        }
        if (this.grayModel) {
            g = b = (r + g + g + b) / 4;
            r = b;
        }
        return Color.valueOf(r, g, b, this.getAlpha());
    }
}

