/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core;

import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.colormodel.CustomColorModel;
import oracle.bpm.chart.core.colormodel.IColorModel;
import oracle.bpm.chart.core.colormodel.LinearColorModel;
import oracle.bpm.chart.core.colormodel.RandomColorModel;
import oracle.bpm.chart.core.colormodel.SimpleColorModel;
import oracle.bpm.chart.core.layers.Area3DLayer;
import oracle.bpm.chart.core.layers.AreaLayer;
import oracle.bpm.chart.core.layers.Bar3DLayer;
import oracle.bpm.chart.core.layers.BarLayer;
import oracle.bpm.chart.core.layers.BorderLayer;
import oracle.bpm.chart.core.layers.BubbleLayer;
import oracle.bpm.chart.core.layers.CandleLayer;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.layers.Column3DLayer;
import oracle.bpm.chart.core.layers.ColumnLayer;
import oracle.bpm.chart.core.layers.HeatMapLayer;
import oracle.bpm.chart.core.layers.Heatmap3DLayer;
import oracle.bpm.chart.core.layers.LegendLayer;
import oracle.bpm.chart.core.layers.Line3DLayer;
import oracle.bpm.chart.core.layers.LineLayer;
import oracle.bpm.chart.core.layers.Pie3DLayer;
import oracle.bpm.chart.core.layers.PieLayer;
import oracle.bpm.chart.core.layers.ScatterLayer;
import oracle.bpm.chart.core.layers.ThreeDGridLayer;
import oracle.bpm.chart.core.layers.TitleLayer;
import oracle.bpm.chart.core.layers.TwoDGridLayer;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.ChartDataFilter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.data.IChartDataFilter;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.BarChartAppearance;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.resources.appearance.ColumnChartAppearance;
import oracle.bpm.chart.resources.appearance.DataAppearance;
import oracle.bpm.chart.resources.appearance.LegendAppearance;
import oracle.bpm.chart.resources.appearance.PieChartAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.chart.shared.events.ChartDataEventArgs;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class ChartCore {
    public transient IChartComponent component;
    public transient int componentHeight;
    public transient int componentWidth;
    public transient String DataBindNotCalledMessage = "No Data. Please use BasicChartComponent.getData().setDataSource(data)";
    public transient double dataMin;
    public transient double dataMax;
    public transient boolean flipRow;
    public transient boolean flipCol;
    public transient boolean is3D = false;
    public transient boolean opaque = true;
    public transient int order;
    public transient int stackStyle = -1;
    transient int demoData = 518;
    private transient BorderLayer borderLayer;
    private transient ChartLayer chartLayer;
    private transient ChartType chartType;
    private transient IColorModel colorModel;
    private transient int customColors = 0;
    private transient IChartData data;
    private transient boolean dirty = true;
    private transient TwoDGridLayer gridLayer;
    private transient Hashtable<String, Object> labelHash;
    private transient LegendLayer legendLayer;
    private transient SceneGraph sceneGraph;
    private transient ThreeDGridLayer threeDGridLayer;
    private transient TitleLayer titleLayer;
    public static transient Hashtable<String, Object> Environment = new Hashtable();
    public static final int OPAQUE_MASK = 8;
    public static final int CENTER_MASK = 128;
    public static final int BAR_MASK = 2048;
    private static final int ONE_ONE = 4116;
    private static final int ONE_TWO = 65537;
    private static final int ONE_THREE = 65795;
    private static final int ONE_FOUR = -2147479274;
    private static final int TWO_ONE = 74565;
    private static final int TWO_TWO = 69653;
    private static final int TWO_THREE = 69911;
    private static final int TWO_FOUR = -2147483390;
    private static final int THREE_ONE = -2147418111;
    private static final int THREE_TWO = -2147479532;
    private static final int THREE_THREE = -2147479274;
    private static final int THREE_FOUR = 65795;
    private static final int FOUR_ONE = -2147413995;
    private static final int FOUR_TWO = Integer.MIN_VALUE;
    private static final int FOUR_THREE = -2147483390;
    private static final int FOUR_FOUR = 69911;
    private static final int TOP_FAR = 1;
    private static final int TOP_MASK = -15732481;
    private static final int TOP_SWAP = 0x300000;
    private static final int LEFT_FAR = 2;
    private static final int LEFT_MASK = -983056;
    private static final int LEFT_SWAP = 327681;
    private static final int RIGHT_FAR = 4;
    private static final int RIGHT_MASK = -61681;
    private static final int RIGHT_SWAP = 16416;
    private static final int BAR_SHIFT = 8;
    private static final int ROW_MASK = 16;
    private static final int COLUMN_MASK = 256;
    private static final int SWAP_ANGLE_MASK = Integer.MIN_VALUE;
    private static final int SWAP_ANGLE = 32768;
    private static final int ZERO_ANGLE = 23;
    private static final int ZERO_ANGLE_SIZE = 511;

    public ChartCore(IChartComponent component) {
        this.component = component;
        Environment.clear();
        DateFormat f = DateFormat.getDateInstance(1);
        Date d = new Date();
        Environment.put("TODAY_DATE", f.format(d));
        Environment.put("TODAY_DATETIME", d);
        this.sceneGraph = new SceneGraph();
        this.borderLayer = new BorderLayer(this.component, this);
        this.titleLayer = new TitleLayer(this.component, this);
        this.gridLayer = new TwoDGridLayer(this.component, this);
        this.threeDGridLayer = new ThreeDGridLayer(this.component, this);
    }

    public static double getStackedRowValue(IChartData data, int row, int colCount) {
        double val = 0.0;
        while (colCount-- > 0) {
            val += data.getValue(row, colCount);
        }
        return val;
    }

    public static int fixTop(int i) {
        return (i & 0x700000) == 0x300000 ? i & 0xFF8F8FFF | 0x3000 | i << 8 & 0x700000 : i;
    }

    public static int fixBot(int i) {
        return (i & 0x700000) == 0 ? i & 0xFF8F8FFF | i << 8 & 0x700000 : i;
    }

    public static int swapTop(int i) {
        return i & 0xFF8FF8FF | i << 12 & 0x700000 | i >> 12 & 0x700;
    }

    public static int zeroAngle(int i) {
        return i >> 23 & 0x1FF;
    }

    public static boolean swapPie(int i) {
        return (i & 0x70) != 64;
    }

    public static boolean swapAngle(int i) {
        return (i & 0x8000) != 0;
    }

    public Hashtable<String, Object> getLabelHash() {
        return this.labelHash;
    }

    public void setLabelHash(Hashtable<String, Object> value) {
        this.labelHash = value;
        if (this.labelHash == null) {
            return;
        }
        for (String key : value.keySet()) {
            if (key == null) continue;
            Environment.put(key, value.get(key));
        }
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType value) {
        this.chartType = value;
        boolean clrDirty = this.isPieClr();
        this.is3D = false;
        this.chartLayer = null;
        if (this.legendLayer == null) {
            this.legendLayer = new LegendLayer(this.component, this);
        }
        boolean gridLayerVisible = true;
        switch (value) {
            case AREA_CHART: {
                this.chartLayer = new AreaLayer(this.component, this);
                break;
            }
            case STACK_BAR_CHART: 
            case BAR_CHART: {
                this.chartLayer = new BarLayer(this.component, this);
                break;
            }
            case STACK_COLUMN_CHART: 
            case COLUMN_CHART: {
                this.chartLayer = new ColumnLayer(this.component, this);
                break;
            }
            case HEAT_MAP_CHART: {
                this.chartLayer = new HeatMapLayer(this.component, this);
                break;
            }
            case BUBBLE_CHART: {
                this.chartLayer = new BubbleLayer(this.component, this);
                break;
            }
            case SCATTER_CHART: {
                this.chartLayer = new ScatterLayer(this.component, this);
                break;
            }
            case STACK_BAR_CHART_3D: 
            case BAR_CHART_3D: {
                this.chartLayer = new Bar3DLayer(this.component, this);
                this.is3D = true;
                break;
            }
            case STACK_COLUMN_CHART_3D: 
            case COLUMN_CHART_3D: {
                this.chartLayer = new Column3DLayer(this.component, this);
                this.is3D = true;
                break;
            }
            case HEAT_MAP_CHART_3D: {
                this.chartLayer = new Heatmap3DLayer(this.component, this);
                this.is3D = true;
                break;
            }
            case LINE_CHART_3D: {
                this.chartLayer = new Line3DLayer(this.component, this);
                this.is3D = true;
                break;
            }
            case PIE_CHART_3D: {
                this.chartLayer = new Pie3DLayer(this.component, this);
                this.is3D = true;
                clrDirty = !clrDirty;
                gridLayerVisible = false;
                break;
            }
            case PIE_CHART: {
                this.chartLayer = new PieLayer(this.component, this);
                clrDirty = !clrDirty;
                gridLayerVisible = false;
                break;
            }
            case AREA_CHART_3D: {
                this.chartLayer = new Area3DLayer(this.component, this);
                this.is3D = true;
                break;
            }
            case CANDLE_CHART: {
                this.chartLayer = new CandleLayer(this.component, this);
                break;
            }
            default: {
                this.chartType = ChartType.LINE_CHART;
                this.chartLayer = new LineLayer(this.component, this);
            }
        }
        if (clrDirty) {
            this.component.getChartAppearance(6).setDirty(true);
        }
        this.stackStyle = this.stack(value);
        if (this.chartLayer == null) {
            this.chartLayer = new ColumnLayer(this.component, this);
        }
        if (this.is3D) {
            this.threeDGridLayer.setChartType(value);
            this.threeDGridLayer.setVisible(gridLayerVisible);
        } else {
            this.gridLayer.setChartType(value);
            this.gridLayer.setVisible(gridLayerVisible);
        }
        if (this.colorModel != null) {
            this.chartLayer.setColorModel(this.colorModel);
            this.legendLayer.setColorModel(this.colorModel);
        }
        this.legendLayer.setChart(this.chartLayer);
        this.chartLayer.setData(this.data);
        this.setSize(this.componentWidth, this.componentHeight);
    }

    public void setColorModel(IColorModel model) {
        this.colorModel = model;
        this.customColors = model == null ? 0 : 1;
        this.setupColorModel();
    }

    public IChartData getCurrentDataRef() {
        return this.getData();
    }

    public SceneGraph getSceneGraph() {
        return this.sceneGraph;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public ChartLayer getChartLayer() {
        if (this.chartLayer == null) {
            this.chartLayer = new ColumnLayer(this.component, this);
        }
        return this.chartLayer;
    }

    public TitleLayer getTitleLayer() {
        return this.titleLayer;
    }

    public BorderLayer getBorderLayer() {
        return this.borderLayer;
    }

    public TwoDGridLayer getGridLayer() {
        return this.gridLayer;
    }

    public ThreeDGridLayer getGrid3DLayer() {
        return this.threeDGridLayer;
    }

    public boolean setSize(int width, int height) {
        if (this.componentWidth == width && this.componentHeight == height) {
            return false;
        }
        this.componentWidth = width;
        this.componentHeight = height;
        this.resizeAllLayers();
        return true;
    }

    public void resizeAllLayers() {
        if (this.chartLayer == null || this.legendLayer == null) {
            this.setChartType(this.chartType);
        }
        this.borderLayer.setBounds(0, 0, this.componentWidth, this.componentHeight);
        Rectangle bounds = this.borderLayer.getInnerBounds();
        this.titleLayer.setBounds(bounds);
        bounds = this.titleLayer.getInnerBounds();
        if (this.legendLayer.isVisible()) {
            this.legendLayer.setBounds(bounds);
            bounds = this.legendLayer.getInnerBounds();
        }
        if (this.is3D) {
            if (this.threeDGridLayer.isVisible()) {
                this.threeDGridLayer.setBounds(bounds);
                bounds = this.threeDGridLayer.getInnerBounds();
            }
        } else if (this.gridLayer.isVisible()) {
            this.gridLayer.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth() - 10, bounds.getHeight() - 3);
            bounds = this.gridLayer.getInnerBounds();
        }
        this.chartLayer.setBounds(bounds);
    }

    public void drawChart() {
        if (!this.dirty) {
            return;
        }
        int stack = -1;
        if (this.chartType.equals(ChartType.STACK_BAR_CHART_3D) || this.chartType.equals(ChartType.BAR_CHART_3D) || this.chartType.equals(ChartType.STACK_BAR_CHART) || this.chartType.equals(ChartType.BAR_CHART)) {
            BarChartAppearance ba = (BarChartAppearance)this.component.getChartAppearance(12);
            if (this.chartType.equals(ChartType.STACK_BAR_CHART) || this.chartType.equals(ChartType.STACK_BAR_CHART_3D)) {
                stack = ba.getStackStyle();
            }
            ba.setStack(stack >= 0);
        } else if (this.chartType.equals(ChartType.STACK_COLUMN_CHART_3D) || this.chartType.equals(ChartType.COLUMN_CHART_3D) || this.chartType.equals(ChartType.STACK_COLUMN_CHART) || this.chartType.equals(ChartType.COLUMN_CHART)) {
            ColumnChartAppearance ca = (ColumnChartAppearance)this.component.getChartAppearance(13);
            if (this.chartType.equals(ChartType.STACK_COLUMN_CHART) || this.chartType.equals(ChartType.STACK_COLUMN_CHART_3D)) {
                stack = ca.getStackStyle();
            }
            ca.setStack(stack >= 0);
        }
        if (stack != this.stackStyle) {
            this.stackStyle = stack;
            if (this.is3D) {
                this.threeDGridLayer.setChartType(this.chartType);
            } else {
                this.gridLayer.setChartType(this.chartType);
            }
        }
        this.resizeAllLayers();
        this.dirty = false;
        this.setupDataModel();
        if (this.getData() == null) {
            return;
        }
        this.setMinMax();
        this.init0();
        this.setupColorModel();
        this.sceneGraph.clear();
        this.titleLayer.fillSceneGraph(this.sceneGraph);
        if (!this.chartLayer.isDataValidForChart()) {
            this.drawInvalidChartImage(this.titleLayer.getInnerBounds(), this.chartLayer.getDataInvalidMessage());
        } else if (this.chartLayer.getOuterBounds().getWidth() > 1 && this.chartLayer.getOuterBounds().getHeight() > 1) {
            boolean topAxis;
            boolean bl = topAxis = this.chartType.equals(ChartType.COLUMN_CHART) || this.chartType.equals(ChartType.BAR_CHART) || this.chartType.equals(ChartType.STACK_COLUMN_CHART) || this.chartType.equals(ChartType.STACK_BAR_CHART) || this.chartType.equals(ChartType.HEAT_MAP_CHART);
            if (this.is3D) {
                this.threeDGridLayer.fillSceneGraph(this.sceneGraph);
            } else {
                this.gridLayer.fillSceneGraph(this.sceneGraph);
                if (!topAxis) {
                    this.gridLayer.fillSceneGraph2(this.sceneGraph);
                }
            }
            this.updateChartLayerBounds();
            this.chartLayer.fillSceneGraph(this.sceneGraph);
            if (!this.is3D && topAxis) {
                this.gridLayer.fillSceneGraph2(this.sceneGraph);
            }
            if (((LegendAppearance)this.legendLayer.getAppearance()).getVisible()) {
                this.legendLayer.fillSceneGraph(this.sceneGraph);
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.titleLayer.titlePanels[i].fillSceneGraph(this.sceneGraph);
        }
        this.borderLayer.fillSceneGraph(this.sceneGraph);
    }

    public ChartDataEventArgs[] getEventArgs(Primitive prim) {
        return this.getEventArgs(prim, -1);
    }

    public ChartDataEventArgs[] getEventArgs(Primitive prim, int hit1) {
        ChartDataEventArgs[] chartDataEventArgsArray;
        int i;
        boolean bMap;
        if (this.chartLayer == null || this.getData() == null || prim == null || prim.row == -1 && prim.column == -1) {
            return null;
        }
        IChartDataFilter filter = this.getData() instanceof IChartDataFilter ? (IChartDataFilter)((Object)this.getData()) : null;
        int iRow = prim.row;
        int iCol = prim.column;
        boolean bl = bMap = this.chartType.equals(ChartType.HEAT_MAP_CHART) || this.chartType.equals(ChartType.HEAT_MAP_CHART_3D);
        if (hit1 < 0 && !prim.drawAll()) {
            hit1 = prim.fullHit();
        }
        if (bMap && hit1 > 0) {
            if ((hit1 &= 7) > 4) {
                return null;
            }
            bMap = false;
            if ((hit1 & 1) == 0) {
                ++iCol;
            }
            if (hit1 > 2) {
                ++iRow;
            }
        }
        int cols = 0;
        int realRow = iRow;
        int realCol = iCol;
        int realCol2 = iCol + 1;
        ChartDataEventArgs a0 = null;
        if (prim.column >= this.getData().getColumnCount()) {
            Vector<Point> others = null;
            if (this.chartLayer instanceof PieLayer) {
                others = ((PieLayer)this.chartLayer).others;
            } else if (this.chartLayer instanceof Pie3DLayer) {
                others = ((Pie3DLayer)this.chartLayer).others;
            }
            int n = i = others == null ? 0 : others.size();
            if (i > 0) {
                if (filter != null) {
                    realRow = filter.getRealRowNumber(realRow);
                }
                Vector<ChartDataEventArgs> temp = new Vector<ChartDataEventArgs>(i);
                while (i-- > 0) {
                    Point pr = others.elementAt(i);
                    if (pr.getX() != iRow) continue;
                    ++cols;
                    realCol = pr.getY();
                    if (filter != null) {
                        realCol = filter.getRealColumnNumber(realCol);
                    }
                    temp.addElement(new ChartDataEventArgs(realRow, realCol, this.getData().getObjectValue(pr.getX(), pr.getY()), this.getData().getRowLabel(pr.getX()), this.getData().getColumnLabel(pr.getY())));
                }
                if (cols < 1) {
                    return null;
                }
                ChartDataEventArgs[] args = new ChartDataEventArgs[cols];
                while (cols-- > 0) {
                    args[cols] = (ChartDataEventArgs)temp.elementAt(cols);
                }
                return args;
            }
            a0 = new ChartDataEventArgs(realRow, realCol, null, "", "");
        } else if (filter != null) {
            realRow = filter.getRealRowNumber(iRow);
            realCol = filter.getRealColumnNumber(iCol);
        }
        if (a0 == null) {
            a0 = new ChartDataEventArgs(realRow, realCol, this.getData().getObjectValue(iRow, iCol), this.getData().getRowLabel(iRow), this.getData().getColumnLabel(iCol));
        }
        boolean bTwo = hit1 <= 0 && (this.chartType.equals(ChartType.AREA_CHART) || this.chartType.equals(ChartType.AREA_CHART_3D) || this.chartType.equals(ChartType.LINE_CHART) || this.chartType.equals(ChartType.LINE_CHART_3D));
        cols = this.getData().getColumnCount();
        ChartDataEventArgs a1 = null;
        if ((bTwo || bMap) && realCol2 < cols) {
            if (!bMap) {
                while (realCol2 < cols && Double.isNaN(this.getData().getValue(iRow, realCol2))) {
                    ++realCol2;
                }
            }
            if (realCol2 < cols) {
                i = realCol2;
                if (filter != null) {
                    realCol2 = filter.getRealColumnNumber(realCol2);
                }
                a1 = new ChartDataEventArgs(realRow, realCol2, this.getData().getObjectValue(iRow, i), this.getData().getRowLabel(iRow), this.getData().getColumnLabel(i));
            }
        }
        if (bMap && iRow + 1 < this.getData().getRowCount()) {
            if (filter != null) {
                realRow = filter.getRealRowNumber(iRow + 1);
            }
            ChartDataEventArgs a2 = new ChartDataEventArgs(realRow, realCol, this.getData().getObjectValue(iRow + 1, iCol), this.getData().getRowLabel(iRow + 1), this.getData().getColumnLabel(iCol));
            if (a1 == null) {
                return new ChartDataEventArgs[]{a0, a2};
            }
            return new ChartDataEventArgs[]{a0, a1, a2, new ChartDataEventArgs(realRow, realCol2, this.getData().getObjectValue(iRow + 1, iCol + 1), this.getData().getRowLabel(iRow + 1), this.getData().getColumnLabel(iCol + 1))};
        }
        if (a1 == null) {
            ChartDataEventArgs[] chartDataEventArgsArray2 = new ChartDataEventArgs[1];
            chartDataEventArgsArray = chartDataEventArgsArray2;
            chartDataEventArgsArray2[0] = a0;
        } else {
            ChartDataEventArgs[] chartDataEventArgsArray3 = new ChartDataEventArgs[2];
            chartDataEventArgsArray3[0] = a0;
            chartDataEventArgsArray = chartDataEventArgsArray3;
            chartDataEventArgsArray3[1] = a1;
        }
        return chartDataEventArgsArray;
    }

    public ChartDataEventArgs getChartInfoFromPrimitive(Primitive prim) {
        if (this.chartLayer == null || this.getData() == null || prim == null || prim.row == -1 && prim.column == -1) {
            return null;
        }
        int realRow = prim.row;
        int realCol = prim.column;
        if (this.getData() instanceof IChartDataFilter) {
            IChartDataFilter filter = (IChartDataFilter)((Object)this.getData());
            realRow = filter.getRealRowNumber(realRow);
            realCol = filter.getRealColumnNumber(realCol);
        }
        Object dataValue = null;
        String colName = "";
        String rowName = this.getData().getRowLabel(prim.row);
        if (prim.column >= this.getData().getColumnCount()) {
            int i;
            Vector<Point> others = null;
            if (this.chartLayer instanceof PieLayer) {
                others = ((PieLayer)this.chartLayer).others;
            } else if (this.chartLayer instanceof Pie3DLayer) {
                others = ((Pie3DLayer)this.chartLayer).others;
            }
            int n = i = others == null ? 0 : others.size();
            if (i > 0) {
                double val = 0.0;
                while (i-- > 0 && others != null) {
                    Point pr = others.elementAt(i);
                    if (pr.getX() != prim.row) continue;
                    double v = this.getData().getValue(pr.getX(), pr.getY());
                    val += v >= 0.0 ? v : -v;
                }
                dataValue = val;
                colName = "Others";
            }
        } else {
            dataValue = this.getData().getObjectValue(prim.row, prim.column);
            colName = this.getData().getColumnLabel(prim.column);
        }
        return new ChartDataEventArgs(realRow, realCol, dataValue, rowName, colName);
    }

    public Primitive getChartPrimitiveFromPoint(Point point) {
        return this.sceneGraph.getPrimitiveFromPoint(point);
    }

    public Primitive getChartPrimitiveFromRowColumn(int row, int column) {
        return this.sceneGraph.getPrimitiveFromRowColumn(row, column);
    }

    public IChartData getData() {
        return this.data;
    }

    public void setData(IChartData data) {
        this.data = data;
    }

    void setDataIntoLayers() {
        if (this.chartLayer == null || this.legendLayer == null) {
            return;
        }
        this.chartLayer.setData(this.getData());
        this.legendLayer.setData(this.getData());
        if (this.colorModel != null) {
            this.colorModel.setData(this.getData());
        }
        this.gridLayer.setData(this.getData());
        this.threeDGridLayer.setData(this.getData());
    }

    int stack(ChartType type) {
        if (type.equals(ChartType.STACK_BAR_CHART_3D) || type.equals(ChartType.STACK_BAR_CHART)) {
            return ((BarChartAppearance)this.component.getChartAppearance(12)).getStackStyle();
        }
        if (type.equals(ChartType.STACK_COLUMN_CHART_3D) || type.equals(ChartType.STACK_COLUMN_CHART)) {
            return ((ColumnChartAppearance)this.component.getChartAppearance(13)).getStackStyle();
        }
        return -1;
    }

    void setMinMax() {
        IChartData iChartData = this.getData();
        if (iChartData == null) {
            return;
        }
        this.dataMin = iChartData.getDataMin();
        this.dataMax = iChartData.getDataMax();
        if (this.stackStyle < 0) {
            return;
        }
        int rowCount = iChartData.getRowCount();
        int colCount = iChartData.getColumnCount();
        this.dataMin = Double.MAX_VALUE;
        this.dataMax = -1.7976931348623157E308;
        for (int i = 0; i < rowCount; ++i) {
            double val = 0.0;
            for (int j = 0; j < colCount; ++j) {
                val += iChartData.getValue(i, j);
            }
            if (val < this.dataMin) {
                this.dataMin = val;
            }
            if (!(val > this.dataMax)) continue;
            this.dataMax = val;
        }
        if (this.dataMin == Double.MAX_VALUE) {
            this.dataMin = 0.0;
        }
        if (this.dataMax == -1.7976931348623157E308) {
            this.dataMax = 0.0;
        }
        if (this.stackStyle == 0 && ((ChartDataFilter)iChartData).getZeroAlignment()) {
            if (this.dataMax > 0.0) {
                this.dataMin = 0.0;
            } else {
                this.dataMax = 0.0;
            }
        }
    }

    boolean isPieClr() {
        return (this.chartType.equals(ChartType.PIE_CHART_3D) || this.chartType.equals(ChartType.PIE_CHART)) && ((PieChartAppearance)this.component.getChartAppearance(16)).getColorBySlice();
    }

    void drawInvalidChartImage(Rectangle bounds, String message) {
        LabelStyle textStyle = new LabelStyle();
        textStyle.setFont(DefaultConstants.D_CHART_ERROR_FONT);
        textStyle.setFontColor(Color.RED);
        textStyle.setWrapText(true);
        this.sceneGraph.add(new Text(bounds, message, textStyle));
    }

    private void updateChartLayerBounds() {
        Rectangle bounds = this.titleLayer.getInnerBounds();
        if (this.legendLayer.isVisible()) {
            bounds = this.legendLayer.getInnerBounds();
        }
        if (this.is3D) {
            if (this.threeDGridLayer.isVisible()) {
                bounds = this.threeDGridLayer.getInnerBounds();
            }
        } else if (this.gridLayer.isVisible()) {
            bounds = this.gridLayer.getInnerBounds();
        }
        this.chartLayer.setBounds(bounds);
    }

    private void init0() {
        this.flipCol = false;
        this.flipRow = false;
        this.order = 74565;
        if (!this.is3D) {
            return;
        }
        int aX = ((View3DAppearance)this.component.getChartAppearance(24)).getXRotation() + 180;
        int aY = ((View3DAppearance)this.component.getChartAppearance(24)).getYRotation();
        if (aX >= 360) {
            aX -= 360;
        }
        int i = 0;
        if (aX < 90) {
            i = aY <= 90 ? 4116 : (aY <= 180 ? 65537 : (aY <= 270 ? 65795 : -2147479274));
        } else if (aX <= 180) {
            if (aY > 90) {
                i = aY <= 180 ? 69653 : (aY <= 270 ? 69911 : -2147483390);
            }
        } else {
            i = aX <= 270 ? (aY < 90 ? -2147418111 : (aY <= 180 ? -2147479532 : (aY <= 270 ? -2147479274 : 65795))) : (aY < 90 ? -2147413995 : (aY <= 180 ? Integer.MIN_VALUE : (aY <= 270 ? -2147483390 : 69911)));
        }
        if ((i & 1) != 0) {
            this.order = this.order & 0xFF0FF0FF | 0x300000;
        }
        if ((i & 2) != 0) {
            this.order = this.order & 0xFFF0FFF0 | 0x50001;
        }
        if ((i & 4) != 0) {
            this.order = this.order & 0xFFFF0F0F | 0x4020;
        }
        if (this.chartType.equals(ChartType.BAR_CHART_3D) || this.chartType.equals(ChartType.STACK_COLUMN_CHART_3D)) {
            i >>= 8;
            this.order |= 0x800;
        } else if (this.chartType.equals(ChartType.PIE_CHART_3D) || this.chartType.equals(ChartType.LINE_CHART_3D)) {
            int fix = (int)(Math.abs(Math.atan(Math.tan((double)aY * Math.PI / 180.0) / Math.sin((double)aX * Math.PI / 180.0))) * 180.0 / Math.PI);
            if (aY <= 90) {
                fix = 270 + (aX > 180 ? fix : -fix);
            } else if (aY > 270) {
                fix = 90 + (aX > 180 ? -fix : fix);
            } else {
                if (aY < 180) {
                    fix = -fix;
                }
                fix = 90 + (aX > 180 ? fix : -fix);
            }
            if ((i & Integer.MIN_VALUE) != 0) {
                this.order |= 0x8000;
            }
            this.order |= fix << 23;
            if (this.chartType.equals(ChartType.PIE_CHART_3D)) {
                this.order |= 0x80;
            }
        }
        if (((ColorAppearance)this.component.getChartAppearance(6)).getAlphaLevel() == 255) {
            this.order |= 8;
        }
        this.flipRow = (i & 0x10) != 0;
        this.flipCol = (i & 0x100) != 0;
    }

    private void setupDataModel() {
        DataAppearance dataApp = (DataAppearance)this.component.getChartAppearance(8);
        if (!dataApp.isDirty()) {
            return;
        }
        if (this.isPieClr()) {
            this.component.getChartAppearance(6).setDirty(true);
        }
        if (dataApp.getDataSource() == null) {
            dataApp.setDataBindCalled(false);
        } else {
            IChartData adapter = ChartDataAdapter.createAdapter(dataApp.getDataSource());
            ChartDataFilter filter = new ChartDataFilter(adapter);
            filter.minValue = dataApp.getMinValue();
            filter.maxValue = dataApp.getMaxValue();
            filter.setZeroAlignment(dataApp.getZeroAligned());
            filter.setSwapRowsAndColumns(dataApp.getSwapRowsAndColumns());
            filter.setUseRowLabels(dataApp.getUseRowLabelsColumn());
            filter.setRowLabelsColumn(dataApp.getRowLabelsColumn());
            filter.setRowLabels(dataApp.getRowLabels());
            filter.setColumnLabels(dataApp.getColumnLabels());
            this.setData(filter);
            dataApp.initializeAppearance(this.getData());
        }
        dataApp.setDirty(false);
        this.setDataIntoLayers();
    }

    private void setupColorModel() {
        ColorAppearance colorApp = (ColorAppearance)this.component.getChartAppearance(6);
        if (!colorApp.isDirty() && this.colorModel != null && this.customColors != 1) {
            return;
        }
        colorApp.setDirty(false);
        if (this.customColors != 0) {
            this.customColors = 2;
        } else {
            switch (colorApp.getModelStyle()) {
                case 1: 
                case 2: {
                    this.colorModel = new RandomColorModel(colorApp);
                    break;
                }
                case 3: {
                    this.colorModel = new SimpleColorModel(colorApp);
                    break;
                }
                case 4: 
                case 5: {
                    this.colorModel = new CustomColorModel(colorApp);
                    break;
                }
                default: {
                    this.colorModel = new LinearColorModel(colorApp);
                }
            }
        }
        if (this.chartLayer == null) {
            this.setChartType(ChartType.COLUMN_CHART);
        }
        if (this.colorModel == null) {
            this.colorModel = new LinearColorModel(colorApp);
        }
        if (this.isPieClr() && this.colorModel instanceof SimpleColorModel) {
            ((SimpleColorModel)this.colorModel).colorByRow = ((DataAppearance)this.component.getChartAppearance(8)).getSwapRowsAndColumns();
        }
        this.colorModel.setData(this.getData());
        this.chartLayer.setColorModel(this.colorModel);
        this.legendLayer.setColorModel(this.colorModel);
    }
}

