/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart;

import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.colormodel.IColorModel;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.render.ChartRender;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AreaChartAppearance;
import oracle.bpm.chart.resources.appearance.BackgroundAppearance;
import oracle.bpm.chart.resources.appearance.BarChartAppearance;
import oracle.bpm.chart.resources.appearance.BorderAppearance;
import oracle.bpm.chart.resources.appearance.BubbleChartAppearance;
import oracle.bpm.chart.resources.appearance.CandleChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartGridAppearance;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.resources.appearance.ColumnChartAppearance;
import oracle.bpm.chart.resources.appearance.DataAppearance;
import oracle.bpm.chart.resources.appearance.HeatMapChartAppearance;
import oracle.bpm.chart.resources.appearance.LegendAppearance;
import oracle.bpm.chart.resources.appearance.LineChartAppearance;
import oracle.bpm.chart.resources.appearance.PieChartAppearance;
import oracle.bpm.chart.resources.appearance.ScatterChartAppearance;
import oracle.bpm.chart.resources.appearance.TitleAppearance;
import oracle.bpm.chart.resources.appearance.TooltipAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.chart.shared.events.ChartDataEventArgs;
import oracle.bpm.chart.shared.events.UltraChartEvent;
import oracle.bpm.chart.shared.events.UltraChartEventListener;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.event.SizeEvent;
import oracle.bpm.ui.event.SizeListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.TableModel;

public class BasicChartComponent
extends PaintCanvas
implements IChartComponent,
Serializable {
    public transient int view3D = 0;
    AreaChartAppearance areaAppearance;
    BackgroundAppearance backgroundAppearance;
    BarChartAppearance barAppearance;
    BorderAppearance borderAppearance;
    BubbleChartAppearance bubbleAppearance;
    CandleChartAppearance candleAppearance;
    transient ChartCore chartCore;
    ChartType chartType = ChartType.COLUMN_CHART;
    ColorAppearance colorAppearance;
    ColumnChartAppearance columnAppearance;
    boolean crosshair = false;
    Color crossHairColor = Color.BLACK;
    transient int crosX = -1;
    transient int crosY = -1;
    DataAppearance dataAppearance;
    int demoData = 518;
    transient int dragging = 0;
    ChartGridAppearance gridAppearance;
    HeatMapChartAppearance heatMapAppearance;
    Hashtable<String, Object> labelHash;
    LegendAppearance legendAppearance;
    LineChartAppearance lineAppearance;
    transient Vector<UltraChartEventListener> m_lsnr;
    transient boolean mouseIn = false;
    transient Primitive oldHit;
    transient Primitive oldClick;
    transient int oldSymbol = -1;
    PieChartAppearance pieAppearance;
    boolean prefSize = false;
    transient int prevx;
    transient int prevy;
    transient ChartRender renderCS;
    int rotationStyle = 2;
    transient float scale;
    int scaleStyle = 3;
    ScatterChartAppearance scatterAppearance;
    transient PrimitiveShape selected = new PrimitiveShape();
    transient boolean selOnly = false;
    transient Point tipPoint = new Point(0, 0);
    transient Primitive tipPrim;
    transient Text tipText = new Text(new Rectangle(), null, null);
    TitleAppearance titleBottom;
    TitleAppearance titleLeft;
    TitleAppearance titleRight;
    TitleAppearance titleTop;
    TooltipAppearance tooltipAppearance;
    View3DAppearance view3dAppearance;
    transient int xtheta;
    transient int ytheta;
    static final long serialCheck = 4592412136979441492L;
    static final long serialVersionUID = -7508378007066465671L;
    private static final int MOUSE_DRAGGED = 0;
    private static final int MOUSE_MOVED = 1;
    private static final int MOUSE_CLICKED = 2;
    private static final int MOUSE_ENTERED = 3;
    private static final int MOUSE_EXITED = 4;
    private static final int MOUSE_PRESSED = 5;
    private static final int MOUSE_RELEASED = 6;
    public static final int NONE = 0;
    public static final int DRAG = 1;
    public static final int DRAG_SHIFT = 2;
    public static final int DRAG_CTRL = 3;
    public static final int DRAG_ALT = 4;

    public BasicChartComponent(UiContainer parent) {
        super(parent);
        this.setName("ultraChart");
        this.setOpaque(false);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                BasicChartComponent.this.processMouseMotionEvent(e, 0);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                BasicChartComponent.this.processMouseMotionEvent(e, 1);
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BasicChartComponent.this.processMouseEvent(e, 2);
            }

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BasicChartComponent.this.processMouseEvent(e, 3);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BasicChartComponent.this.processMouseEvent(e, 4);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BasicChartComponent.this.processMouseEvent(e, 5);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BasicChartComponent.this.processMouseEvent(e, 6);
            }
        });
        if (Ui.isSwt()) {
            this.getParent().addSizeListener(new SizeListener(){

                @Override
                public void componentResized(SizeEvent event) {
                    BasicChartComponent.this.repaint();
                }
            });
        }
    }

    public static void main(String[] args) {
        UiType type = UiType.SWING;
        if (args.length > 0 && "SWT".equals(args[0].trim().toUpperCase())) {
            type = UiType.SWT;
        }
        Ui.initialize(type);
        Frame f = new Frame("Fuego BasicChartComponent Test", false);
        Panel panel = new Panel(f.getContentPane());
        panel.setLayout(new BorderLayout());
        final BasicChartComponent c = new BasicChartComponent(panel);
        panel.add(c, "Center");
        ChartType DEFAULT_TYPE = ChartType.BAR_CHART_3D;
        c.setChartType(DEFAULT_TYPE);
        final TableModel demoData = DemoTable.table(5);
        c.getData().setDataSource(demoData);
        c.setVisible(true);
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                int defaultType = c.getChartType().ordinal() + 1;
                if (defaultType == ChartType.values().length) {
                    defaultType = 0;
                }
                c.setChartType(ChartType.values()[defaultType]);
                c.getData().setDataSource(demoData);
            }
        });
        f.getContentPane().add(panel);
        f.pack();
        f.setSize(500, 500);
        f.centerOnScreen();
        f.setVisible(true);
        f.setDefaultCloseOperation(2);
    }

    @Override
    public void paintCanvas(Graphics g) {
        this.paintCanvas(g, this.getSize());
    }

    public void paintCanvas(Graphics g, Dimension dimension) {
        int h;
        if (this.getCore().getChartType() != this.chartType) {
            this.getCore().setChartType(this.chartType);
        }
        boolean topSel = this.getTooltips().getHighlightOnTop() && this.getTooltips().getHighlightDataPoint();
        this.chartCore.opaque = true;
        Margin ins = this.getInsets();
        int w = dimension.getWidth() - ins.left - ins.right;
        if (this.chartCore.setSize(w, h = dimension.getHeight() - ins.top - ins.bottom)) {
            this.chartCore.setDirty(true);
        }
        this.chartCore.drawChart();
        g.translate(ins.left, ins.top);
        Primitive selPrim = this.oldHit;
        if (selPrim != null && selPrim.selected == null) {
            selPrim = null;
        }
        this.getRender().renderChart(g, this.chartCore.getSceneGraph(), w, h, topSel, this.selOnly, selPrim, this.selected);
        if (this.dragging == 0 && this.oldHit != null) {
            ChartRender.renderTip(g, this.getTip(w, h));
        }
        if (this.crosX > 0) {
            g.setForeground(this.crossHairColor);
            Rectangle r = this.chartCore.getGridLayer().getInnerBounds();
            g.drawLine(this.crosX, r.getY(), this.crosX, r.getY() + r.getHeight());
            g.drawLine(r.getX(), this.crosY, r.getX() + r.getWidth(), this.crosY);
        }
        g.translate(-ins.left, -ins.top);
    }

    public Object getDataSource() {
        return this.getData().getDataSource();
    }

    public void setDataSource(Object data) {
        this.getData().setDataSource(data);
    }

    @Override
    public Dimension getPreferredSize() {
        return DefaultConstants.D_CHART_SIZE;
    }

    @Override
    public Dimension getSize() {
        int width = super.getSize().getWidth();
        int height = super.getSize().getHeight();
        if (height <= DefaultConstants.D_CHART_SIZE.getHeight()) {
            height = DefaultConstants.D_CHART_SIZE.getHeight();
        }
        if (width <= DefaultConstants.D_CHART_SIZE.getWidth()) {
            width = DefaultConstants.D_CHART_SIZE.getWidth();
        }
        return Dimension.valueOf(width, height);
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.prefSize = d == null;
        super.setPreferredSize(d);
    }

    public int getDemoDataSize() {
        return this.demoData;
    }

    public Hashtable<String, Object> getLabelHash() {
        return this.labelHash;
    }

    public void setLabelHash(Hashtable<String, Object> value) {
        this.labelHash = value;
        this.getCore().setLabelHash(this.labelHash);
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType value) {
        if (value == null) {
            value = ChartType.COLUMN_CHART;
        }
        this.tipPrim = null;
        this.chartType = value;
        this.getCore().setChartType(value);
        this.crosX = -1;
    }

    public int getStyleOf3DRotation() {
        return this.rotationStyle;
    }

    public void setStyleOf3DRotation(int value) {
        this.rotationStyle = value;
    }

    public int getStyleOf3DScaling() {
        return this.scaleStyle;
    }

    public void setStyleOf3DScaling(int value) {
        this.scaleStyle = value;
    }

    public boolean getEnableCrossHair() {
        return this.crosshair;
    }

    public void setEnableCrossHair(boolean value) {
        if (this.crosshair == value) {
            return;
        }
        this.crosshair = value;
        this.invalidate(1);
    }

    public View3DAppearance getTransform3D() {
        if (this.view3dAppearance == null) {
            this.view3dAppearance = new View3DAppearance(this);
        }
        this.view3dAppearance.setComponent(this);
        return this.view3dAppearance;
    }

    public void setTransform3D(View3DAppearance value) {
        if (value == this.view3dAppearance) {
            return;
        }
        this.view3dAppearance = value;
        this.invalidate(1);
    }

    @Override
    public void setBackground(Color value) {
        this.getBackgroundAppearance().setColor(value);
        super.setBackground(value);
    }

    public BackgroundAppearance getBackgroundAppearance() {
        if (this.backgroundAppearance == null) {
            this.backgroundAppearance = new BackgroundAppearance(this);
        }
        this.backgroundAppearance.setComponent(this);
        return this.backgroundAppearance;
    }

    public void setBackgroundAppearance(BackgroundAppearance value) {
        if (value == this.backgroundAppearance) {
            return;
        }
        BackgroundAppearance old = this.backgroundAppearance;
        if (value == null) {
            value = new BackgroundAppearance(this);
        }
        this.backgroundAppearance = value;
        super.setBackground(value.getColor());
        if (!value.equals(old)) {
            this.invalidate(1);
            this.firePropertyChange("backgroundAppearance", old, value);
        }
    }

    public BorderAppearance getBorderAppearance() {
        if (this.borderAppearance == null) {
            this.borderAppearance = new BorderAppearance(this);
        }
        this.borderAppearance.setComponent(this);
        return this.borderAppearance;
    }

    public void setBorderAppearance(BorderAppearance value) {
        if (value == this.borderAppearance) {
            return;
        }
        this.borderAppearance = value;
        this.invalidate(1);
    }

    public LegendAppearance getLegend() {
        if (this.legendAppearance == null) {
            this.legendAppearance = new LegendAppearance(this);
        }
        this.legendAppearance.setComponent(this);
        return this.legendAppearance;
    }

    public void setLegend(LegendAppearance value) {
        if (value == this.legendAppearance) {
            return;
        }
        this.legendAppearance = value;
        this.invalidate(1);
    }

    public DataAppearance getData() {
        if (this.dataAppearance == null) {
            this.dataAppearance = new DataAppearance(this);
        }
        this.dataAppearance.setComponent(this);
        return this.dataAppearance;
    }

    public void setData(DataAppearance value) {
        if (value == this.dataAppearance) {
            return;
        }
        if (value == null) {
            value = new DataAppearance(this);
        }
        value.setDirty(true);
        this.dataAppearance = value;
        this.invalidate(1);
    }

    public TitleAppearance getTitleTop() {
        if (this.titleTop == null) {
            this.titleTop = new TitleAppearance(this, 0);
        }
        this.titleTop.setComponent(this);
        return this.titleTop;
    }

    public void setTitleTop(TitleAppearance value) {
        if (value == this.titleTop) {
            return;
        }
        if (value == null) {
            this.titleTop = null;
        } else if (value.getTitleLocation() != 0) {
            this.titleTop = new TitleAppearance(this, 0);
            this.titleTop.copy(value);
        } else {
            value.setTitleLocation(0);
            this.titleTop = value;
        }
        this.invalidate(1);
    }

    public TitleAppearance getTitleLeft() {
        if (this.titleLeft == null) {
            this.titleLeft = new TitleAppearance(this, 1);
        }
        this.titleLeft.setComponent(this);
        return this.titleLeft;
    }

    public void setTitleLeft(TitleAppearance value) {
        if (value == this.titleLeft) {
            return;
        }
        if (value == null) {
            this.titleLeft = null;
        } else if (value.getTitleLocation() != 1) {
            this.titleLeft = new TitleAppearance(this, 1);
            this.titleLeft.copy(value);
        } else {
            value.setTitleLocation(1);
            this.titleLeft = value;
        }
        this.invalidate(1);
    }

    public TitleAppearance getTitleRight() {
        if (this.titleRight == null) {
            this.titleRight = new TitleAppearance(this, 2);
        }
        this.titleRight.setComponent(this);
        return this.titleRight;
    }

    public void setTitleRight(TitleAppearance value) {
        if (value == this.titleRight) {
            return;
        }
        if (value == null) {
            this.titleRight = new TitleAppearance(this, 2);
        } else if (value.getTitleLocation() != 2) {
            this.titleRight = new TitleAppearance(this, 2);
            this.titleRight.copy(value);
        } else {
            value.setTitleLocation(2);
            this.titleRight = value;
        }
        this.invalidate(1);
    }

    public TitleAppearance getTitleBottom() {
        if (this.titleBottom == null) {
            this.titleBottom = new TitleAppearance(this, 3);
        }
        this.titleBottom.setComponent(this);
        return this.titleBottom;
    }

    public void setTitleBottom(TitleAppearance value) {
        if (value != null && value == this.titleBottom) {
            return;
        }
        if (value == null) {
            this.titleBottom = new TitleAppearance(this, 3);
        } else if (value.getTitleLocation() != 3) {
            this.titleBottom = new TitleAppearance(this, 3);
            this.titleBottom.copy(value);
        } else {
            value.setTitleLocation(3);
            this.titleBottom = value;
        }
        this.invalidate(1);
    }

    public TooltipAppearance getTooltipAppearence() {
        return this.getTooltips();
    }

    public ColorAppearance getColorAppearance() {
        if (this.colorAppearance == null) {
            this.colorAppearance = new ColorAppearance(this);
        }
        this.colorAppearance.setComponent(this);
        return this.colorAppearance;
    }

    public void setColorAppearance(ColorAppearance value) {
        if (value == this.colorAppearance) {
            return;
        }
        this.colorAppearance = value;
        this.invalidate(1);
    }

    public ChartGridAppearance getAxis() {
        if (this.gridAppearance == null) {
            this.gridAppearance = new ChartGridAppearance(this);
        }
        this.gridAppearance.setComponent(this);
        return this.gridAppearance;
    }

    public void setAxis(ChartGridAppearance value) {
        if (value == this.gridAppearance) {
            return;
        }
        this.gridAppearance = value;
        this.invalidate(1);
    }

    public TooltipAppearance getTooltips() {
        if (this.tooltipAppearance == null) {
            this.tooltipAppearance = new TooltipAppearance(this);
        }
        this.tooltipAppearance.setComponent(this);
        return this.tooltipAppearance;
    }

    public void setTooltips(TooltipAppearance value) {
        if (value == this.tooltipAppearance) {
            return;
        }
        this.tooltipAppearance = value;
    }

    public LineChartAppearance getLineChart() {
        if (this.lineAppearance == null) {
            this.lineAppearance = new LineChartAppearance(this);
        }
        this.lineAppearance.setComponent(this);
        return this.lineAppearance;
    }

    public void setLineChart(LineChartAppearance value) {
        if (value == this.lineAppearance) {
            return;
        }
        this.lineAppearance = value;
        this.invalidate(1);
    }

    public ScatterChartAppearance getScatterChart() {
        if (this.scatterAppearance == null) {
            this.scatterAppearance = new ScatterChartAppearance(this);
        }
        this.scatterAppearance.setComponent(this);
        return this.scatterAppearance;
    }

    public void setScatterChart(ScatterChartAppearance value) {
        if (value == this.scatterAppearance) {
            return;
        }
        this.scatterAppearance = value;
        this.invalidate(1);
    }

    public PieChartAppearance getPieChart() {
        if (this.pieAppearance == null) {
            this.pieAppearance = new PieChartAppearance(this);
        }
        this.pieAppearance.setComponent(this);
        return this.pieAppearance;
    }

    public void setPieChart(PieChartAppearance value) {
        if (value == this.pieAppearance) {
            return;
        }
        this.pieAppearance = value;
        this.invalidate(1);
    }

    public BarChartAppearance getBarChart() {
        if (this.barAppearance == null) {
            this.barAppearance = new BarChartAppearance(this);
        }
        this.barAppearance.setComponent(this);
        return this.barAppearance;
    }

    public void setBarChart(BarChartAppearance value) {
        if (value == this.barAppearance) {
            return;
        }
        this.barAppearance = value;
        this.invalidate(1);
    }

    public ColumnChartAppearance getColumnChart() {
        if (this.columnAppearance == null) {
            this.columnAppearance = new ColumnChartAppearance(this);
        }
        this.columnAppearance.setComponent(this);
        return this.columnAppearance;
    }

    public void setColumnChart(ColumnChartAppearance value) {
        if (value == this.columnAppearance) {
            return;
        }
        this.columnAppearance = value;
        this.invalidate(1);
    }

    public AreaChartAppearance getAreaChart() {
        if (this.areaAppearance == null) {
            this.areaAppearance = new AreaChartAppearance(this);
        }
        this.areaAppearance.setComponent(this);
        return this.areaAppearance;
    }

    public void setAreaChart(AreaChartAppearance value) {
        if (value == this.areaAppearance) {
            return;
        }
        this.areaAppearance = value;
        this.invalidate(1);
    }

    public HeatMapChartAppearance getHeatMapChart() {
        if (this.heatMapAppearance == null) {
            this.heatMapAppearance = new HeatMapChartAppearance(this);
        }
        this.heatMapAppearance.setComponent(this);
        return this.heatMapAppearance;
    }

    public void setHeatMapChart(HeatMapChartAppearance value) {
        if (value == this.heatMapAppearance) {
            return;
        }
        this.heatMapAppearance = value;
        this.invalidate(1);
    }

    public BubbleChartAppearance getBubbleChart() {
        if (this.bubbleAppearance == null) {
            this.bubbleAppearance = new BubbleChartAppearance(this);
        }
        this.bubbleAppearance.setComponent(this);
        return this.bubbleAppearance;
    }

    public void setBubbleChart(BubbleChartAppearance value) {
        if (value == this.bubbleAppearance) {
            return;
        }
        this.bubbleAppearance = value;
        this.invalidate(1);
    }

    public CandleChartAppearance getCandleChart() {
        if (this.candleAppearance == null) {
            this.candleAppearance = new CandleChartAppearance(this);
        }
        this.candleAppearance.setComponent(this);
        return this.candleAppearance;
    }

    public void setCandleChart(CandleChartAppearance value) {
        if (value == this.candleAppearance) {
            return;
        }
        this.candleAppearance = value;
        this.invalidate(1);
    }

    @Override
    public ChartAppearance getChartAppearance(int appearanceType) {
        switch (appearanceType) {
            case 14: {
                return this.getAreaChart();
            }
            case 9: {
                return this.getAxis().getX();
            }
            case 10: {
                return this.getAxis().getY();
            }
            case 11: {
                return this.getAxis().getZ();
            }
            case 27: {
                return this.getAxis();
            }
            case 12: {
                return this.getBarChart();
            }
            case 0: {
                return this.getBorderAppearance();
            }
            case 17: {
                return this.getBubbleChart();
            }
            case 6: {
                return this.getColorAppearance();
            }
            case 13: {
                return this.getColumnChart();
            }
            case 8: {
                return this.getData();
            }
            case 19: {
                return this.getHeatMapChart();
            }
            case 1: {
                return this.getLegend();
            }
            case 15: {
                return this.getLineChart();
            }
            case 16: {
                return this.getPieChart();
            }
            case 18: {
                return this.getScatterChart();
            }
            case 5: {
                return this.getTitleBottom();
            }
            case 3: {
                return this.getTitleLeft();
            }
            case 4: {
                return this.getTitleRight();
            }
            case 2: {
                return this.getTitleTop();
            }
            case 7: {
                return this.getTooltips();
            }
            case 24: {
                return this.getTransform3D();
            }
            case 25: {
                return this.getCandleChart();
            }
            case 26: {
                return this.getBackgroundAppearance();
            }
        }
        return null;
    }

    public void setColorModel(IColorModel model) {
        this.getCore().setColorModel(model);
        this.invalidate(1);
    }

    @Override
    public synchronized void invalidate(int cacheLevel) {
        if (this.chartCore == null) {
            return;
        }
        if (cacheLevel == 1) {
            this.tipPrim = null;
            this.chartCore.setDirty(true);
            this.selOnly = false;
            if (this.oldHit != null && (this.chartType == ChartType.PIE_CHART || this.chartType == ChartType.HEAT_MAP_CHART_3D && !this.oldHit.drawAll())) {
                this.oldHit = null;
            }
        }
        this.repaint();
    }

    @Override
    public void resizeAll() {
        if (this.chartCore != null) {
            this.chartCore.resizeAllLayers();
        }
    }

    @Override
    public ChartDataEventArgs getChartInfoFromPoint(Point point) {
        return this.getCore().getChartInfoFromPrimitive(this.getCore().getChartPrimitiveFromPoint(point));
    }

    public ChartDataEventArgs[] hitTest(Point p) {
        return this.getCore().getEventArgs(this.primAtPoint(p));
    }

    public synchronized void addChartEventListener(UltraChartEventListener l) {
        if (this.m_lsnr == null) {
            this.m_lsnr = new Vector();
        }
        this.m_lsnr.addElement(l);
    }

    public synchronized void removeChartEventListener(UltraChartEventListener l) {
        if (this.m_lsnr != null) {
            this.m_lsnr.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(ChartDataEventArgs[] points, int id) {
        Vector copy;
        BasicChartComponent basicChartComponent = this;
        synchronized (basicChartComponent) {
            if (this.m_lsnr == null) {
                return;
            }
            copy = (Vector)this.m_lsnr.clone();
        }
        UltraChartEvent e = new UltraChartEvent(this, id, points);
        block8: for (int i = 0; i < copy.size(); ++i) {
            switch (id) {
                case 0: {
                    ((UltraChartEventListener)copy.elementAt(i)).chartDataClicked(e);
                    continue block8;
                }
                case 1: {
                    ((UltraChartEventListener)copy.elementAt(i)).chartDataMouseOver(e);
                    continue block8;
                }
                case 2: {
                    ((UltraChartEventListener)copy.elementAt(i)).chartDataMouseOut(e);
                }
            }
        }
    }

    ChartCore getCore() {
        if (this.chartCore == null) {
            this.chartCore = new ChartCore(this);
        }
        return this.chartCore;
    }

    ChartRender getRender() {
        if (this.renderCS == null) {
            this.renderCS = new ChartRender(this);
        }
        return this.renderCS;
    }

    Primitive primAtPoint(Point p) {
        return this.chartCore.getChartPrimitiveFromPoint(p);
    }

    boolean select(MouseEvent e, int id) {
        int style = this.getTooltips().getDisplay();
        if (id == 4) {
            this.mouseIn = false;
            if (style == 3 || this.oldClick != null) {
                return false;
            }
            id = 1;
        }
        if (id == 1 && style != 1) {
            return false;
        }
        Primitive newHit = this.mouseIn ? this.primAtPoint(e.getPoint()) : null;
        int newSymbol = newHit == null ? -1 : newHit.lastHit();
        boolean mod = false;
        boolean sel = false;
        if (id == 6) {
            this.oldHit = this.oldClick;
            if (style != 2) {
                this.oldClick = null;
            }
            if (style == 3 && this.oldHit != null) {
                mod = true;
            }
            if (style == 1) {
                mod = this.oldHit != newHit || this.oldSymbol != newSymbol;
                sel = newHit != null;
            }
        } else if (id == 5) {
            if (style == 2 && this.oldClick != null) {
                this.oldHit = this.oldClick;
            }
            this.oldClick = newHit;
            if (newHit != null && style == 3) {
                mod = true;
                sel = true;
            }
            if (style == 2) {
                sel = newHit != null;
                mod = true;
            }
        } else if ((this.oldHit != newHit || this.oldSymbol != newSymbol) && style == 1) {
            mod = true;
        }
        if (style == 1 && newHit != null) {
            sel = true;
        }
        if (mod && this.getTooltips().getHighlightDataPoint()) {
            if ((id != 5 || style == 2) && this.oldHit != null) {
                this.oldHit.selected = null;
            }
            if (newHit != null && (this.oldHit != newHit || this.oldSymbol != newSymbol || id == 5)) {
                if (this.oldHit != null) {
                    this.oldHit.selected = null;
                }
                if (sel) {
                    this.selected.fillColor = this.getTooltips().getColor(3);
                    this.selected.drawColor = this.getTooltips().getColor(4);
                    this.selected.drawThickness = this.getTooltips().getHighlightOutlineThickness();
                    newHit.selected = this.selected;
                }
            }
        }
        if (id != 5 && style == 2 && this.oldClick == newHit) {
            sel = true;
            boolean bl = mod = this.tipPrim == null;
        }
        if (mod) {
            this.tipPoint = e.getPoint();
        }
        if (style == 2 && this.oldHit != newHit) {
            if (newHit == this.oldClick || this.oldHit == this.oldClick) {
                mod = true;
            }
            boolean bl = sel = newHit == this.oldClick;
        }
        if (mod) {
            this.oldSymbol = Primitive.update(newHit, newSymbol);
            this.oldHit = newHit;
        }
        Primitive primitive = this.tipPrim = sel ? newHit : null;
        if (mod) {
            this.selOnly = true;
        }
        return mod;
    }

    Text getTip(int w, int h) {
        ChartDataEventArgs[] chartDataEventArgsArray;
        if (this.tipPrim == null) {
            return null;
        }
        TooltipAppearance a = this.getTooltips();
        String text = a.getString();
        if (text == null || text.length() == 0) {
            return null;
        }
        if (this.getTooltips().getShowAllDataPoints()) {
            chartDataEventArgsArray = this.chartCore.getEventArgs(this.tipPrim);
        } else {
            ChartDataEventArgs[] chartDataEventArgsArray2 = new ChartDataEventArgs[1];
            chartDataEventArgsArray = chartDataEventArgsArray2;
            chartDataEventArgsArray2[0] = this.chartCore.getChartInfoFromPrimitive(this.tipPrim);
        }
        ChartDataEventArgs[] args = chartDataEventArgsArray;
        if (args == null) {
            return null;
        }
        String tooltiptext = "";
        for (ChartDataEventArgs primInfo : args) {
            if (primInfo == null) continue;
            Object o = primInfo.getDataValue();
            ChartCore.Environment.put("DATA_VALUE", o == null ? DefaultConstants.D_TOOLTIP_NULL : o);
            ChartCore.Environment.put("ITEM_LABEL", primInfo.getRowLabel());
            ChartCore.Environment.put("DATA_ROW", primInfo.getDataRow());
            ChartCore.Environment.put("DATA_COLUMN", primInfo.getDataColumn());
            ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.ADORNMENT_LAYER);
            ChartCore.Environment.put("SERIES_LABEL", primInfo.getColumnLabel());
            if (tooltiptext.length() > 0) {
                tooltiptext = tooltiptext + '\n';
            }
            tooltiptext = tooltiptext + LabelFormatter.replaceKeywords(text);
            if (!this.tipPrim.drawAll()) break;
        }
        if (tooltiptext.length() == 0) {
            return null;
        }
        this.tipText.bounds = new Rectangle(this.tipPoint.getX(), this.tipPoint.getY(), w, -h);
        this.tipText.lineStyle.setDrawStyle(a.getBorderStyle());
        this.tipText.drawThickness = a.getBorderThickness();
        this.tipText.drawColor = a.getColor(2);
        this.tipText.fillColor = a.getColor(0);
        this.tipText.labelStyle.setFont(a.getFont());
        this.tipText.labelStyle.setFontColor(a.getColor(1));
        this.tipText.textString = tooltiptext;
        return this.tipText;
    }

    private void processMouseMotionEvent(MouseEvent e, int id) {
        if (this.chartCore == null) {
            return;
        }
        e.translatePoint(-this.getInsets().left, -this.getInsets().top);
        int x = e.getX();
        int y = e.getY();
        if (id == 0 && e.isLeftMouseButton() && (this.chartCore.is3D || this.chartType == ChartType.PIE_CHART)) {
            boolean rot = this.view3D == 1;
            boolean sca = false;
            if (!rot) {
                if (e.isShiftDown()) {
                    rot = this.rotationStyle == 2;
                    sca = this.scaleStyle == 2;
                } else if (e.isControlDown()) {
                    rot = this.rotationStyle == 3;
                    sca = this.scaleStyle == 3;
                } else if (e.isAltDown()) {
                    rot = this.rotationStyle == 4;
                    sca = this.scaleStyle == 4;
                } else {
                    rot = this.rotationStyle == 1;
                    sca = this.scaleStyle == 1;
                }
            }
            View3DAppearance view = this.getTransform3D();
            if (this.dragging == 0) {
                if (rot) {
                    this.dragging = 1;
                    if (this.chartType == ChartType.PIE_CHART) {
                        this.xtheta = this.getPieChart().getStartAngle();
                    } else {
                        this.xtheta = view.getXRotation();
                        this.ytheta = view.getYRotation();
                    }
                } else if (sca) {
                    this.dragging = 2;
                    this.scale = view.getScale();
                }
            } else if (rot) {
                if (this.dragging == 2) {
                    return;
                }
                if (this.chartType == ChartType.PIE_CHART) {
                    this.getPieChart().setStartAngle(this.xtheta + (y - this.prevy) * 360 / this.getWidth());
                } else {
                    view.setXRotation(this.xtheta + (this.prevy - y) * 360 / this.getWidth());
                    view.setYRotation(this.ytheta + (this.prevx - x) * 360 / this.getHeight());
                }
            } else if (sca) {
                if (this.dragging == 1) {
                    return;
                }
                view.setScale(this.scale + (float)(x + y - this.prevy - this.prevx) * 200.0f / (float)this.getWidth());
            }
            return;
        }
        this.prevx = x;
        this.prevy = y;
        boolean move = false;
        if (id == 1) {
            this.mouseIn = true;
            if (this.view3D != 1) {
                Primitive oldHitCopy = this.oldHit;
                int oldHitHit = Primitive.hit(oldHitCopy);
                move = this.select(e, id);
                if (oldHitCopy != this.oldHit || oldHitHit != Primitive.hit(this.oldHit)) {
                    if (oldHitCopy != null) {
                        this.fireEvent(this.chartCore.getEventArgs(oldHitCopy, oldHitHit), 2);
                    }
                    if (this.oldHit != null) {
                        this.fireEvent(this.chartCore.getEventArgs(this.oldHit), 1);
                    }
                }
            }
        }
        boolean hair = false;
        if (!this.chartCore.is3D && this.crosshair && this.crossHairColor != null && this.chartType != ChartType.PIE_CHART) {
            Rectangle r = this.chartCore.getGridLayer().getInnerBounds();
            boolean bl = hair = x > r.getX() && x < r.getX() + r.getWidth() && y > r.getY() && y < r.getY() + r.getHeight();
            if (!hair) {
                y = -1;
                x = -1;
            }
            if (this.crosX > 0) {
                hair = true;
            }
            this.crosX = x;
            this.crosY = y;
        }
        if (move || hair) {
            this.repaint();
        }
    }

    private void processMouseEvent(MouseEvent e, int id) {
        if (this.chartCore == null) {
            return;
        }
        e.translatePoint(-this.getInsets().left, -this.getInsets().top);
        boolean bRepaint = false;
        if (id == 5) {
            this.prevx = e.getX();
            this.prevy = e.getY();
            bRepaint = this.select(e, id);
            if (this.oldHit != null) {
                this.fireEvent(this.chartCore.getEventArgs(this.oldHit), 0);
            }
        }
        if (id == 6 || id == 4) {
            if (id == 6) {
                this.dragging = 0;
            }
            Primitive oldHitCopy = this.oldHit;
            int oldHitHit = Primitive.hit(oldHitCopy);
            bRepaint = this.select(e, id);
            if (oldHitCopy != this.oldHit || oldHitHit != Primitive.hit(this.oldHit)) {
                if (oldHitCopy != null) {
                    this.fireEvent(this.chartCore.getEventArgs(oldHitCopy, oldHitHit), 2);
                }
                if (this.oldHit != null) {
                    this.fireEvent(this.chartCore.getEventArgs(this.oldHit), 1);
                }
            }
            if (id == 6 && this.getTooltips().getHighlightOnTop() && this.getTooltips().getHighlightDataPoint()) {
                this.selOnly = false;
                this.invalidate(1);
                bRepaint = false;
            }
        }
        if (bRepaint) {
            this.repaint();
        }
    }

    public static class DemoTable {
        public static final int ONE_ROW = 256;
        public static final int ONE_HALF = 512;
        public static final int INCLUDE_NULL = 1024;
        public static final int MIXED = 2048;
        public static String[] candleColumns = new String[]{"Date", "Open", "Low", "High", "Close", "Adj. Close"};
        public static Object[][] candleData = new Object[][]{{new GregorianCalendar(1, 9, 24).getTime(), 6.95, 7.1, 5.44, 5.9, 377200.0}, {new GregorianCalendar(1, 9, 17).getTime(), 7.5, 7.75, 6.51, 6.92, 461800.0}, {new GregorianCalendar(1, 9, 10).getTime(), 8.1, 8.11, 7.78, 7.88, 150200.0}, {new GregorianCalendar(1, 9, 3).getTime(), 7.55, 8.12, 7.51, 8.0, 120600.0}, {new GregorianCalendar(1, 8, 27).getTime(), 8.15, 8.23, 7.42, 7.5, 89200.0}, {new GregorianCalendar(1, 8, 20).getTime(), 7.98, 8.25, 7.91, 8.15, 174000.0}, {new GregorianCalendar(1, 8, 13).getTime(), 7.9, 8.07, 7.7, 7.93, 272800.0}, {new GregorianCalendar(1, 8, 6).getTime(), 7.93, 8.0, 7.52, 7.85, 132400.0}, {new GregorianCalendar(1, 7, 30).getTime(), 8.5, 8.96, 7.73, 7.78, 184500.0}, {new GregorianCalendar(1, 7, 23).getTime(), 8.95, 8.96, 8.1, 8.45, 218700.0}, {new GregorianCalendar(1, 7, 16).getTime(), 8.08, 8.85, 7.95, 8.85, 212300.0}, {new GregorianCalendar(1, 7, 9).getTime(), 8.0, 8.5, 7.6, 8.08, 288000.0}, {new GregorianCalendar(1, 7, 2).getTime(), 7.9, 8.2, 7.4, 7.96, 415400.0}, {new GregorianCalendar(1, 6, 25).getTime(), 9.1, 10.2, 7.75, 7.9, 448800.0}, {new GregorianCalendar(1, 6, 18).getTime(), 10.6, 10.79, 8.9, 9.09, 207800.0}, {new GregorianCalendar(1, 6, 11).getTime(), 11.77, 11.9, 10.58, 11.0, 151000.0}, {new GregorianCalendar(1, 6, 4).getTime(), 12.85, 13.2, 11.36, 11.67, 139200.0}, {new GregorianCalendar(1, 5, 28).getTime(), 12.9, 13.2, 12.5, 12.75, 174200.0}, {new GregorianCalendar(1, 5, 21).getTime(), 13.5, 14.1, 12.45, 12.55, 321200.0}, {new GregorianCalendar(1, 5, 14).getTime(), 12.9, 13.52, 12.9, 13.5, 644900.0}};

        public static TableModel table() {
            return DemoTable.table(0);
        }

        public static TableModel table(int size) {
            Object[][] data;
            Object[] cols;
            if (size == 0) {
                cols = candleColumns;
                data = candleData;
            } else {
                int iRows;
                boolean negative;
                boolean bl = negative = size < 0;
                if (negative) {
                    size = -size;
                }
                int zero = 45;
                if ((size & 0x800) != 0) {
                    zero = 10;
                }
                if ((iRows = size & 0xFF) < 2) {
                    iRows = 2;
                }
                int iCols = 20;
                if (iRows > 14) {
                    if (iRows > 17) {
                        zero += (iRows - 17) * 2;
                    }
                    iCols += iRows - 14;
                    if (iRows > 25) {
                        iRows = 25;
                    }
                }
                double step = (double)(iCols - iRows) / 15.0;
                boolean nulls = (size & 0x400) != 0;
                iCols = iRows;
                if ((size & 0x200) != 0) {
                    iRows /= 2;
                }
                if ((size & 0x100) != 0) {
                    iRows = 1;
                }
                cols = new Object[iCols + 1];
                data = new Object[iRows][iCols + 1];
                for (int i = 0; i < iRows; ++i) {
                    data[i][0] = "ROW" + (i + 1);
                    for (int j = 1; j <= iCols; ++j) {
                        double val = (double)(zero - (i + j)) - 16.0 * Math.sin(((double)j + (double)i * 0.05) * step) * Math.cos((double)i * step * 1.45);
                        data[i][j] = nulls && (j + i) % 4 == 1 ? null : Double.valueOf(negative ? -val : val);
                    }
                }
                for (int j = 0; j <= iCols; ++j) {
                    cols[j] = "COLUMN #" + j;
                }
            }
            return new AbstractTableModel(){

                @Override
                public String getColumnName(int column) {
                    return (String)cols[column];
                }

                @Override
                public int getColumnCount() {
                    return cols.length;
                }

                @Override
                public int getRowCount() {
                    return data.length;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return data[rowIndex][columnIndex];
                }
            };
        }
    }
}

