/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.util.LinkedList;
import oracle.bpm.bcgen.JVMCodeBuilderImpl;
import oracle.bpm.bcgen.LocalVariable;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bcgen.TargetInstruction;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Type;

class TryBlock {
    private BranchHandle blockEnd;
    private JVMCodeBuilderImpl builder;
    private LinkedList<BranchHandle> endList;
    private LinkedList<BranchHandle> finallyList;
    private LocalVariable lastExceptionVar;
    private LocalVariable retAddress;
    private InstructionHandle start;

    TryBlock(JVMCodeBuilderImpl builder, boolean hasFinally) {
        this.builder = builder;
        if (hasFinally) {
            this.finallyList = new LinkedList();
        }
        this.endList = new LinkedList();
        builder.fixTargetWithNext(new TargetInstruction(){

            @Override
            public void setTarget(InstructionHandle location) {
                TryBlock.this.start = location;
            }
        });
    }

    LocalVariable addCatch(ObjectType throwableType, String throwableVarName) {
        this.fixExceptionVar();
        this.callFinally();
        BranchHandle handle = this.builder.goTo();
        this.endList.add(handle);
        if (this.blockEnd == null) {
            this.blockEnd = handle;
        }
        ObjectType type = throwableType == null ? TD.OBJECT : throwableType;
        this.lastExceptionVar = this.builder.createLocalVariable(throwableVarName, (Type)type);
        this.builder.getStack().push((Type)type);
        this.builder.storeLocal(this.lastExceptionVar);
        this.builder.exceptionHandler(this.start, (InstructionHandle)this.blockEnd, throwableType);
        return this.lastExceptionVar;
    }

    void addFinally() {
        if (this.finallyList == null) {
            throw new IllegalStateException("Active try block doesn't support finally clause.");
        }
        if (this.retAddress != null) {
            throw new IllegalStateException("Finally block already added.");
        }
        this.fixExceptionVar();
        LocalVariable e = this.addCatch(null, "any");
        this.callFinally();
        this.builder.loadLocal(e);
        this.builder.throwObject();
        this.fixExceptionVar();
        this.retAddress = this.builder.createLocalVariable("retAddress", (Type)TD.OBJECT);
        this.builder.getStack().push((Type)TD.OBJECT);
        this.builder.storeLocal(this.retAddress);
        this.builder.fixTarget(this.finallyList);
    }

    void callFinally() {
        if (this.finallyList != null) {
            this.finallyList.add(this.builder.goSub());
        }
    }

    void end() {
        this.fixExceptionVar();
        if (this.finallyList != null) {
            if (this.retAddress == null) {
                throw new IllegalStateException("End of try without adding finally block.");
            }
            this.builder.append((Instruction)new RET(this.retAddress.getIndex()));
            this.builder.fixEnd(this.retAddress);
        }
        for (BranchHandle handle : this.endList) {
            this.builder.fixTargetWithNext(handle);
        }
    }

    boolean hasFinally() {
        return this.finallyList != null;
    }

    private void fixExceptionVar() {
        if (this.lastExceptionVar != null) {
            this.builder.fixEnd(this.lastExceptionVar);
        }
    }
}

