/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.bpm.bcgen.MissingClassesException;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.collections.Tuple;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.NotNull;

public class MethodD {
    private Type[] argTypes;
    private boolean isStatic;
    private String name;
    private ReferencesInterface referencesIface = ReferencesInterface.GUESS;
    private Type returnType;
    private ObjectType targetType;

    private MethodD(Type returnType, ObjectType targetType, String name, boolean isStatic, Type ... argTypes) {
        this.returnType = returnType;
        this.targetType = targetType;
        this.name = name;
        this.argTypes = argTypes == null ? Type.NO_ARGS : argTypes;
        this.isStatic = isStatic;
        this.verify();
    }

    public static MethodD create(Type returnType, ObjectType targetType, String name, Type ... argTypes) {
        return MethodD.create(false, returnType, targetType, name, argTypes);
    }

    public static MethodD create(Class clazz, String methodName) {
        java.lang.reflect.Method m = null;
        for (java.lang.reflect.Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (m != null) {
                String qname = clazz.getName() + "." + methodName;
                throw new IllegalArgumentException("More than one method with this name: " + qname);
            }
            m = method;
        }
        if (m == null) {
            throw new IllegalArgumentException("No such method: " + clazz.getName() + "." + methodName);
        }
        Class<?>[] argClasses = m.getParameterTypes();
        Type[] args = new Type[argClasses.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = Type.getType(argClasses[i]);
        }
        boolean isStatic = (8 & m.getModifiers()) != 0;
        return MethodD.create(isStatic, Type.getType(m.getReturnType()), TD.getObjectType(clazz), methodName, args);
    }

    public static MethodD create(boolean isStatic, Type returnType, ObjectType targetType, String name, Type ... argTypes) {
        return new MethodD(returnType, targetType, name, isStatic, argTypes);
    }

    public static MethodD createFromSignature(String methodSignature) {
        int m = methodSignature.indexOf(77);
        assert (m > 0);
        Type target = Type.getType((String)methodSignature.substring(0, m));
        assert (target instanceof ObjectType);
        return MethodD.createFromSignature(true, (ObjectType)target, methodSignature.substring(m));
    }

    public static MethodD createFromSignature(boolean isStatic, ObjectType target, String methodSignature) {
        int lp = methodSignature.indexOf(40);
        assert (methodSignature.charAt(0) == 'M' && lp > 0);
        String name = methodSignature.substring(1, lp);
        String signature = methodSignature.substring(lp);
        return MethodD.create(isStatic, Type.getReturnType((String)signature), target, name, MethodD.getArgumentTypes(signature));
    }

    public static MethodD createStatic(Type returnType, ObjectType targetType, String name, Type ... argTypes) {
        return MethodD.create(true, returnType, targetType, name, argTypes);
    }

    public static MethodD createSetterFromSignature(boolean aStatic, ObjectType target, String memberSignature, boolean dynamicMember) {
        MethodD methodD = MethodD.createFromSignature(aStatic, target, memberSignature);
        if (dynamicMember) {
            methodD.setArgType(TDKit.INVOKEABLE, 0);
        }
        return methodD;
    }

    public int getArgCount() {
        return this.argTypes.length;
    }

    public Type getArgType(int i) {
        return this.argTypes[i];
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public ObjectType getTargetType() {
        return this.targetType;
    }

    public boolean isVoid() {
        return this.returnType.equals(Type.VOID);
    }

    public void setReferencesInterface(@NotNull ReferencesInterface value) {
        this.referencesIface = value;
    }

    public boolean referencesInterface() {
        return this.referencesIface == ReferencesInterface.GUESS ? this.guessIfReferenceInterface() : this.referencesIface == ReferencesInterface.YES;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isStatic) {
            sb.append("static ");
        }
        if (this.referencesInterface()) {
            sb.append("virtual ");
        }
        sb.append(this.returnType);
        sb.append(' ');
        sb.append(this.targetType);
        sb.append('.');
        sb.append(this.name);
        sb.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            Type argType = this.argTypes[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(argType);
        }
        sb.append(')');
        return sb.toString();
    }

    Type[] getArgTypes() {
        return this.argTypes;
    }

    String getName() {
        return this.name;
    }

    boolean isStatic() {
        return this.isStatic;
    }

    private static Type[] getArgumentTypes(String signature) {
        ArrayList<Type> result = new ArrayList<Type>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                Tuple<Type, Integer> tuple = MethodD.getType(signature.substring(index));
                result.add(tuple.getFirst());
                index += tuple.getSecond().intValue();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return result.toArray(new Type[result.size()]);
    }

    private static Tuple<Type, Integer> getType(String signature) {
        int consumedChars;
        BasicType result;
        byte type = Utility.typeOfSignature((String)signature);
        if (type <= 12) {
            result = BasicType.getType((byte)type);
            consumedChars = 1;
        } else if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            Tuple<Type, Integer> t = MethodD.getType(signature.substring(dim));
            result = new ArrayType(t.getFirst(), dim);
            consumedChars = t.getSecond() + dim;
        } else {
            int index = signature.indexOf(59);
            if (index < 0) {
                throw new ClassFormatException("Invalid signature: " + signature);
            }
            result = new ObjectType(signature.substring(1, index).replace('/', '.'));
            consumedChars = index + 1;
        }
        return Tuple.create(result, consumedChars);
    }

    private boolean guessIfReferenceInterface() {
        boolean ret;
        if (this.isStatic) {
            ret = false;
        } else {
            ret = this.targetType.referencesInterface();
            assert (ret || this.targetType.referencesClass()) : "Could not resolve class method type. Object class= '" + this.targetType.getClassName() + "'";
        }
        return ret;
    }

    private void setArgType(ObjectType type, int i) {
        this.argTypes[i] = type;
    }

    private boolean verifiedOk() {
        String className = this.targetType.getClassName();
        if (className.startsWith("xobject.")) {
            return true;
        }
        JavaClass jc = this.getValidJavaClass(className);
        if (jc != null && jc.isInterface()) {
            for (JavaClass iface : this.getAllInterfaces(jc)) {
                if (!this.verifySingleClass(iface)) continue;
                return true;
            }
        }
        while (jc != null) {
            if (this.verifySingleClass(jc)) {
                return true;
            }
            className = jc.getClassName();
            jc = jc.getSuperClass();
        }
        return !className.equals(Object.class.getName());
    }

    private JavaClass getValidJavaClass(String className) throws MissingClassesException {
        try {
            return TD.getValidJavaClass(className);
        }
        catch (NoClassDefFoundError ex) {
            throw new MissingClassesException(className, new String[]{ex.getMessage()});
        }
    }

    private JavaClass[] getAllInterfaces(JavaClass jc) {
        if (jc == null) {
            throw new NullPointerException("java class is not optional");
        }
        try {
            return jc.getAllInterfaces();
        }
        catch (NullPointerException e) {
            throw new MissingClassesException(jc.getClassName(), jc.getInterfaceNames());
        }
    }

    private boolean verifySingleClass(JavaClass jc) {
        for (Method method : jc.getMethods()) {
            if (!method.getName().equals(this.name) || this.isStatic != method.isStatic() || !method.getReturnType().equals(this.returnType) || !this.verifyMethodArgs(method)) continue;
            return true;
        }
        return false;
    }

    private void verify() {
        assert (this.verifiedOk()) : "Could not find the method '" + this.returnType + ' ' + this.name + "( " + (this.argTypes.length == 0 ? "" : Arrays.asList(this.argTypes)) + " )'" + "' in the class '" + this.targetType.getClassName() + "'.";
    }

    private boolean verifyMethodArgs(Method method) {
        Type[] argumentTypes = method.getArgumentTypes();
        int len = argumentTypes.length;
        if (len != this.argTypes.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (argumentTypes[i].equals(this.argTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static enum ReferencesInterface {
        YES,
        NO,
        GUESS;

    }
}

