/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.lang.TypeDescription;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class FieldD {
    private String className;
    private boolean isStatic;
    private String name;
    private Type type;

    private FieldD(String className, String name, Type type, boolean isStatic) {
        this.className = className;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
    }

    public static FieldD create(boolean isStatic, ObjectType targetClass, String fieldName, Type type) {
        return new FieldD(targetClass.getClassName(), fieldName, type, isStatic);
    }

    public static FieldD create(ObjectType targetClass, String fieldName, Type type) {
        return new FieldD(targetClass.getClassName(), fieldName, type, false);
    }

    public static FieldD create(Class targetClass, String fieldName) {
        try {
            Field field = targetClass.getField(fieldName);
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            Class<?> fieldClass = field.getType();
            return FieldD.create(isStatic, TD.getObjectType(targetClass), fieldName, TD.valueOf(fieldClass.getName()));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static FieldD createFromSignature(boolean isStatic, ObjectType target, String fieldSignature) {
        int index = fieldSignature.indexOf(59);
        assert (fieldSignature.charAt(0) == 'A' && index >= 0);
        String name = fieldSignature.substring(1, index);
        String signature = fieldSignature.substring(index + 1);
        return FieldD.create(isStatic, target, name, Type.getType((String)signature));
    }

    public static FieldD createStatic(ObjectType targetClass, String fieldName, Type type) {
        return new FieldD(targetClass.getClassName(), fieldName, type, true);
    }

    public static FieldD parent(TypeDescription objType) {
        return FieldD.create(TD.getObjectType(objType), "this_0", TD.valueOf(objType.getParent()));
    }

    public static FieldD createSetterFromSignature(boolean aStatic, ObjectType target, String memberSignature, boolean dynamicMember) {
        FieldD fieldD = FieldD.createFromSignature(aStatic, target, memberSignature);
        if (dynamicMember) {
            fieldD.setType(TDKit.INVOKEABLE);
        }
        return fieldD;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public Type getType() {
        return this.type;
    }

    static FieldD create(ClassGen classGen, FieldGen fieldGen) {
        return new FieldD(classGen.getClassName(), fieldGen.getName(), fieldGen.getType(), fieldGen.isStatic());
    }

    private void setType(ObjectType type) {
        this.type = type;
    }
}

