/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.bpm.io.IndentedPrintWriter;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackInstruction;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.Type;

public class DumpTool {
    private String[] args;
    private IndentedPrintWriter pw;

    public DumpTool(String[] args) {
        this.args = args;
        this.pw = new IndentedPrintWriter(System.out, true);
    }

    public static void main(String[] args) throws Throwable {
        new DumpTool(args).run();
    }

    private void run() throws IOException {
        if (this.args == null || this.args.length != 1) {
            this.usage();
            return;
        }
        ClassParser parser = new ClassParser(this.args[0]);
        JavaClass javaClass = parser.parse();
        this.pw.print(Utility.accessToString((int)javaClass.getAccessFlags(), (boolean)true));
        this.pw.print(' ');
        this.pw.println(javaClass.getClassName());
        this.pw.println('{');
        this.pw.indent();
        Field[] fields = javaClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            this.pw.println(field.toString());
        }
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Attribute[] attributes;
            if (i != 0) {
                this.pw.println("");
            }
            Method method = methods[i];
            this.pw.print(Utility.accessToString((int)method.getAccessFlags()));
            this.pw.print(' ');
            this.pw.print(method.getReturnType());
            this.pw.print(' ');
            this.pw.print(method.getName());
            this.pw.print('(');
            Type[] argumentTypes = method.getArgumentTypes();
            for (int j = 0; j < argumentTypes.length; ++j) {
                Type argumentType = argumentTypes[j];
                if (j != 0) {
                    this.pw.print(",");
                }
                this.pw.print(argumentType);
            }
            this.pw.print(')');
            this.pw.println();
            this.pw.println("{");
            this.pw.indent();
            String source = null;
            for (Attribute attribute : attributes = method.getAttributes()) {
                Unknown unknown;
                if (!(attribute instanceof Unknown) || !(unknown = (Unknown)attribute).getName().equals("fuego.source")) continue;
                source = new DataInputStream(new ByteArrayInputStream(unknown.getBytes())).readUTF();
                break;
            }
            Code code = method.getCode();
            this.dumpCode(code, source);
            this.pw.dedent();
            this.pw.println("}");
        }
        this.pw.dedent();
        this.pw.println("}");
    }

    private void usage() {
        System.out.println("USAGE: fad <filename>");
    }

    private void dumpCode(Code code, String source) {
        InstructionList list = new InstructionList(code.getCode());
        list.setPositions();
        Instruction[] instructions = list.getInstructions();
        int[] offsets = list.getInstructionPositions();
        String[] lines = source == null ? null : source.split("\n");
        LineNumberTable lnt = code.getLineNumberTable();
        int lastLine = 0;
        for (int i = 0; i < instructions.length; ++i) {
            int currentLine;
            int offset;
            Instruction instruction = instructions[i];
            int n = offset = i < offsets.length ? offsets[i] : 0;
            if (source != null && lnt != null && (currentLine = lnt.getSourceLine(offset)) != lastLine) {
                int start = lastLine == -1 ? 0 : lastLine;
                int end = currentLine;
                for (int l = start; l < end; ++l) {
                    this.pw.println("// (" + l + ") " + lines[l]);
                }
                lastLine = currentLine;
            }
            this.dumpInstruction(offset, instruction, code);
        }
    }

    private void dumpInstruction(int offset, Instruction instruction, Code code) {
        ConstantPool cp = code.getConstantPool();
        LineNumberTable ln = code.getLineNumberTable();
        if (ln != null) {
            this.pw.print("(0x" + Integer.toHexString(offset) + ":" + (ln.getSourceLine(offset) - 1) + ") ");
        }
        if (instruction instanceof CPInstruction) {
            CPInstruction cpInstruction = (CPInstruction)instruction;
            this.pw.println(cpInstruction.getName() + " " + this.getConstantValue(cp, cpInstruction.getIndex()));
        } else if (instruction instanceof LocalVariableInstruction) {
            LocalVariable localVariable;
            LocalVariableInstruction lvi = (LocalVariableInstruction)instruction;
            LocalVariableTable localVariableTable = code.getLocalVariableTable();
            String ref = localVariableTable == null ? "#" + lvi.getIndex() : ((localVariable = localVariableTable.getLocalVariable(lvi.getIndex())) != null ? localVariable.getName() : "#" + lvi.getIndex());
            this.pw.print(instruction.getName());
            this.pw.print(' ');
            this.pw.println(ref);
        } else if (instruction instanceof ConstantPushInstruction) {
            ConstantPushInstruction cpi = (ConstantPushInstruction)instruction;
            this.pw.println(instruction.getName() + " " + cpi.getValue());
        } else if (instruction instanceof BranchInstruction) {
            BranchInstruction branch = (BranchInstruction)instruction;
            this.pw.println(instruction.getName() + " 0x" + Integer.toHexString(branch.getIndex() + offset));
        } else if (instruction instanceof ArrayInstruction || instruction instanceof ReturnInstruction || instruction instanceof ATHROW || instruction instanceof ACONST_NULL || instruction instanceof StackInstruction || instruction instanceof StackConsumer && instruction instanceof StackProducer) {
            this.pw.println(instruction.getName());
        } else {
            this.pw.println(instruction.toString(true) + " --- " + instruction.getClass().getName());
        }
    }

    private int getLine(LineNumber[] lineNumberTable, int offset) {
        for (int i = 0; i < lineNumberTable.length; ++i) {
            LineNumber lineNumber = lineNumberTable[i];
            if (lineNumber.getStartPC() < offset) continue;
            return i;
        }
        return -1;
    }

    private String getConstantValue(ConstantPool cp, int index) {
        String result;
        try {
            Constant c = cp.getConstant(index);
            byte tag = c.getTag();
            if (c instanceof ConstantObject) {
                ConstantObject cobj = (ConstantObject)c;
                result = String.valueOf(cobj.getConstantValue(cp));
                if (tag == 8) {
                    result = "\"" + result + "\"";
                }
            } else if (c instanceof ConstantCP) {
                ConstantCP constantCP = (ConstantCP)c;
                result = this.getConstantValue(cp, constantCP.getClassIndex()) + "." + this.getConstantValue(cp, constantCP.getNameAndTypeIndex());
            } else if (c instanceof ConstantNameAndType) {
                ConstantNameAndType constantCP = (ConstantNameAndType)c;
                result = constantCP.getName(cp) + constantCP.getSignature(cp);
            } else {
                result = c.toString();
            }
        }
        catch (ClassFormatException e) {
            result = "#" + index;
        }
        return result;
    }
}

