/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.script.runtime;

import java.math.BigDecimal;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.script.reflect.Component;
import oracle.bpm.script.runtime.CompiledMethod;
import org.jetbrains.annotations.NotNull;

public class RuntimeHelper {
    @NotNull
    private final ClassLoader classLoader;

    public RuntimeHelper(@NotNull ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static CompiledMethod $compileMethod(final Object self, final String[] argName, String language, final String code) throws ScriptException {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        final ScriptEngine engine = engineManager.getEngineByMimeType(language);
        return new CompiledMethod(){

            @Override
            public Object invoke(@NotNull Object[] args) throws Throwable {
                for (int i = 0; i < argName.length; ++i) {
                    engine.put(argName[i], args[i]);
                }
                engine.put("self", self);
                engine.put("result", null);
                engine.put("BPM", new RuntimeHelper(self.getClass().getClassLoader()));
                Object result = engine.eval(code);
                return result == null ? engine.get("result") : result;
            }
        };
    }

    public Object create(String componentName) throws Throwable {
        return this.create0(componentName, new Object[0]);
    }

    public Object create(String componentName, Object arg0) throws Throwable {
        return this.create0(componentName, arg0);
    }

    public Object create(String componentName, Object arg0, Object arg1) throws Throwable {
        return this.create0(componentName, arg0, arg1);
    }

    public Object create(String componentName, Object arg0, Object arg1, Object arg2) throws Throwable {
        return this.create0(componentName, arg0, arg1, arg2);
    }

    public Object create(String componentName, Object arg0, Object arg1, Object arg2, Object arg3) throws Throwable {
        return this.create0(componentName, arg0, arg1, arg2, arg3);
    }

    public Object create(String componentName, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws Throwable {
        return this.create0(componentName, arg0, arg1, arg2, arg3, arg4);
    }

    public Time now() {
        return Time.now();
    }

    public Time time(String value) {
        return Time.valueOf(value);
    }

    public Interval interval(String value) {
        return Interval.valueOf(value);
    }

    public BigDecimal decimal(String value) {
        return new BigDecimal(value);
    }

    public BigDecimal decimal(double value) {
        return new BigDecimal(value);
    }

    private Object create0(String componentName, Object ... args) throws Throwable {
        Class<?> clazz = Class.forName(componentName, true, this.classLoader);
        Component component = new Component(clazz, args);
        return component.getInstance();
    }
}

